/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.gui;

import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;

import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.nokia.svg2svgt.converter.SVGAttribute;
import com.nokia.svg2svgt.converter.SVGElement;
import com.nokia.svg2svgt.converter.SVGNameSpace;
import com.nokia.svg2svgt.localiser.Localiser;

public class SVGPassThroughFileStorer {

	private Document document;
	private String fileName;
	private File configFile;
	private ArrayList myList;
	private Localiser myLocaliser = null;
	private boolean save = true;
	private Frame frame = null;

	/**
	 * Constructor that creates an Arraylist object to store guidelines.
	 */

	public SVGPassThroughFileStorer(ArrayList list, String path,
			Localiser localiser, boolean saveOrsaveas, Frame frame) {
		myList = list;
		myLocaliser = localiser;
		save = saveOrsaveas;
		this.frame = frame;
		try {
			createXMLdocument(PTConstants.TAG_PASSTHROUGH, path, save);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void createXMLdocument(String rootTag, String path, boolean save)
			throws Exception {
		document = null;
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		try {
			DocumentBuilder builder = factory.newDocumentBuilder();
			document = builder.newDocument();
			Element root = (Element) document.createElement(rootTag);
			document.appendChild(root);
			createNodes(root);
			writeToXmlFile(path, save);
		} catch (ParserConfigurationException pce) {
			// Parser with specified options can't be built
			pce.printStackTrace();
		}
	}

	/**
	 * 
	 * @param root
	 *            , the root e;lement "passthrough"
	 */
	public void createNodes(Element root) {
		if (null != myList) {
			Element nsNode = null;
			Element mainNode = null;
			Element elementNode = null;
			Element attributeNode = null;
			for (int i = 0; i < myList.size(); i++) {
				SVGNameSpace nameSpace = (SVGNameSpace) myList.get(i);
				if (null == nameSpace) {
					continue;
				}
				nsNode = createNode(PTConstants.TAG_NAMESPACE);
				nsNode.setAttribute(PTConstants.TAG_NAME, nameSpace
						.getnameSpaceName());
				if (null != nameSpace.getMyUri()) {

					if (true == nameSpace.isURI()) {
						nsNode.setAttribute(PTConstants.TAG_URL, nameSpace
								.getMyUri());
					} else {
						nsNode.setAttribute(PTConstants.TAG_URLCONTAINS,
								nameSpace.getMyUri());
					}
				}
				if (false != nameSpace.isWarn()) {
					nsNode.setAttribute(PTConstants.TAG_WARN,
							PTConstants.TAG_TRUE);
				}
				root.appendChild(nsNode);
				mainNode = createNode(nameSpace.getnameSpaceName());
				if (true == nameSpace.isIsallowed()) {
					mainNode.setAttribute(PTConstants.TAG_ALLOWALL,
							PTConstants.TAG_TRUE);
					root.appendChild(mainNode);
				} else {
					ArrayList elements = nameSpace.getnameSpaceElements();
					if (null != elements) {
						for (int j = 0; j < elements.size(); j++) {
							SVGElement svgElement = (SVGElement) elements
									.get(j);
							elementNode = createNode(PTConstants.TAG_ELEMENT);
							elementNode.setAttribute(PTConstants.TAG_NAME,
									svgElement.getElementName());
							if (true == svgElement.isWarned()) {
								elementNode.setAttribute(PTConstants.TAG_WARN,
										PTConstants.TAG_TRUE);
							}
							ArrayList attributes = svgElement
									.getElementAttributes();
							if (null != attributes) {

								for (int k = 0; k < attributes.size(); k++) {
									SVGAttribute attribute = (SVGAttribute) attributes
											.get(k);
									attributeNode = createNode(PTConstants.TAG_ATTRIBUTE);
									attributeNode.setAttribute(
											PTConstants.TAG_NAME, attribute
													.getAttributeName());
									if (null != attribute.getAttributeValue()) {
										attributeNode.setAttribute(
												PTConstants.TAG_VALUE,
												(String) attribute
														.getAttributeValue());
									}
									if (attribute.isWarned()) {
										attributeNode.setAttribute(
												PTConstants.TAG_WARN,
												PTConstants.TAG_TRUE);
									}
									elementNode.appendChild(attributeNode);
								}// end of inner most for
							}// end of if
							mainNode.appendChild(elementNode);
						}// end of element for
					}// end of if
					root.appendChild(mainNode);
				}// end of if
			}
		}
	}

	public void writeToXmlFile(String pathVar, boolean save) throws Exception {
		System.out.println("path" + pathVar);
		if (true == save) {
			try {
				if (!pathVar.endsWith(".xml")) {
					pathVar = pathVar + ".xml";
				}
				File f = new File(pathVar);
				TransformerFactory tFactory = TransformerFactory.newInstance();
				Transformer transformer = tFactory.newTransformer();
				System.out.println("document = " + (document == null));
				DOMSource source = new DOMSource(document);
				// pathVar = pathVar.substring( 0,pathVar.lastIndexOf( "." ) );
				StreamResult result = new StreamResult(f);
				transformer.transform(source, result);
			} catch (Exception e) {
				JOptionPane.showMessageDialog(frame, e.getMessage());
			}
		} else {
			try {
				if (!pathVar.endsWith(".xml")) {
					pathVar = pathVar + ".xml";
				}
				File f = new File(pathVar);
				TransformerFactory tFactory = TransformerFactory.newInstance();
				Transformer transformer = tFactory.newTransformer();
				System.out.println("document = " + (document == null));
				DOMSource source = new DOMSource(document);
				// pathVar = pathVar.substring( 0,pathVar.lastIndexOf( "." ) );
				int i = 0;
				while (f.exists()) {
					++i;
					String newFile = pathVar + "_" + i + "." + "xml";
					f = new File(newFile);
				}
				StreamResult result = new StreamResult(f);
				transformer.transform(source, result);
			} catch (Exception e) {
				e.printStackTrace();
				throw new Exception();
			}
		}
	}

	private Element createNode(String nodeName) {
		Element node = document.createElement(nodeName);
		return node;
	}

	class PTConstants {
		private static final String TAG_PASSTHROUGH = "passThrough";
		private static final String TAG_NAMESPACE = "namespace";
		private static final String TAG_NAME = "name";
		private static final String TAG_WARN = "warn";
		private static final String TAG_ALLOWALL = "allowAll";
		private static final String TAG_ELEMENT = "element";
		private static final String TAG_ATTRIBUTE = "attribute";
		private static final String TAG_TRUE = "true";
		private static final String TAG_FALSE = "false";
		private static final String TAG_VALUE = "value";
		private static final String TAG_URL = "url";
		private static final String TAG_URLCONTAINS = "urlcontains";
	}

}
