/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.gui;

import com.nokia.svg2svgt.localiser.Localiser;
import java.awt.Toolkit;
import javax.swing.UIManager;
import javax.swing.WindowConstants;

/**
 * <code>SVGTConverterView</code> provides the UI for the converter tool. The
 * view is created only if the tool is launched in the stand-alone mode.
 * 
 */
public class SVGTConverterView {
	/**
	 * Model associated with this view.
	 */
	public SVGTConverterModel myModel;

	/**
	 * Parent controller for this view.
	 */
	public SVGTConverterController myController;

	public Localiser myLocaliser = null;

	public SVG2SVGTMainView myMainView = null;

	/**
	 * Creates the view. Internally invokes buildUI method that creates the
	 * view.
	 * 
	 * @param myController
	 *            Parent controller for this view.
	 */
	public SVGTConverterView(SVGTConverterController myController,
			Localiser localiser) {
		this.myController = myController;
		myLocaliser = localiser;
		// ServiceRegistry.registerService( new () );
		buildUI();
	}

	/**
	 * Constructs the converter tool GUI and displays it.
	 */
	private void buildUI() {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		myMainView = new SVG2SVGTMainView(myController, myLocaliser);
		// set the size for the window
		myMainView.setSize(600, 514);
		myMainView.setIconImage(Toolkit.getDefaultToolkit().getImage(
				myLocaliser.getText("IconOfGUI")));
		myMainView.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		myMainView.setLocation(200, 120);
		myMainView.setVisible(true);
	}

	/**
	 * Sets the model associated with this view.
	 * 
	 * @param model
	 *            Model for this view.
	 */
	public void setModel(SVGTConverterModel model) {
	}

	/**
	 * Refreshes the view for any changes.
	 */
	public void refreshView() {
	}

	public void log(String desc) {
		// send this description to the TextArea on the MainView Panel
		myMainView.log(desc);
	}

}
