/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.gui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

import com.nokia.svg2svgt.util.WCMatcher;

public class SVGTFileChooser extends JDialog implements ActionListener,
		CaretListener {
	private JPanel contentPane;
	private SVGFileChooser myFileChooser = new SVGFileChooser();
	private JPanel foldersPanel = new JPanel();
	private Border border1;
	private TitledBorder titledBorder1;
	private JCheckBox subFoldersCheckBox = new JCheckBox();
	private JCheckBox folderStructCheckBox = new JCheckBox();
	private JButton addWCButton = new JButton();
	private File[] svgFiles;
	private String myParentDirectory = " ";
	Vector listOfFiles = new Vector();
	private Vector myWildCardsFiles = new Vector();
	boolean isAddOrAddWithWildCards = true;
	private String myCharSeq = null;
	private JTextField textField = null;
	private JButton openButton = null;
	private File myCurrentDirectory = null;
	private boolean canceled = false;

	public SVGTFileChooser(Frame frame, String title) {
		super(frame, true);
		this.setModal(true);
		this.setTitle(title);
		this.setResizable(false);
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
	}

	public void showCustomFileChooser() {
		try {
			jbInit();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	// Component initialization
	private void jbInit() throws Exception {
		myFileChooser.setApproveButtonText("Add");
		textField = CustomFileChooser.makeComponentInvisible(myFileChooser,
				UIManager.getString("FileChooser.filesOfTypeLabelText"));
		textField.addCaretListener(this);

		openButton = CustomFileChooser.getButton(myFileChooser, UIManager
				.getString("FileChooser.filesOfTypeLabelText"));
		if (myCurrentDirectory != null) {
			myFileChooser.setCurrentDirectory(myCurrentDirectory);
		}
		myFileChooser.setMultiSelectionEnabled(true);
		myFileChooser.setBounds(new Rectangle(4, 3, 486, 300));
		myFileChooser.addActionListener(this);

		addWCButton.setBounds(new Rectangle(340, 300, 140, 24));
		addWCButton.setRequestFocusEnabled(true);
		addWCButton.setToolTipText("");
		addWCButton.setHorizontalTextPosition(SwingConstants.CENTER);
		addWCButton.setText("Add with WildCards");
		addWCButton.addActionListener(this);

		subFoldersCheckBox.setActionCommand("jCheckBox1");
		subFoldersCheckBox.setText("Include subfolders");
		subFoldersCheckBox.setBounds(new Rectangle(5, 14, 152, 24));

		folderStructCheckBox.setText("Maintain Folder Structure");
		folderStructCheckBox.setBounds(new Rectangle(5, 32, 163, 24));

		titledBorder1 = new TitledBorder(new EtchedBorder(EtchedBorder.RAISED,
				Color.white, new Color(134, 134, 134)), "Folders");

		foldersPanel.setBorder(titledBorder1);
		foldersPanel.setBounds(new Rectangle(10, 300, 230, 64));
		foldersPanel.setLayout(null);
		foldersPanel.add(folderStructCheckBox, null);
		foldersPanel.add(subFoldersCheckBox, null);

		addWCButton.setEnabled(false);
		subFoldersCheckBox.setEnabled(false);
		folderStructCheckBox.setEnabled(false);

		myFileChooser.addActionListener(this);

		contentPane = (JPanel) this.getContentPane();
		contentPane.setLayout(null);
		contentPane.setBounds(new Rectangle(10, 484, 452, 82));
		this.setContentPane(contentPane);
		this.getContentPane().setLayout(null);
		this.getContentPane().add(addWCButton, null);
		this.getContentPane().add(myFileChooser, null);
		this.getContentPane().add(foldersPanel, null);
		this.pack();
		this.setSize(new Dimension(497, 300 + 95));
		this.show();
	}

	// Overridden so we can exit when window is closed
	protected void processWindowEvent(WindowEvent e) {
		super.processWindowEvent(e);
		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			this.dispose();
		}
	}

	public void actionPerformed(ActionEvent actionEvent) {

		if (actionEvent.getSource().equals(addWCButton)) {
			isAddOrAddWithWildCards = false;
			getConvertionFiles();
			setMyCurrentDirectory(myFileChooser.getCurrentDirectory());
			this.dispose();
		}
	}

	public void getConvertionFiles() {
		getFiles();
		getFilesWithWildCards();
	}

	private void getFilesWithWildCards() {
		myCharSeq = textField.getText();
		if (null != listOfFiles) {
			int i = 0;
			File[] svg1Files = new File[listOfFiles.size()];
			for (int k = 0; k < listOfFiles.size(); k++) {
				File f = (File) listOfFiles.get(k);
				if (true == WCMatcher.match(textField.getText(), f.getName())) {
					myWildCardsFiles.add(f);
					svg1Files[i] = f;
					i++;
				}
			}
			File[] svgFiles2 = new File[i];
			for (int k = 0; k < i; k++) {
				svgFiles2[k] = svg1Files[k];
			}
			setSVGTFiles(svgFiles2);
		}
	}

	private void getFiles() {
		File file = myFileChooser.getCurrentDirectory();
		setMyParentDirectory(file.getAbsolutePath());
		if ((null != file) && (file.exists())) {
			if (file.isDirectory()) {
				File[] files = file.listFiles();
				listOfFiles = new Vector();
				for (int i = 0; i < files.length; i++) {
					File f = files[i];
					if (f.isFile()) {
						listOfFiles.add(f);
					} else if (f.isDirectory()
							&& (subFoldersCheckBox.isSelected())) {
						getMyFiles(f);
					}
				}
			}
		}
	}

	private void getMyFiles(File f) {
		File[] files = f.listFiles();
		for (int i = 0; i < files.length; i++) {
			File f1 = files[i];
			if (f1.isFile()) {
				listOfFiles.add(f1);
			} else if (f1.isDirectory()) {
				getMyFiles(f1);
			}
		}
	}

	private void setSVGTFiles(File[] file) {
		this.svgFiles = file;
	}

	public File[] getSelectedSVGFiles() {
		return svgFiles;
	}

	public boolean isMaintainFolderStrucSelected() {
		if (true == folderStructCheckBox.isSelected()) {
			return true;
		}
		return false;
	}

	public String getMyParentDirectory() {
		return myParentDirectory;
	}

	public void setMyParentDirectory(String string) {
		myParentDirectory = string;
	}

	public Vector getMyWildCardsFiles() {
		return myWildCardsFiles;
	}

	public boolean isAddOrAddWithWildCards() {
		return isAddOrAddWithWildCards;
	}

	public String getMyCharSeq() {
		return myCharSeq;
	}

	public void caretUpdate(CaretEvent e) {
		String text = textField.getText();
		if (-1 != text.indexOf("*") || (-1 != text.indexOf("?"))) {
			addWCButton.setEnabled(true);
			subFoldersCheckBox.setEnabled(true);
			folderStructCheckBox.setEnabled(true);
		} else {
			addWCButton.setEnabled(false);
			subFoldersCheckBox.setEnabled(false);
			folderStructCheckBox.setEnabled(false);
		}
		if (0 != text.length()) {
			openButton.setEnabled(true);
		} else
			openButton.setEnabled(false);
	}

	class SVGFileChooser extends JFileChooser {
		public void approveSelection() {
			super.approveSelection();
			System.out.println("The files" + getSelectedFile().getName());
			setSVGTFiles(getSelectedFiles());
			setMyCurrentDirectory(myFileChooser.getCurrentDirectory());
			SVGTFileChooser.this.dispose();
		}

		public void cancelSelection() {
			super.cancelSelection();
			setCanceled(true);
			SVGTFileChooser.this.dispose();
		}
	}

	public File getMyCurrentDirectory() {
		return myCurrentDirectory;
	}

	public void setMyCurrentDirectory(File string) {
		myCurrentDirectory = string;
	}

	public boolean isCanceled() {
		return canceled;
	}

	public void setCanceled(boolean b) {
		canceled = b;
	}

}
