/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.gui.ext;

import com.nokia.svg2svgt.gui.ext.list.MultiSelectionComboList;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.plaf.basic.BasicArrowButton;

class MultiSelectionPopup extends JPopupMenu {
	private JMultiSelectionComboBox comboBox;

	private JScrollPane scrollPane;
	private MultiSelectionComboList list;

	private MouseListener mouseListener;

	/** Creates a new instance of MultiSelectionPopup */
	public MultiSelectionPopup(JMultiSelectionComboBox combo) {
		comboBox = combo;

		mouseListener = new InvocationMouseHandler();
		scrollPane = new JScrollPane();
		createList();

		scrollPane.getViewport().add(list);
		scrollPane.setBorder(BorderFactory.createEmptyBorder());

		add(scrollPane);
		setBorder(BorderFactory.createLineBorder(Color.BLACK));
		addPopupMenuListener(new InvocationPopupListener());
	}

	public void setData(Vector v) {
		list.setListData(v);
	}

	public void setData(Object data[]) {
		list.setListData(data);
	}

	public void addData(Object obj) {
		list.addData(obj);
	}

	Object getPrototypeCellValue() {
		return list.getPrototypeCellValue();
	}

	private void createList() {
		list = new MultiSelectionComboList();
		list.addListSelectionListener(new SelectionListener());
	}

	private void togglePopup() {
		if (isVisible()) {
			hidePopup();
		} else {
			showPopup();
		}
	}

	private void hidePopup() {
		MenuSelectionManager manager = MenuSelectionManager.defaultManager();
		manager.clearSelectedPath();
	}

	private void showPopup() {
		Rectangle rect = list.getCellBounds(0, 0);

		if (rect != null) {
			int row = Math.min(list.getVisibleRowCount(), list.getModel()
					.getSize());
			setPopupSize(comboBox.getWidth(), rect.height * row);
		} else {
			setPopupSize(comboBox.getWidth(), comboBox.getHeight());
		}

		show(comboBox, 0, comboBox.getHeight());
	}

	private class SelectionListener implements ListSelectionListener {
		int[] prevSelectedIndices;

		public void valueChanged(ListSelectionEvent e) {
			MultiSelectionComboList list = (MultiSelectionComboList) e
					.getSource();
			Object selectedItems = list.getSelectedValue();

			if (selectedItems != null) {
				String text = selectedItems.toString();

				if (text.trim().length() > 0)
					comboBox.setText(text);
			}

			if (prevSelectedIndices == null
					|| !compareIndices(prevSelectedIndices, list
							.getSelectedIndices())) {
				comboBox.firePopupSelectionChanging();
				prevSelectedIndices = list.getSelectedIndices();
			}

		}

		private boolean compareIndices(int[] i, int[] j) {
			boolean b = true;
			int iLength = i.length;
			int jLength = j.length;
			if (iLength == jLength) {
				for (int k = 0; k < iLength; k++) {
					if (i[k] != j[k]) {
						b = false;
						break;
					}
				}
			} else {
				b = false;
			}
			return b;
		}

	}

	MouseListener getMouseListener() {
		return mouseListener;
	}

	void addItem(Object data) {
		list.addData(data);
	}

	int getSelectedIndex() {
		return list.getSelectedIndex();
	}

	int[] getSelectedIndices() {
		return list.getSelectedIndices();
	}

	Object getSelectedValue() {
		return list.getSelectedValue();
	}

	Object[] getSelectedValues() {
		return list.getSelectedValues();
	}

	void removeAllElements() {
		list.clear();
	}

	void clearSelection() {
		list.clearSelection();
	}

	void selectItem(Object toBeSelected) {
		list.setSelectedValue(toBeSelected, false);
	}

	public void selectIndex(int index) {
		list.setSelectedIndex(index);
	}

	private class InvocationPopupListener implements PopupMenuListener {

		public void popupMenuCanceled(javax.swing.event.PopupMenuEvent e) {
		}

		public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
			comboBox.firePopupWillBecomeInvisible();
		}

		public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
			comboBox.firePopupWillBecomeVisible();
		}

	}

	private class InvocationMouseHandler extends MouseAdapter {

		/**
		 * Responds to mouse-pressed events on the combo box.
		 * 
		 * @param e
		 *            the mouse-press event to be handled
		 */
		public void mousePressed(MouseEvent e) {
			if (!SwingUtilities.isLeftMouseButton(e) || !comboBox.isEnabled())
				return;

			Object source = e.getSource();
			if (source instanceof BasicArrowButton) {
				togglePopup();
			}
		}
	}
}
