/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.log;

/**
 * Provides methods for raising the log events.
 * 
 */
public interface Logger {

	/**
	 * Logs the events.
	 * 
	 * @param errorCode
	 *            Message code for the log.
	 * @param params
	 *            Parameters for the message.
	 */
	public void logEvent(long errorCode, Object[] params);

	/**
	 * Logs a warning.
	 * 
	 * @param errorCode
	 *            Message code for the log.
	 * @param params
	 *            Parameters for the message.
	 */
	public void logWarning(long errorCode, Object[] params);

}
