/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.util;

/**
 * <code>WCMatcher</code> matches the given string containing wild charaters to
 * obtain the matching string from the specified target.
 * 
 */

public class WCMatcher {

	/**
	 * Compare two strings which may contain the DOS wildcard characters * and ?
	 * and return a boolean result indicating their "equivalence".
	 * 
	 * @param mask
	 *            String containing wild characters.
	 * @param target
	 *            Target string on which this pattern is applied.
	 * @return True if matches, else false.
	 */

	public static boolean match(String mask, String target) {
		// ported almost verbatim from rpb's ages old Turbo Pascal 1.0 routine
		//
		// Compare two strings which may contain the DOS wildcard characters *
		// and ?
		// and return a boolean result indicating their "equivalence".
		// e.g. WCMatcher.match("*.java", "WCMatcher.java") will return true as
		// will WCMatcher.match("w?mat*", "WCMatcher.java"). On the other hand,
		// WCMatcher.match("*.java", "WCMatcher.class") will return false (as
		// you
		// would expect). Note that the name/extension separator (i.e. the
		// period)
		// is treated like any other character in the mask or target when
		// compared
		// with one of the wildcard characters. "*" will match "hosts" or
		// "hosts."
		// or "java.exe" BUT "*." will only match a target that ends in
		// ".something"
		// Clear as mud? Try it ... it's fairly intuitive after observing a few
		// examples.
		//
		// Most usage will involve a filename mask (e.g. *.java) being
		// compared with some filename (e.g. WCMatcher.java). However,
		// either mask or target or both may contain DOS wildcard characters
		// and this routine "should" provide an arguably correct result
		//
		// Note also that this method is case insensitive! i.e. "rpb" == "RPB"
		// (as is DOS). 
		// caution - it seems to work

		int p1 = 0; // used as character index into mask
		int p2 = 0; // used as character index into target
		boolean matched = true; // Assume true to begin.
		// A warning about side effects here: an initial
		// value of false won't work!! I've just been too
		// lazy to eliminate the assumption (the routine
		// was written this way back in the early 80's)

		if ((mask.length() == 0) && (target.length() == 0)) {
			matched = true;
		} else {
			if (mask.length() == 0) {
				if (target.charAt(0) == '*')
					matched = true;
				else
					matched = false;
			} else {
				if (target.length() == 0) {
					if (mask.charAt(0) == '*')
						matched = true;
					else
						matched = false;
				}
			}
		}

		while ((matched) && (p1 < mask.length()) && (p2 < target.length())) {
			if ((mask.charAt(p1) == '?') || (target.charAt(p2) == '?')) {
				p1++;
				p2++;
			} else {
				if (mask.charAt(p1) == '*') {
					p1++;
					if (p1 < mask.length()) {
						while ((p2 < target.length())
								&& (!match(mask.substring(p1, mask.length()),
										target.substring(p2, target.length())))) {
							p2++;
						}
						if (p2 >= target.length()) {
							matched = false;
						} else {
							p1 = mask.length();
							p2 = target.length();
						}
					} else {
						p2 = target.length();
					}
				} else {
					if (target.charAt(p2) == '*') {
						p2++;
						if (p2 < target.length()) {
							while ((p1 < mask.length())
									&& (!match(mask
											.substring(p1, mask.length()),
											target.substring(p2, target
													.length())))) {
								p1++;
							}
							if (p1 >= mask.length()) {
								matched = false;
							} else {
								p1 = mask.length();
								p2 = target.length();
							}
						} else {
							p1 = mask.length();
						}
					} else {
						if (mask.toLowerCase().charAt(p1) == target
								.toLowerCase().charAt(p2)) {
							p1++;
							p2++;
						} else {
							matched = false;
						}
					}
				}
			}
		} // wend

		if (p1 >= mask.length()) {
			while ((p2 < target.length()) && (target.charAt(p2) == '*'))
				p2++;

			if (p2 < target.length())
				matched = false;
		}

		if (p2 >= target.length()) {
			while ((p1 < mask.length()) && (mask.charAt(p1) == '*'))
				p1++;

			if (p1 < mask.length())
				matched = false;
		}
		return matched;
	}
}
