/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.gui.ext;

import java.awt.Color;
import java.awt.Container;
import java.awt.Insets;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicArrowButton;

import com.nokia.svg2svgt.gui.ext.event.SelectionEvent;
import com.nokia.svg2svgt.gui.ext.event.SelectionListener;

public class JMultiSelectionComboBox extends JComponent {
	private String delimiter = ":";

	private JTextField textField;
	private BasicArrowButton arrowButton;
	private MultiSelectionPopup popup;

	private EventListenerList listenerList;

	/** Creates a new instance of JMultiSelectionComboBox */
	public JMultiSelectionComboBox() {
		listenerList = new EventListenerList();
		installUI();
	}

	public JMultiSelectionComboBox(Object[] data) {
		listenerList = new EventListenerList();
		installUI();
		popup.setData(data);
	}

	public JMultiSelectionComboBox(Vector v) {
		listenerList = new EventListenerList();
		installUI();
		popup.setData(v);
	}

	private void installUI() {
		setLayout(new BoxLayout(this, BoxLayout.X_AXIS) {
			public void layoutContainer(Container parent) {
				super.layoutContainer(parent);
				if (parent instanceof JMultiSelectionComboBox) {
					JMultiSelectionComboBox cb = (JMultiSelectionComboBox) parent;
					int width = cb.getWidth();
					int height = cb.getHeight();

					Insets insets = getInsets();
					int buttonSize = height - (insets.top + insets.bottom);

					if (arrowButton != null) {
						arrowButton.setBounds(
								width - buttonSize - insets.right, insets.top,
								buttonSize, buttonSize);
					}
					if (textField != null) {
						textField.setBounds(insets.left, insets.top, width
								- buttonSize - insets.right - insets.left,
								buttonSize);
					}
				}
			}
		});

		createTextBox();
		createArrowButton();
		createPopup();
		add(textField);
		add(arrowButton);
		configureArrowButton();
		configureTextBox();
		setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
		setRequestFocusEnabled(true);
		// addFocusListener(new ComboFocusListener());
	}

	private void createTextBox() {
		textField = new JTextField(500);
		textField.setEditable(true);
		textField.setBackground(Color.white);
		textField.setBorder(BorderFactory.createEmptyBorder());
		textField.addCaretListener(new CaretListener() {

			public void caretUpdate(CaretEvent e) {
				if (popup != null && textField.isEditable()) {
					popup.clearSelection();
				}
			}
		});
	}

	private void createArrowButton() {
		arrowButton = new BasicArrowButton(SwingConstants.SOUTH);
	}

	private void createPopup() {
		popup = new MultiSelectionPopup(this);
	}

	private void configureArrowButton() {
		arrowButton.addMouseListener(popup.getMouseListener());
	}

	private void configureTextBox() {
		textField.addMouseListener(popup.getMouseListener());
	}

	protected void firePopupWillBecomeInvisible() {
		// Never returns null
		Object[] listeners = listenerList.getListeners(SelectionListener.class);
		SelectionEvent eventObj = null;
		// Process the listeners last to first, notifying
		// those that are interested in this event
		for (int i = listeners.length - 1; i >= 0; i--) {
			// Lazily create the event:
			if (eventObj == null)
				eventObj = new SelectionEvent(this);
			((SelectionListener) listeners[i]).selectionOver(eventObj);
		}
	}

	protected void firePopupWillBecomeVisible() {

	}

	protected void firePopupSelectionChanging() {
		// Never returns null
		Object[] listeners = listenerList.getListeners(SelectionListener.class);
		SelectionEvent eventObj = null;
		// Process the listeners last to first, notifying
		// those that are interested in this event
		for (int i = listeners.length - 1; i >= 0; i--) {
			// Lazily create the event:
			if (eventObj == null)
				eventObj = new SelectionEvent(this);
			((SelectionListener) listeners[i]).selectionChanged(eventObj);
		}
	}

	void setText(String text) {
		textField.setEditable(false);
		textField.setText(text);
		textField.setCaretPosition(0);
		textField.setEditable(true);
	}

	public void addSelectionListener(SelectionListener l) {
		listenerList.add(SelectionListener.class, l);
	}

	public void setDelimiter(String delim) {
		delimiter = delim;
	}

	public String getDelimiter() {
		return delimiter;
	}

	public void addItem(Object data) {
		popup.addItem(data);
	}

	public int getSelectedIndex() {
		return popup.getSelectedIndex();
	}

	public int[] getSelectedIndices() {
		return popup.getSelectedIndices();
	}

	public Object getSelectedValue() {
		Object obj = popup.getSelectedValue();

		if (obj == null) {
			String newText = textField.getText();
			if ((newText != null) && (newText.trim()).length() > 0) {
				obj = newText;
			}
		}
		return obj;
	}

	public Object[] getSelectedValues() {
		return popup.getSelectedValues();
	}

	public void removeAll() {
		textField.setText("");
		popup.removeAllElements();
	}

	public void setSelectedIndex(int index) {
		popup.selectIndex(index);
	}

	public void setSelectedItem(Object toBeSelected) {
		popup.selectItem(toBeSelected);
	}

}
