# compare_baselines.py takes two lists of baselines produced by find_public_apis.pl
# and compares them for added, removed and moved headers as well as api class change
#
# outputs report as csv
#
# usage: python compare_baselines.py <baseline1> <baseline2>

import sys

# parse a baseline file produced by find_public_apis.pl into a map
def parse_baseline(filename):
	file = open(filename)
	count = 0
	db = {}
	
	for line in file:
		if count > 0:
			tokens = line.split()
			pathname = tokens[0].strip().lower() # watch out for lowecasing here!
			apiclass = tokens[1].strip()
			apiclassreason = tokens[2].strip()

			dbentry = {'pathname': pathname, 'class': apiclass, 'reason': apiclassreason, 'duplicate':''}
			
			filename = strip_path(pathname)
		
			if db.has_key(filename):
				db[filename]['duplicate'] = pathname
#				print >> sys.stderr, 'duplicate filename at paths %s and %s' % (pathname, db[filename]['pathname'])
			else:
				db[filename] = dbentry
				
		count = count + 1	

	return db
	
# strip pathnames from filenames
def strip_path(pathname):
	while pathname.find('/') != -1:
		x=pathname.find('/')
		pathname = pathname[x+1:]
	
	return pathname.lower()

def compare_dbs(db1, db2):
	print 'apiname,status,classchange,class1,class2,pathname1,pathname2,duplicate1,duplicate2'

	for key in db1.keys():
		db1entry = db1[key]
		status = 'ok'
		if db2.has_key(key):
			db2entry = db2[key]
			
			# filename exists, does path match?
			if db1entry['pathname'] != db2entry['pathname']:
				status = 'moved'

			# does class match?
			if db1entry['class'] != db2entry['class']:
				classchange = 'yes'
			else:
				classchange = 'no'
				
			print '%s,%s,%s,%s,%s,%s,%s,%s,%s' % (key, status, classchange,db1entry['class'],db2entry['class'],db1entry['pathname'], db2entry['pathname'],db1entry['duplicate'],db2entry['duplicate'])
		else:
			status = 'removed'
			print '%s,%s,%s,%s,%s,%s,%s,%s,%s' % (key, status, 'no',db1entry['class'],'',db1entry['pathname'], '',db1entry['duplicate'],'')
			
		
	for key in db2.keys():
		if not db1.has_key(key):
			db2entry = db2[key]
			status = 'added'
			print '%s,%s,%s,%s,%s,%s,%s,%s,%s' % (key, status, 'no','',db2entry['class'],'',db2entry['pathname'], '',db2entry['duplicate'])
		
			
			# handle duplicates
	
		

# read the list of published filenames
bl1name = sys.argv[1]
bl2name = sys.argv[2]

db1 = parse_baseline(bl1name)
db2 = parse_baseline(bl2name)

compare_dbs(db1, db2)
