import xml.dom.minidom
import sys

headers = []
libraryissues = []

def loadfile(filename):
	x = xml.dom.minidom.parse(filename)
	issuelists=x.getElementsByTagName('issuelist')

	
	for issuelist in issuelists:
		for cn in issuelist.childNodes:
			if isinstance(cn, xml.dom.minidom.Element):
				if cn.nodeName == 'library':
					libraryissues.append(cn)
				elif cn.nodeName == 'headerfile':
					headers.append(cn)


typeidmap=['removed', '','moved','deleted','inserted','modified','added','modified','modified','modified','modified','modified','removed','N/A','','']

noktypemaphdr={
			'NOK': 'This header contains changes that cause incompatibility. It must be fixed.', 
			'MOK': 'This header contains changes that cannot be verified automatically; they must be investigated manually.'}

ioktypehdr='This issue is known to be ok. But the header contains other unrelated changes.'
oktypehdr='This header is known to be ok.'
othertypehdr='This header contains changes that may cause incompatibility. It must be analysed by an expert.'

oktype='This library is known to be ok'
noktype='This library contains changes that cause incompatibility. It must be fixed.'
othertype='This library contains changes that may cause incompatibility. It must be analysed by an expert.'

#
#
#typeidmap=['removed', '','moved','deleted','inserted','modified','added','modified','modified','modified','modified','modified','removed','N/A','','']
#
#oktypemaphdr={'OK': 'This header is known to be ok.',
#			'NOK': 'This header contains changes that cause incompatibility. It must be fixed.', 
#			'IOK': 'This issue is known to be ok. But the header contains other unrelated changes.', 
#			'MOK': 'This header contains changes that cannot be verified automatically; they must be investigated manually.'}
#
#othertypemaphdr='This header contains changes that may cause incompatibility. It must be analysed by an expert.'
#
#oktype='This library is known to be ok'
#noktype='This library contains changes that cause incompatibility. It must be fixed.'
#othertype='This library contains changes that may cause incompatibility. It must be analysed by an expert.'


				

def print_errors(library, isok=False):

	if isok:
		libstatus = oktype
		bug_severity='NORMAL'
		bug_status='RESOLVED'
		resolution='WONTFIX'
	else:
		libstatus = othertype
		bug_severity='MAJOR'
		bug_status='NEW'
		resolution=''
		
	for issue in library['issues']:
		if issue['status'] == 'NOK':
			libstatus = noktype
			bug_severity='CRITICAL'
			bug_status='NEW'
			resolution=''


	short_desc = 'Compatibility break in library %s' % library['shortname']
	
	library_info='Library details<br>name: %s<br>shortname: %s<br>comparefilename: %s<br>baseplatform: %s<br>currentplatform: %s' % (library['name'], library['shortname'], library['comparefilename'], library['baseplatform'], library['currentplatform'])
	
	long_desc = libstatus + '<br>'
	for issue in library['issues']:
		if issue['funcpos'] == '':
			if issue['newfuncpos'] != '':
				pos = issue['newfuncpos']
			else:
				pos = '-'
		elif issue['newfuncpos'] != '':
			pos = '%s->%s' % (issue['funcpos'], issue['newfuncpos'])
		else:
			pos = issue['funcpos']
		
		if issue['funcname'] != '':
			if issue['newfuncname'] != '':
				funcstring = 'was %s; now %s' % (issue['funcname'], issue['newfuncname'])
			else:
				funcstring = issue['funcname']
		elif issue['newfuncname'] != '':
			funcstring = issue['newfuncname']
		else:
			funcstring = ''
		
		long_desc = long_desc + '[%s] (%s) %s %s (%s) [BC: %s, SC:%s]<br>%s' % (pos, typeidmap[issue['typeid']-1], issue['typeinfo'], funcstring, issue['comment'], issue['bc_severity'], issue['sc_severity'], library_info)
		
	
	product=library['shortname']
	reporter='BC checker'
	assigned_to=''
	backlog_url=''
	deadline=''
	assigned_to=''
	version='unspecified'
	component=''
	rep_platform='N/A'
	keywords='Symbian^2, Compatibility_Break'
	
	print "%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s" % (product, reporter, assigned_to, bug_severity, backlog_url, short_desc, long_desc, deadline, bug_status, resolution, version, component, rep_platform, keywords)
			
		
def list_libraryissues():
	libissues=[]
	for li in libraryissues:
	
		try:
			name=li.getElementsByTagName('name')[0].childNodes[0].wholeText
		except:
			name=''
		try:
			shortname=li.getElementsByTagName('shortname')[0].childNodes[0].wholeText
		except:
			shortname=''

		try:
			comparefilename=li.getElementsByTagName('comparefilename')[0].childNodes[0].wholeText
		except:
			comparefilename=''
		
		try:
			baseplatform=li.getElementsByTagName('baseplatform')[0].childNodes[0].wholeText
		except:
			baseplatform=''

		try:
			currentplatform=li.getElementsByTagName('currentplatform')[0].childNodes[0].wholeText
		except:
			currentplatform=''

		try:
			issues=li.getElementsByTagName('issue')
			issuelist = []
			for issue in issues:
				try:
					typeid=int(issue.getElementsByTagName('typeid')[0].childNodes[0].wholeText)
				except:
					typeid=-1
				try:
					funcname=issue.getElementsByTagName('funcname')[0].childNodes[0].wholeText
				except:
					funcname=''
				try:
					newfuncname=issue.getElementsByTagName('newfuncname')[0].childNodes[0].wholeText
				except:
					newfuncname=''	
				try:
					funcpos=issue.getElementsByTagName('funcpos')[0].childNodes[0].wholeText
				except:
					funcpos=''	
				try:
					newfuncpos=issue.getElementsByTagName('newfuncpos')[0].childNodes[0].wholeText
				except:
					newfuncpos=''	
				try:
					bc_severity=issue.getElementsByTagName('bc_severity')[0].childNodes[0].wholeText
				except:
					bc_severity=''
				try:
					sc_severity=issue.getElementsByTagName('sc_severity')[0].childNodes[0].wholeText
				except:
					sc_severity=''
				try:
					status=issue.getElementsByTagName('status')[0].childNodes[0].wholeText
				except:
					status=''
				try:
					typeinfo=issue.getElementsByTagName('typeinfo')[0].childNodes[0].wholeText
				except:
					typeinfo=''	
				try:
					comment=issue.getElementsByTagName('comment')[0].childNodes[0].wholeText
				except:
					comment=''					
				anissue={'typeid': typeid, 'funcname':funcname, 'newfuncname':newfuncname, 'funcpos': funcpos, 'newfuncpos': newfuncpos, 'bc_severity': bc_severity, 'sc_severity': sc_severity, 'status': status, 'typeinfo': typeinfo, 'comment': comment}
				issuelist.append(anissue)
		except:
			pass
		
		libissue = {'name': name, 'shortname': shortname, 'comparefilename': comparefilename, 'baseplatform': baseplatform, 'currentplatform': currentplatform, 'issues': issuelist}
		libissues.append(libissue)
	
	summ = 0
	libsok = []
	libsnotok = []

	for libiss in libissues:
		nokcount = 0
		mokcount = 0
		okcount = 0
		othercount = 0
	
		for iss in libiss['issues']:
		
			if iss['status'] == 'NOK':
				nokcount=nokcount+1
			elif iss['status'] == 'MOK':
				mokcount=mokcount+1
			elif iss['status'] == 'OK':
				okcount=okcount+1
			elif iss['status'] == '' and iss['typeid'] != 7 and iss['typeid'] != 2:
				othercount = othercount+1
			
		if nokcount == 0 and mokcount == 0 and okcount > 0 and othercount == 0:
			libsok.append(libiss)
		elif nokcount > 0 or othercount > 0:
			libsnotok.append(libiss)
		
	for l in libsnotok:
		print_errors(l)	
	
	for l in libsok:
		print_errors(l, True)

def print_header_errors(header):

	if header['status']=='OK':
		headerstatus = oktypehdr
		bug_severity='NORMAL'
		bug_status='RESOLVED'
		resolution='WONTFIX'
	elif header['status']=='IOK':
		headerstatus = ioktypehdr
		bug_severity='NORMAL'
		bug_status='RESOLVED'
		resolution='WONTFIX'
	elif header['status'] != '':
		headerstatus = noktypemaphdr[header['status']]
		bug_severity='CRITICAL'
		bug_status='NEW'
		resolution=''
	else:
		headerstatus = othertypehdr
		bug_severity='MAJOR'
		bug_status='NEW'
		resolution=''

	short_desc = 'Compatibility break in header %s' % (header['shortname'])

	
	headerinfo='Header details<br>filename: %s<br>shortname: %s<br>comparefilename: %s' % (header['filename'], header['shortname'], header['comparefilename'])

	
	if header['status'] == 'OK':
		long_desc = headerstatus + ' Comment: ' + header['comment'] + '<br>'
	else:
		long_desc = headerstatus + ' '
			
	for issue in header['issues']:
		long_desc = long_desc + '%s %s %s [BC: %s, SC:%s]<br>%s' % (issue['identitydescription'], issue['typestring'], issue['cause'], issue['bc_severity'], issue['sc_severity'], headerinfo)
		
	
	product=header['shortname']
	reporter='BC checker'
	assigned_to=''
	backlog_url=''
	deadline=''
	assigned_to=''
	version='unspecified'
	component=''
	rep_platform='N/A'
	keywords='Symbian^2, Compatibility_Break'

	
	print "%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s" % (product, reporter, assigned_to, bug_severity, backlog_url, short_desc, long_desc, deadline, bug_status, resolution, version, component, rep_platform, keywords)
			
		
def list_headerissues():
	headerissues=[]
	for hi in headers:

		try:
			filename=hi.getElementsByTagName('filename')[0].childNodes[0].wholeText
		except:
			filename=''
			
		try:
			shortname=hi.getElementsByTagName('shortname')[0].childNodes[0].wholeText
		except:
			shortname=''
			
		try:
			comparefilename=hi.getElementsByTagName('comparefilename')[0].childNodes[0].wholeText
		except:
			comparefilename=''

		try:
			status=hi.getElementsByTagName('status')[0].childNodes[0].wholeText
		except:
			status=''
		
		try:
			comment=hi.getElementsByTagName('comment')[0].childNodes[0].wholeText
		except:
			comment=''

		try:
			checksum=hi.getElementsByTagName('checksum')[0].childNodes[0].wholeText
		except:
			checksum=''

		try:
			issues=hi.getElementsByTagName('issue')
			issuelist = []
			for issue in issues:
				try:
					issueid=int(issue.getElementsByTagName('issueid')[0].childNodes[0].wholeText)
				except:
					issueid=-1
					
				try:
					typeid=int(issue.getElementsByTagName('typeid')[0].childNodes[0].wholeText)
				except:
					typeid=-1
				try:
					identityid=issue.getElementsByTagName('identityid')[0].childNodes[0].wholeText
				except:
					identityid=''
				try:
					identitydescription=issue.getElementsByTagName('identitydescription')[0].childNodes[0].wholeText
				except:
					identitydescription=''
						
				try:
					typestring=issue.getElementsByTagName('typestring')[0].childNodes[0].wholeText
				except:
					typestring=''
						
				try:
					cause=issue.getElementsByTagName('cause')[0].childNodes[0].wholeText
				except:
					cause=''
				
				try:
					ignoreinformation=issue.getElementsByTagName('ignoreinformation')[0].childNodes[0].wholeText
				except:
					ignoreinformation=''
					
				try:
					documentation=issue.getElementsByTagName('documentation')[0].childNodes[0].wholeText
				except:
					documentation=''
				
				try:
					linenumber=issue.getElementsByTagName('linenumber')[0].childNodes[0].wholeText
				except:
					linenumber=''
					
				try:
					sc_severity=issue.getElementsByTagName('scseverity')[0]
			
					try:
						typeid=sc_severity.getElementsByTagName('typeid')[0].childNodes[0].wholeText
					except:
						typeid=''


					try:
						sctypestring=sc_severity.getElementsByTagName('typestring')[0].childNodes[0].wholeText
					except:
						sctypestring=''
					
					sc_severity=sctypestring				
				except:
					sc_severity=''
	
				try:
					bc_severity=issue.getElementsByTagName('severity')[0]
					
					try:
						typeid=bc_severity.getElementsByTagName('typeid')[0].childNodes[0].wholeText
					except:
						typeid=''


					try:
						bctypestring=bc_severity.getElementsByTagName('typestring')[0].childNodes[0].wholeText
					except:
						bctypestring=''
					
					bc_severity=bctypestring				
				except:
					bc_severity=''
																			
				anissue={'issueid': issueid, 'typeid': typeid, 'identityid': identityid, 'identitydescription': identitydescription, 'typestring': typestring, 'cause': cause, 'ignoreinformation': ignoreinformation, 'documentation': documentation, 'linenumber': linenumber, 'bc_severity': bc_severity, 'sc_severity': sc_severity}
				issuelist.append(anissue)
		except:
			print 'except!'
		
		headerissue = {'filename': filename, 'shortname': shortname, 'comparefilename': comparefilename, 'status': status, 'comment': comment, 'checksum': checksum, 'issues': issuelist}
		headerissues.append(headerissue)

	for l in headerissues:
		print_header_errors(l)


if len(sys.argv) < 2:
	print 'usage: python issuelist.py <reportfile1.xml> [reportfile2.xml]'
elif len(sys.argv) >= 2:
	loadfile(sys.argv[1])
	if len(sys.argv) > 2:
			loadfile(sys.argv[2])
	
	print "%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s" % ('product', 'reporter', 'assigned_to', 'bug_severity', 'backlog_url', 'short_desc', 'long_desc', 'deadline', 'bug_status', 'resolution', 'version', 'component', 'rep_platform','keywords')

	list_headerissues()
	list_libraryissues()

