#!/usr/bin/perl

use Getopt::Long;
my $log_file;
my $log_data;




sub printhelp
{
  print "\ncounting commits in log file
  \noptions:
  \n\t-f (mandaory) mercurial access log file\n";
  exit;

}

sub cmd_options
{

  my $help;
  


  GetOptions('h' => \$help,'f=s'=> \$log_file);

  
  if ($help) {
    printhelp;
  }
  
  if (not $log_file) {
    print "ERROR  - LOG File not provided\n ";
    printhelp;
  }

                                    

}


#main
cmd_options();

open(DATA, "<".$log_file);
open(COMMITOUT, ">output_commits.csv");

while (<DATA>){
     $log_data = $_;
     if ($log_data =~ m/POST/ & $log_data =~ m/MCL(.*?)\?.*?\" 200 /)  { 
        $pkg = $1;
        if ($log_data =~ m/([0-9]+)\/([A-z]+)\/([0-9]+)/) {
          
          $tcommit = $1."-".$2."-".$3;   
            
        } else {
          $tcommit = "NOTFOUND_TIME";
        }
        
        if ($log_data =~ m/(\d+\.\d+\.\d+\.\d+)/) {
          
          $ipcommit = $1;   
            
        } else {
          $ipcommit = "NOTFOUND_IP";
        }
        
        
        print COMMITOUT "$pkg\t$tcommit\t$ipcommit\n"; 
     }

}

close (DATA);
close (COMMITOUT);