/*
* Copyright (c) 2007 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  Resource lookup functions for the Camera Application*
*/



#ifndef CAM_RESOURCE_LOOKUP_H
#define CAM_RESOURCE_LOOKUP_H

#include "CamResourceIDs.h"
#include <cameraapp.rsg>
#include <vgacamsettings.rsg>
#include "CamAppUiBase.h"

const TInt KRoidLookup[R_CAM_LAST_RESOURCE_ID+1][ECamOrientationTotal] = 
{
// Order of resources: Camcorder Right, Portrait, View, Camcorder Left

// 0:
    { R_CAM_STILL_PRE_CAPTURE_VIEW_CAMCORDER, R_CAM_STILL_PRE_CAPTURE_VIEW_PORTRAIT, R_CAM_STILL_PRE_CAPTURE_VIEW_PORTRAIT, R_CAM_STILL_PRE_CAPTURE_VIEW_CAMCORDER },
    { R_CAM_STILL_PRE_CAPTURE_MENUBAR_CAMCORDER, R_CAM_STILL_PRE_CAPTURE_MENUBAR_PORTRAIT, R_CAM_STILL_PRE_CAPTURE_MENUBAR_PORTRAIT, R_CAM_STILL_PRE_CAPTURE_MENUBAR_CAMCORDER },
    { R_CAM_STILL_PRE_CAPTURE_MENU_CAMCORDER, R_CAM_STILL_PRE_CAPTURE_MENU_PORTRAIT, R_CAM_STILL_PRE_CAPTURE_MENU_PORTRAIT, R_CAM_STILL_PRE_CAPTURE_MENU_CAMCORDER },
    { R_CAM_STILL_POST_CAPTURE_VIEW_CAMCORDER, R_CAM_STILL_POST_CAPTURE_VIEW_PORTRAIT, R_CAM_STILL_POST_CAPTURE_VIEW_PORTRAIT, R_CAM_STILL_POST_CAPTURE_VIEW_CAMCORDER },
    { R_CAM_STILL_POST_CAPTURE_MENUBAR_CAMCORDER , R_CAM_STILL_POST_CAPTURE_MENUBAR_PORTRAIT, R_CAM_STILL_POST_CAPTURE_MENUBAR_PORTRAIT, R_CAM_STILL_POST_CAPTURE_MENUBAR_CAMCORDER },
    { R_CAM_STILL_POST_CAPTURE_MENU_CAMCORDER, R_CAM_STILL_POST_CAPTURE_MENU_PORTRAIT, R_CAM_STILL_POST_CAPTURE_MENU_PORTRAIT, R_CAM_STILL_POST_CAPTURE_MENU_CAMCORDER },
    { R_CAM_STILL_POST_CAPTURE_OK_MENUBAR, R_CAM_STILL_POST_CAPTURE_OK_MENUBAR, R_CAM_STILL_POST_CAPTURE_OK_MENUBAR, R_CAM_STILL_POST_CAPTURE_OK_MENUBAR },
    { R_CAM_STILL_POST_CAPTURE_OK_MENU, R_CAM_STILL_POST_CAPTURE_OK_MENU, R_CAM_STILL_POST_CAPTURE_OK_MENU, R_CAM_STILL_POST_CAPTURE_OK_MENU },
    { R_CAM_VIDEO_PRE_CAPTURE_VIEW_CAMCORDER, R_CAM_VIDEO_PRE_CAPTURE_VIEW_PORTRAIT, R_CAM_VIDEO_PRE_CAPTURE_VIEW_PORTRAIT, R_CAM_VIDEO_PRE_CAPTURE_VIEW_CAMCORDER },
    { R_CAM_VIDEO_PRE_CAPTURE_MENUBAR_CAMCORDER, R_CAM_VIDEO_PRE_CAPTURE_MENUBAR_PORTRAIT, R_CAM_VIDEO_PRE_CAPTURE_MENUBAR_PORTRAIT, R_CAM_VIDEO_PRE_CAPTURE_MENUBAR_CAMCORDER },
// 10:
    { R_CAM_VIDEO_PRE_CAPTURE_MENU_CAMCORDER, R_CAM_VIDEO_PRE_CAPTURE_MENU_PORTRAIT, R_CAM_VIDEO_PRE_CAPTURE_MENU_PORTRAIT, R_CAM_VIDEO_PRE_CAPTURE_MENU_CAMCORDER },
    { R_CAM_VIDEO_POST_CAPTURE_VIEW_CAMCORDER, R_CAM_VIDEO_POST_CAPTURE_VIEW_PORTRAIT, R_CAM_VIDEO_POST_CAPTURE_VIEW_VIEWMODE, R_CAM_VIDEO_POST_CAPTURE_VIEW_CAMCORDER },
    { R_CAM_VIDEO_POST_CAPTURE_MENUBAR_CAMCORDER , R_CAM_VIDEO_POST_CAPTURE_MENUBAR_PORTRAIT, R_CAM_VIDEO_POST_CAPTURE_MENUBAR_VIEWMODE, R_CAM_VIDEO_POST_CAPTURE_MENUBAR_CAMCORDER },
    { R_CAM_VIDEO_POST_CAPTURE_MENU_CAMCORDER , R_CAM_VIDEO_POST_CAPTURE_MENU_PORTRAIT, R_CAM_VIDEO_POST_CAPTURE_MENU_VIEWMODE, R_CAM_VIDEO_POST_CAPTURE_MENU_CAMCORDER },
    { R_CAM_VIDEO_POST_CAPTURE_OK_MENUBAR, R_CAM_VIDEO_POST_CAPTURE_OK_MENUBAR, R_CAM_VIDEO_POST_CAPTURE_OK_MENUBAR, R_CAM_VIDEO_POST_CAPTURE_OK_MENUBAR },
    { R_CAM_VIDEO_POST_CAPTURE_OK_MENU, R_CAM_VIDEO_POST_CAPTURE_OK_MENU, R_CAM_VIDEO_POST_CAPTURE_OK_MENU, R_CAM_VIDEO_POST_CAPTURE_OK_MENU },
    { R_CAM_STILL_EMBEDDED_PRE_CAPTURE_MENUBAR_CAMCORDER, R_CAM_STILL_EMBEDDED_PRE_CAPTURE_MENUBAR_PORTRAIT, R_CAM_STILL_EMBEDDED_PRE_CAPTURE_MENUBAR_PORTRAIT, R_CAM_STILL_EMBEDDED_PRE_CAPTURE_MENUBAR_CAMCORDER },
    { R_CAM_VIDEO_EMBEDDED_PRE_CAPTURE_MENUBAR_CAMCORDER, R_CAM_VIDEO_EMBEDDED_PRE_CAPTURE_MENUBAR_PORTRAIT, R_CAM_VIDEO_EMBEDDED_PRE_CAPTURE_MENUBAR_PORTRAIT, R_CAM_VIDEO_EMBEDDED_PRE_CAPTURE_MENUBAR_CAMCORDER },
    { R_CAM_STILL_EMBEDDED_PRE_CAPTURE_MENU_CAMCORDER, R_CAM_STILL_EMBEDDED_PRE_CAPTURE_MENU_PORTRAIT, R_CAM_STILL_EMBEDDED_PRE_CAPTURE_MENU_PORTRAIT, R_CAM_STILL_EMBEDDED_PRE_CAPTURE_MENU_CAMCORDER },
    { R_CAM_VIDEO_EMBEDDED_PRE_CAPTURE_MENU_CAMCORDER, R_CAM_VIDEO_EMBEDDED_PRE_CAPTURE_MENU_PORTRAIT, R_CAM_VIDEO_EMBEDDED_PRE_CAPTURE_MENU_PORTRAIT, R_CAM_VIDEO_EMBEDDED_PRE_CAPTURE_MENU_CAMCORDER },
// 20:
    { R_CAM_IMG_PRECAP_IMGCOUNTER, R_CAM_IMG_PRECAP_IMGCOUNTER_PORTRAIT, R_CAM_IMG_PRECAP_IMGCOUNTER_VIEWMODE, R_CAM_IMG_PRECAP_IMGCOUNTER_LEFT },
    { R_CAM_IMG_PRECAP_IMGCOUNTER_AH, R_CAM_IMG_PRECAP_IMGCOUNTER_AH_PORTRAIT, R_CAM_IMG_PRECAP_IMGCOUNTER_AH_VIEWMODE, R_CAM_IMG_PRECAP_IMGCOUNTER_AH_LEFT },
    { R_CAM_VIDEO_PRECAP_REMAINING_TIME, R_CAM_VIDEO_PRECAP_REMAINING_TIME_PORTRAIT, R_CAM_VIDEO_PRECAP_REMAINING_TIME_VIEWMODE, R_CAM_VIDEO_PRECAP_REMAINING_TIME_LEFT },
    { R_CAM_VIDEO_PRECAP_REMAINING_TIME_AH, R_CAM_VIDEO_PRECAP_REMAINING_TIME_AH_PORTRAIT, R_CAM_VIDEO_PRECAP_REMAINING_TIME_AH_VIEWMODE, R_CAM_VIDEO_PRECAP_REMAINING_TIME_AH_LEFT },
    { R_CAM_COUNTER_ICON_RECT_CAMCORDER, R_CAM_COUNTER_ICON_RECT_PORTRAIT, R_CAM_COUNTER_ICON_RECT_VIEWMODE, R_CAM_COUNTER_ICON_RECT_CAMCORDER_LEFT },
    { R_CAM_COUNTER_ICON_RECT_AH_CAMCORDER, R_CAM_COUNTER_ICON_RECT_AH_PORTRAIT, R_CAM_COUNTER_ICON_RECT_AH_VIEWMODE, R_CAM_COUNTER_ICON_RECT_AH_CAMCORDER_LEFT },
    { R_CAM_VIDEO_CAP_LIMIT_MEMORY_LOCATION, R_CAM_VIDEO_CAP_LIMIT_MEMORY_LOCATION_PORTRAIT, R_CAM_VIDEO_CAP_LIMIT_MEMORY_LOCATION_VIEWMODE, R_CAM_VIDEO_CAP_LIMIT_MEMORY_LOCATION_LEFT },
    { R_CAM_RECPAUSE_INDICATOR_LAYOUT_VID_MAIN_RECT_CAMCORDER, R_CAM_RECPAUSE_INDICATOR_LAYOUT_VID_MAIN_RECT_PORTRAIT, R_CAM_RECPAUSE_INDICATOR_LAYOUT_VID_MAIN_RECT_VIEWMODE, R_CAM_RECPAUSE_INDICATOR_LAYOUT_VID_MAIN_RECT_CAMCORDER_LEFT },
    { R_CAM_VIDEO_CAP_LIMIT_MEMORY_LOCATION_AH, R_CAM_VIDEO_CAP_LIMIT_MEMORY_LOCATION_AH_PORTRAIT, R_CAM_VIDEO_CAP_LIMIT_MEMORY_LOCATION_AH_VIEWMODE, R_CAM_VIDEO_CAP_LIMIT_MEMORY_LOCATION_AH_LEFT },
    { R_CAM_VIDEO_CAP_LIMITED_ELAPSED_TIME, R_CAM_VIDEO_CAP_LIMITED_ELAPSED_TIME_PORTRAIT, R_CAM_VIDEO_CAP_LIMITED_ELAPSED_TIME_VIEWMODE, R_CAM_VIDEO_CAP_LIMITED_ELAPSED_TIME_LEFT },
// 30:
    { R_CAM_VIDEO_CAP_LIMITED_ELAPSED_TIME_AH, R_CAM_VIDEO_CAP_LIMITED_ELAPSED_TIME_AH_PORTRAIT, R_CAM_VIDEO_CAP_LIMITED_ELAPSED_TIME_AH_VIEWMODE, R_CAM_VIDEO_CAP_LIMITED_ELAPSED_TIME_AH_LEFT },
    { R_CAM_VIDEO_CAP_LIMITED_REMAINING_TIME, R_CAM_VIDEO_CAP_LIMITED_REMAINING_TIME_PORTRAIT, R_CAM_VIDEO_CAP_LIMITED_REMAINING_TIME_VIEWMODE, R_CAM_VIDEO_CAP_LIMITED_REMAINING_TIME_LEFT },
    { R_CAM_VIDEO_CAP_LIMITED_REMAINING_TIME_AH, R_CAM_VIDEO_CAP_LIMITED_REMAINING_TIME_AH_PORTRAIT, R_CAM_VIDEO_CAP_LIMITED_REMAINING_TIME_AH_VIEWMODE, R_CAM_VIDEO_CAP_LIMITED_REMAINING_TIME_AH_LEFT },
    { R_CAM_VIDEO_CAP_LIMIT_PROGRESS_BAR, R_CAM_VIDEO_CAP_LIMIT_PROGRESS_BAR_PORTRAIT, R_CAM_VIDEO_CAP_LIMIT_PROGRESS_BAR_VIEWMODE, R_CAM_VIDEO_CAP_LIMIT_PROGRESS_BAR_LEFT },
    { R_CAM_VIDEO_CAP_LIMIT_PROGRESS_BAR_AH, R_CAM_VIDEO_CAP_LIMIT_PROGRESS_BAR_AH_PORTRAIT, R_CAM_VIDEO_CAP_LIMIT_PROGRESS_BAR_AH_VIEWMODE, R_CAM_VIDEO_CAP_LIMIT_PROGRESS_BAR_AH_LEFT },
    { R_CAM_SCENE_SETTING_MENUBAR, R_CAM_SCENE_SETTING_MENUBAR, R_CAM_SCENE_SETTING_MENUBAR, R_CAM_SCENE_SETTING_MENUBAR },
    { R_CAM_SCENE_SETTING_MENU, R_CAM_SCENE_SETTING_MENU, R_CAM_SCENE_SETTING_MENU, R_CAM_SCENE_SETTING_MENU },
    { R_CAM_SIDEPANE_CAMCORDER, R_CAM_SIDEPANE_PORTRAIT, R_CAM_SIDEPANE_VIEWMODE, R_CAM_SIDEPANE_CAMCORDER },
    { R_CAM_SCENE_MAX_ITEMS_TO_DISPLAY, R_CAM_SCENE_MAX_ITEMS_TO_DISPLAY, R_CAM_SCENE_MAX_ITEMS_TO_DISPLAY, R_CAM_SCENE_MAX_ITEMS_TO_DISPLAY },
    { R_CAM_SCENE_TITLE_NORMAL_ARRAY_CAMCORDER, R_CAM_SCENE_TITLE_NORMAL_ARRAY_PORTRAIT, R_CAM_SCENE_TITLE_NORMAL_ARRAY_VIEWMODE, R_CAM_SCENE_TITLE_NORMAL_ARRAY_CAMCORDER },
// 40:    
    { R_CAM_SCENE_TITLE_NORMAL_ARRAY_AH_CAMCORDER, R_CAM_SCENE_TITLE_NORMAL_ARRAY_AH_PORTRAIT, R_CAM_SCENE_TITLE_NORMAL_ARRAY_AH_VIEWMODE, R_CAM_SCENE_TITLE_NORMAL_ARRAY_AH_CAMCORDER },
    { R_CAM_SCENE_TITLE_NORMAL_ARRAY_APAC_CAMCORDER, R_CAM_SCENE_TITLE_NORMAL_ARRAY_APAC_PORTRAIT, R_CAM_SCENE_TITLE_NORMAL_ARRAY_APAC_VIEWMODE, R_CAM_SCENE_TITLE_NORMAL_ARRAY_APAC_CAMCORDER },
    { R_CAM_SCENE_TITLE_DISPLACED_ARRAY_CAMCORDER, R_CAM_SCENE_TITLE_DISPLACED_ARRAY_PORTRAIT, R_CAM_SCENE_TITLE_DISPLACED_ARRAY_VIEWMODE, R_CAM_SCENE_TITLE_DISPLACED_ARRAY_CAMCORDER },
    { R_CAM_SCENE_TITLE_DISPLACED_ARRAY_AH_CAMCORDER, R_CAM_SCENE_TITLE_DISPLACED_ARRAY_AH_PORTRAIT, R_CAM_SCENE_TITLE_DISPLACED_ARRAY_AH_VIEWMODE, R_CAM_SCENE_TITLE_DISPLACED_ARRAY_AH_CAMCORDER },
    { R_CAM_SCENE_TITLE_DISPLACED_ARRAY_APAC_CAMCORDER, R_CAM_SCENE_TITLE_DISPLACED_ARRAY_APAC_PORTRAIT,R_CAM_SCENE_TITLE_DISPLACED_ARRAY_APAC_VIEWMODE, R_CAM_SCENE_TITLE_DISPLACED_ARRAY_APAC_CAMCORDER },
    { R_CAM_SCENE_HIGHLIGHT_TITLE_ARRAY_CAMCORDER, R_CAM_SCENE_HIGHLIGHT_TITLE_ARRAY_PORTRAIT, R_CAM_SCENE_HIGHLIGHT_TITLE_ARRAY_VIEWMODE, R_CAM_SCENE_HIGHLIGHT_TITLE_ARRAY_CAMCORDER },
    { R_CAM_SCENE_HIGHLIGHT_TITLE_ARRAY_AH_CAMCORDER, R_CAM_SCENE_HIGHLIGHT_TITLE_ARRAY_AH_PORTRAIT, R_CAM_SCENE_HIGHLIGHT_TITLE_ARRAY_AH_VIEWMODE, R_CAM_SCENE_HIGHLIGHT_TITLE_ARRAY_AH_CAMCORDER },
    { R_CAM_SCENE_HIGHLIGHT_TITLE_ARRAY_APAC_CAMCORDER, R_CAM_SCENE_HIGHLIGHT_TITLE_ARRAY_APAC_PORTRAIT, R_CAM_SCENE_HIGHLIGHT_TITLE_ARRAY_APAC_VIEWMODE, R_CAM_SCENE_HIGHLIGHT_TITLE_ARRAY_APAC_CAMCORDER },
    { R_CAM_SCENE_HIGHLIGHT_DESCRIPTION_ARRAY_CAMCORDER, R_CAM_SCENE_HIGHLIGHT_DESCRIPTION_ARRAY_PORTRAIT, R_CAM_SCENE_HIGHLIGHT_DESCRIPTION_ARRAY_VIEWMODE, R_CAM_SCENE_HIGHLIGHT_DESCRIPTION_ARRAY_CAMCORDER },
    { R_CAM_SCENE_HIGHLIGHT_DESCRIPTION_ARRAY_AH_CAMCORDER, R_CAM_SCENE_HIGHLIGHT_DESCRIPTION_ARRAY_AH_PORTRAIT, R_CAM_SCENE_HIGHLIGHT_DESCRIPTION_ARRAY_AH_VIEWMODE, R_CAM_SCENE_HIGHLIGHT_DESCRIPTION_ARRAY_AH_CAMCORDER },
// 50:    
    { R_CAM_SCENE_HIGHLIGHT_DESCRIPTION_ARRAY_APAC_CAMCORDER, R_CAM_SCENE_HIGHLIGHT_DESCRIPTION_ARRAY_APAC_PORTRAIT, R_CAM_SCENE_HIGHLIGHT_DESCRIPTION_ARRAY_APAC_VIEWMODE, R_CAM_SCENE_HIGHLIGHT_DESCRIPTION_ARRAY_APAC_CAMCORDER },
    { R_CAM_SCENE_HIGHLIGHT_LAYOUT_ARRAY_CAMCORDER, R_CAM_SCENE_HIGHLIGHT_LAYOUT_ARRAY_PORTRAIT, R_CAM_SCENE_HIGHLIGHT_LAYOUT_ARRAY_VIEWMODE, R_CAM_SCENE_HIGHLIGHT_LAYOUT_ARRAY_CAMCORDER },
    { R_CAM_SCENE_HIGHLIGHT_LAYOUT_ARRAY_AH_CAMCORDER, R_CAM_SCENE_HIGHLIGHT_LAYOUT_ARRAY_AH_PORTRAIT, R_CAM_SCENE_HIGHLIGHT_LAYOUT_ARRAY_AH_VIEWMODE, R_CAM_SCENE_HIGHLIGHT_LAYOUT_ARRAY_AH_CAMCORDER },
    { R_CAM_SCENE_ICON_HIGHLIGHT_ARRAY_CAMCORDER, R_CAM_SCENE_ICON_HIGHLIGHT_ARRAY_PORTRAIT, R_CAM_SCENE_ICON_HIGHLIGHT_ARRAY_VIEWMODE, R_CAM_SCENE_ICON_HIGHLIGHT_ARRAY_CAMCORDER },
    { R_CAM_SCENE_ICON_HIGHLIGHT_ARRAY_AH_CAMCORDER, R_CAM_SCENE_ICON_HIGHLIGHT_ARRAY_AH_PORTRAIT, R_CAM_SCENE_ICON_HIGHLIGHT_ARRAY_AH_VIEWMODE, R_CAM_SCENE_ICON_HIGHLIGHT_ARRAY_AH_CAMCORDER },
    { R_CAM_SCENE_ICON_NORMAL_ARRAY_CAMCORDER, R_CAM_SCENE_ICON_NORMAL_ARRAY_PORTRAIT, R_CAM_SCENE_ICON_NORMAL_ARRAY_VIEWMODE, R_CAM_SCENE_ICON_NORMAL_ARRAY_CAMCORDER },
    { R_CAM_SCENE_ICON_NORMAL_ARRAY_AH_CAMCORDER, R_CAM_SCENE_ICON_NORMAL_ARRAY_AH_PORTRAIT, R_CAM_SCENE_ICON_NORMAL_ARRAY_AH_VIEWMODE, R_CAM_SCENE_ICON_NORMAL_ARRAY_AH_CAMCORDER },
    { R_CAM_SCENE_ICON_DISPLACED_ARRAY_CAMCORDER, R_CAM_SCENE_ICON_DISPLACED_ARRAY_PORTRAIT, R_CAM_SCENE_ICON_DISPLACED_ARRAY_VIEWMODE, R_CAM_SCENE_ICON_DISPLACED_ARRAY_CAMCORDER },
    { R_CAM_SCENE_ICON_DISPLACED_ARRAY_AH_CAMCORDER, R_CAM_SCENE_ICON_DISPLACED_ARRAY_AH_PORTRAIT, R_CAM_SCENE_ICON_DISPLACED_ARRAY_AH_VIEWMODE, R_CAM_SCENE_ICON_DISPLACED_ARRAY_AH_CAMCORDER },
    { R_CAM_SCENE_SCROLLBAR_POSITION_CAMCORDER, R_CAM_SCENE_SCROLLBAR_POSITION_PORTRAIT, R_CAM_SCENE_SCROLLBAR_POSITION_VIEWMODE, R_CAM_SCENE_SCROLLBAR_POSITION_CAMCORDER },
// 60:    
    { R_CAM_SCENE_SCROLLBAR_POSITION_AH_CAMCORDER, R_CAM_SCENE_SCROLLBAR_POSITION_AH_PORTRAIT, R_CAM_SCENE_SCROLLBAR_POSITION_AH_VIEWMODE, R_CAM_SCENE_SCROLLBAR_POSITION_AH_CAMCORDER },
    { R_CAM_CAPSETUP_LISTBOX_ICON_RECT, R_CAM_CAPSETUP_LISTBOX_ICON_RECT, R_CAM_CAPSETUP_LISTBOX_ICON_RECT, R_CAM_CAPSETUP_LISTBOX_ICON_RECT },
    { R_CAM_CAPSETUP_LISTBOX_ICON_RECT_AH, R_CAM_CAPSETUP_LISTBOX_ICON_RECT_AH, R_CAM_CAPSETUP_LISTBOX_ICON_RECT_AH, R_CAM_CAPSETUP_LISTBOX_ICON_RECT_AH },
    { R_CAM_CAPSETUP_LISTBOX_RADIOBUT_RECT, R_CAM_CAPSETUP_LISTBOX_RADIOBUT_RECT, R_CAM_CAPSETUP_LISTBOX_RADIOBUT_RECT, R_CAM_CAPSETUP_LISTBOX_RADIOBUT_RECT },
    { R_CAM_CAPSETUP_LISTBOX_RADIOBUT_RECT_AH, R_CAM_CAPSETUP_LISTBOX_RADIOBUT_RECT_AH, R_CAM_CAPSETUP_LISTBOX_RADIOBUT_RECT_AH, R_CAM_CAPSETUP_LISTBOX_RADIOBUT_RECT_AH },
    { R_CAM_CAPSETUP_LISTBOX_TEXT_RECT, R_CAM_CAPSETUP_LISTBOX_TEXT_RECT, R_CAM_CAPSETUP_LISTBOX_TEXT_RECT, R_CAM_CAPSETUP_LISTBOX_TEXT_RECT },
    { R_CAM_CAPSETUP_LISTBOX_TEXT_RECT_APAC, R_CAM_CAPSETUP_LISTBOX_TEXT_RECT_APAC, R_CAM_CAPSETUP_LISTBOX_TEXT_RECT_APAC, R_CAM_CAPSETUP_LISTBOX_TEXT_RECT_APAC },
    { R_CAM_CAPSETUP_LISTBOX_TEXT_RECT_AH, R_CAM_CAPSETUP_LISTBOX_TEXT_RECT_AH, R_CAM_CAPSETUP_LISTBOX_TEXT_RECT_AH, R_CAM_CAPSETUP_LISTBOX_TEXT_RECT_AH },
    { R_CAM_CAPTURE_SETUP_LIST_STILL_WHITEBALANCE, R_CAM_CAPTURE_SETUP_LIST_STILL_WHITEBALANCE, R_CAM_CAPTURE_SETUP_LIST_STILL_WHITEBALANCE, R_CAM_CAPTURE_SETUP_LIST_STILL_WHITEBALANCE },
    { R_CAM_CAPTURE_SETUP_LIST_STILL_COLOUREFFECT, R_CAM_CAPTURE_SETUP_LIST_STILL_COLOUREFFECT, R_CAM_CAPTURE_SETUP_LIST_STILL_COLOUREFFECT, R_CAM_CAPTURE_SETUP_LIST_STILL_COLOUREFFECT },
// 70:    
    { R_CAM_CAPTURE_SETUP_LIST_STILL_FLASH, R_CAM_CAPTURE_SETUP_LIST_STILL_FLASH, R_CAM_CAPTURE_SETUP_LIST_STILL_FLASH, R_CAM_CAPTURE_SETUP_LIST_STILL_FLASH },
    { R_CAM_CAPTURE_SETUP_LIST_VIDEO_WHITEBALANCE, R_CAM_CAPTURE_SETUP_LIST_VIDEO_WHITEBALANCE, R_CAM_CAPTURE_SETUP_LIST_VIDEO_WHITEBALANCE, R_CAM_CAPTURE_SETUP_LIST_VIDEO_WHITEBALANCE },
    { R_CAM_CAPTURE_SETUP_LIST_VIDEO_COLOUREFFECT, R_CAM_CAPTURE_SETUP_LIST_VIDEO_COLOUREFFECT, R_CAM_CAPTURE_SETUP_LIST_VIDEO_COLOUREFFECT, R_CAM_CAPTURE_SETUP_LIST_VIDEO_COLOUREFFECT },
    { R_CAM_CAPTURE_SETUP_LIST_PHOTO_IMAGESHARPNESS, R_CAM_CAPTURE_SETUP_LIST_PHOTO_IMAGESHARPNESS, R_CAM_CAPTURE_SETUP_LIST_PHOTO_IMAGESHARPNESS, R_CAM_CAPTURE_SETUP_LIST_PHOTO_IMAGESHARPNESS },
    { R_CAM_CAPTURE_SETUP_MENU_PHOTO_DATA, R_CAM_CAPTURE_SETUP_MENU_PHOTO_DATA, R_CAM_CAPTURE_SETUP_MENU_PHOTO_DATA, R_CAM_CAPTURE_SETUP_MENU_PHOTO_DATA },
    { R_CAM_CAPTURE_SETUP_MENU_PHOTO_DATA_APAC, R_CAM_CAPTURE_SETUP_MENU_PHOTO_DATA_APAC, R_CAM_CAPTURE_SETUP_MENU_PHOTO_DATA_APAC, R_CAM_CAPTURE_SETUP_MENU_PHOTO_DATA_APAC },
    { R_CAM_CAPTURE_SETUP_MENU_PHOTO_DATA_AH, R_CAM_CAPTURE_SETUP_MENU_PHOTO_DATA_AH, R_CAM_CAPTURE_SETUP_MENU_PHOTO_DATA_AH, R_CAM_CAPTURE_SETUP_MENU_PHOTO_DATA_AH },
    { R_CAM_CAPTURE_SETUP_MENU_VIDEO_DATA, R_CAM_CAPTURE_SETUP_MENU_VIDEO_DATA, R_CAM_CAPTURE_SETUP_MENU_VIDEO_DATA, R_CAM_CAPTURE_SETUP_MENU_VIDEO_DATA },
    { R_CAM_CAPTURE_SETUP_MENU_VIDEO_DATA_APAC, R_CAM_CAPTURE_SETUP_MENU_VIDEO_DATA_APAC, R_CAM_CAPTURE_SETUP_MENU_VIDEO_DATA_APAC, R_CAM_CAPTURE_SETUP_MENU_VIDEO_DATA_APAC },
    { R_CAM_CAPTURE_SETUP_MENU_VIDEO_DATA_AH, R_CAM_CAPTURE_SETUP_MENU_VIDEO_DATA_AH, R_CAM_CAPTURE_SETUP_MENU_VIDEO_DATA_AH, R_CAM_CAPTURE_SETUP_MENU_VIDEO_DATA_AH },
// 80:    
    { R_CAM_CAPTURE_SETUP_CONTROL_POSITION, R_CAM_CAPTURE_SETUP_CONTROL_POSITION, R_CAM_CAPTURE_SETUP_CONTROL_POSITION, R_CAM_CAPTURE_SETUP_CONTROL_POSITION },
    { R_CAM_CAPTURE_SETUP_CONTROL_POSITION_AH, R_CAM_CAPTURE_SETUP_CONTROL_POSITION_AH, R_CAM_CAPTURE_SETUP_CONTROL_POSITION_AH, R_CAM_CAPTURE_SETUP_CONTROL_POSITION_AH },
    { R_CAM_CAPTURE_SETUP_LISTBOX_WIDTH, R_CAM_CAPTURE_SETUP_LISTBOX_WIDTH, R_CAM_CAPTURE_SETUP_LISTBOX_WIDTH, R_CAM_CAPTURE_SETUP_LISTBOX_WIDTH },
    { R_CAM_CAPTURE_SETUP_LISTBOX_ITEM_HEIGHT, R_CAM_CAPTURE_SETUP_LISTBOX_ITEM_HEIGHT, R_CAM_CAPTURE_SETUP_LISTBOX_ITEM_HEIGHT, R_CAM_CAPTURE_SETUP_LISTBOX_ITEM_HEIGHT },
    { R_CAM_CAPTURE_SETUP_CONTVF_RECT, R_CAM_CAPTURE_SETUP_CONTVF_RECT, R_CAM_CAPTURE_SETUP_CONTVF_RECT, R_CAM_CAPTURE_SETUP_CONTVF_RECT },
    { R_CAM_CAPTURE_SETUP_CONTVF_RECT_AH, R_CAM_CAPTURE_SETUP_CONTVF_RECT_AH, R_CAM_CAPTURE_SETUP_CONTVF_RECT_AH, R_CAM_CAPTURE_SETUP_CONTVF_RECT_AH },
    { R_CAM_CAPTURE_SETUP_SLIDER_CONTVF_RECT, R_CAM_CAPTURE_SETUP_SLIDER_CONTVF_RECT, R_CAM_CAPTURE_SETUP_SLIDER_CONTVF_RECT, R_CAM_CAPTURE_SETUP_SLIDER_CONTVF_RECT },
    { R_CAM_CAPTURE_SETUP_SLIDER_CONTVF_RECT_AH, R_CAM_CAPTURE_SETUP_SLIDER_CONTVF_RECT_AH, R_CAM_CAPTURE_SETUP_SLIDER_CONTVF_RECT_AH, R_CAM_CAPTURE_SETUP_SLIDER_CONTVF_RECT_AH },
    { R_CAM_CAPTURE_SETUP_CONT_TITLETEXT_LAYOUT_APAC, R_CAM_CAPTURE_SETUP_CONT_TITLETEXT_LAYOUT_APAC, R_CAM_CAPTURE_SETUP_CONT_TITLETEXT_LAYOUT_APAC, R_CAM_CAPTURE_SETUP_CONT_TITLETEXT_LAYOUT_APAC },
    { R_CAM_CAPTURE_SETUP_CONT_TITLETEXT_LAYOUT_AH, R_CAM_CAPTURE_SETUP_CONT_TITLETEXT_LAYOUT_AH, R_CAM_CAPTURE_SETUP_CONT_TITLETEXT_LAYOUT_AH, R_CAM_CAPTURE_SETUP_CONT_TITLETEXT_LAYOUT_AH },
// 90:    
    { R_CAM_CAPTURE_SETUP_CONT_TITLETEXT_LAYOUT, R_CAM_CAPTURE_SETUP_CONT_TITLETEXT_LAYOUT, R_CAM_CAPTURE_SETUP_CONT_TITLETEXT_LAYOUT, R_CAM_CAPTURE_SETUP_CONT_TITLETEXT_LAYOUT },
    { R_CAM_USER_SCENE_SETUP_VIEW, R_CAM_USER_SCENE_SETUP_VIEW, R_CAM_USER_SCENE_SETUP_VIEW, R_CAM_USER_SCENE_SETUP_VIEW },
    { R_CAM_USER_SCENE_SETUP_MENUBAR, R_CAM_USER_SCENE_SETUP_MENUBAR, R_CAM_USER_SCENE_SETUP_MENUBAR, R_CAM_USER_SCENE_SETUP_MENUBAR },
    { R_CAM_USER_SCENE_SETUP_MENU, R_CAM_USER_SCENE_SETUP_MENU, R_CAM_USER_SCENE_SETUP_MENU, R_CAM_USER_SCENE_SETUP_MENU },
    { R_CAM_LAYOUT_ZOOM_PANE_CAMCORDER, R_CAM_LAYOUT_ZOOM_PANE_PORTRAIT, R_CAM_LAYOUT_ZOOM_PANE_VIEWMODE, R_CAM_LAYOUT_ZOOM_PANE_CAMCORDER_LEFT },
    { R_CAM_LAYOUT_ZOOM_PANE_SHAFT_CAMCORDER, R_CAM_LAYOUT_ZOOM_PANE_SHAFT_PORTRAIT, R_CAM_LAYOUT_ZOOM_PANE_SHAFT_VIEWMODE, R_CAM_LAYOUT_ZOOM_PANE_SHAFT_CAMCORDER_LEFT },
    { R_CAM_VIEWFINDER_RECT_STILL_CAMCORDER, R_CAM_VIEWFINDER_RECT_STILL_PORTRAIT, R_CAM_VIEWFINDER_RECT_STILL_VIEWMODE, R_CAM_VIEWFINDER_RECT_STILL_CAMCORDER },
    { R_CAM_STILL_DISPLAYED_RECT_SECONDARY_CAMCORDER, R_CAM_STILL_DISPLAYED_RECT_SECONDARY_PORTRAIT, R_CAM_STILL_DISPLAYED_RECT_SECONDARY_VIEWMODE, R_CAM_STILL_DISPLAYED_RECT_SECONDARY_CAMCORDER },
    { R_CAM_STILL_REQUESTED_RECT_SECONDARY_CAMCORDER, R_CAM_STILL_REQUESTED_RECT_SECONDARY_PORTRAIT, R_CAM_STILL_REQUESTED_RECT_SECONDARY_VIEWMODE, R_CAM_STILL_REQUESTED_RECT_SECONDARY_CAMCORDER },
    { R_CAM_VIEWFINDER_RECT_CIF_CAMCORDER, R_CAM_VIEWFINDER_RECT_CIF_PORTRAIT, R_CAM_VIEWFINDER_RECT_CIF_VIEWMODE, R_CAM_VIEWFINDER_RECT_CIF_CAMCORDER },
// 100:    
    { R_CAM_VIEWFINDER_RECT_QCIF_CAMCORDER, R_CAM_VIEWFINDER_RECT_QCIF_PORTRAIT, R_CAM_VIEWFINDER_RECT_QCIF_VIEWMODE, R_CAM_VIEWFINDER_RECT_QCIF_CAMCORDER },
    { R_CAM_VIEWFINDER_RECT_SQCIF_CAMCORDER, R_CAM_VIEWFINDER_RECT_SQCIF_PORTRAIT, R_CAM_VIEWFINDER_RECT_SQCIF_VIEWMODE, R_CAM_VIEWFINDER_RECT_SQCIF_CAMCORDER },
    { R_CAM_VIEWFINDER_RECT_SECONDARY_CAMCORDER, R_CAM_VIEWFINDER_RECT_SECONDARY_PORTRAIT, R_CAM_VIEWFINDER_RECT_SECONDARY_VIEWMODE, R_CAM_VIEWFINDER_RECT_SECONDARY_CAMCORDER },
    { R_CAM_SNAPSHOT_RECT_STILL_CAMCORDER, R_CAM_SNAPSHOT_RECT_STILL_PORTRAIT, R_CAM_SNAPSHOT_RECT_STILL_VIEWMODE, R_CAM_SNAPSHOT_RECT_STILL_CAMCORDER },
    { R_CAM_SNAPSHOT_RECT_CIF_CAMCORDER, R_CAM_SNAPSHOT_RECT_CIF_PORTRAIT, R_CAM_SNAPSHOT_RECT_CIF_VIEWMODE, R_CAM_SNAPSHOT_RECT_CIF_CAMCORDER },
    { R_CAM_SNAPSHOT_RECT_NEAR_CIF_CAMCORDER, R_CAM_SNAPSHOT_RECT_NEAR_CIF_PORTRAIT, R_CAM_SNAPSHOT_RECT_NEAR_CIF_VIEWMODE, R_CAM_SNAPSHOT_RECT_NEAR_CIF_CAMCORDER },
    { R_CAM_SNAPSHOT_RECT_SQCIF_CAMCORDER, R_CAM_SNAPSHOT_RECT_SQCIF_PORTRAIT, R_CAM_SNAPSHOT_RECT_SQCIF_VIEWMODE, R_CAM_SNAPSHOT_RECT_SQCIF_CAMCORDER },
    { R_CAM_ZOOM_PANE_WIDTH_CAMCORDER, R_CAM_ZOOM_PANE_WIDTH_PORTRAIT, R_CAM_ZOOM_PANE_WIDTH_VIEWMODE, R_CAM_ZOOM_PANE_WIDTH_CAMCORDER },
    {0, 0, 0, 0}, // Resource deleted
    { R_CAM_CAPTURE_SETUP_SLIDER_BRIGHTNESS_ARRAY, R_CAM_CAPTURE_SETUP_SLIDER_BRIGHTNESS_ARRAY, R_CAM_CAPTURE_SETUP_SLIDER_BRIGHTNESS_ARRAY, R_CAM_CAPTURE_SETUP_SLIDER_BRIGHTNESS_ARRAY },
// 110:    
    { R_CAM_CAPTURE_SETUP_SLIDER_BRIGHTNESS_ARRAY_AH, R_CAM_CAPTURE_SETUP_SLIDER_BRIGHTNESS_ARRAY_AH, R_CAM_CAPTURE_SETUP_SLIDER_BRIGHTNESS_ARRAY_AH, R_CAM_CAPTURE_SETUP_SLIDER_BRIGHTNESS_ARRAY_AH },
    { R_CAM_CAPTURE_SETUP_SLIDER_CONTRAST_ARRAY, R_CAM_CAPTURE_SETUP_SLIDER_CONTRAST_ARRAY, R_CAM_CAPTURE_SETUP_SLIDER_CONTRAST_ARRAY, R_CAM_CAPTURE_SETUP_SLIDER_CONTRAST_ARRAY },
    { R_CAM_CAPTURE_SETUP_SLIDER_CONTRAST_ARRAY_AH, R_CAM_CAPTURE_SETUP_SLIDER_CONTRAST_ARRAY_AH, R_CAM_CAPTURE_SETUP_SLIDER_CONTRAST_ARRAY_AH, R_CAM_CAPTURE_SETUP_SLIDER_CONTRAST_ARRAY_AH },
    { R_CAM_CAPTURE_SETUP_SLIDER_EV_ARRAY, R_CAM_CAPTURE_SETUP_SLIDER_EV_ARRAY, R_CAM_CAPTURE_SETUP_SLIDER_EV_ARRAY, R_CAM_CAPTURE_SETUP_SLIDER_EV_ARRAY },
    { R_CAM_CAPTURE_SETUP_SLIDER_EV_ARRAY_AH, R_CAM_CAPTURE_SETUP_SLIDER_EV_ARRAY_AH, R_CAM_CAPTURE_SETUP_SLIDER_EV_ARRAY_AH, R_CAM_CAPTURE_SETUP_SLIDER_EV_ARRAY_AH },
    { R_CAM_CAPTURE_SETUP_SLIDER_COLOURSATURATION_ARRAY, R_CAM_CAPTURE_SETUP_SLIDER_COLOURSATURATION_ARRAY, R_CAM_CAPTURE_SETUP_SLIDER_COLOURSATURATION_ARRAY, R_CAM_CAPTURE_SETUP_SLIDER_COLOURSATURATION_ARRAY },
    {0, 0, 0, 0}, // Resource deleted
    {0, 0, 0, 0}, // Resource deleted
    {0, 0, 0, 0}, // Resource deleted 
    {0, 0, 0, 0}, // Resource deleted
// 120:      
    {0, 0, 0, 0}, // Resource deleted
    {0, 0, 0, 0}, // Resource deleted
    {0, 0, 0, 0}, // Resource deleted
    { R_CAM_CAPTURE_SETUP_SLIDER_SHAFT, R_CAM_CAPTURE_SETUP_SLIDER_SHAFT, R_CAM_CAPTURE_SETUP_SLIDER_SHAFT, R_CAM_CAPTURE_SETUP_SLIDER_SHAFT },
    { R_CAM_CAPTURE_SETUP_SLIDER_THUMB, R_CAM_CAPTURE_SETUP_SLIDER_THUMB, R_CAM_CAPTURE_SETUP_SLIDER_THUMB, R_CAM_CAPTURE_SETUP_SLIDER_THUMB },
    { R_CAM_CAPTURE_SETUP_SLIDER_SHAFT_AH, R_CAM_CAPTURE_SETUP_SLIDER_SHAFT_AH, R_CAM_CAPTURE_SETUP_SLIDER_SHAFT_AH, R_CAM_CAPTURE_SETUP_SLIDER_SHAFT_AH },
    { R_CAM_CAPTURE_SETUP_SLIDER_THUMB_AH, R_CAM_CAPTURE_SETUP_SLIDER_THUMB_AH, R_CAM_CAPTURE_SETUP_SLIDER_THUMB_AH, R_CAM_CAPTURE_SETUP_SLIDER_THUMB_AH },
    { R_CAM_CAPTURE_SETUP_SLIDER_CONTROL_POSITION, R_CAM_CAPTURE_SETUP_SLIDER_CONTROL_POSITION, R_CAM_CAPTURE_SETUP_SLIDER_CONTROL_POSITION, R_CAM_CAPTURE_SETUP_SLIDER_CONTROL_POSITION },
    { R_CAM_CAPTURE_SETUP_SLIDER_CONTROL_POSITION_AH, R_CAM_CAPTURE_SETUP_SLIDER_CONTROL_POSITION_AH, R_CAM_CAPTURE_SETUP_SLIDER_CONTROL_POSITION_AH, R_CAM_CAPTURE_SETUP_SLIDER_CONTROL_POSITION_AH },  
    { R_CAM_POST_CAPTURE_IMAGE_SIZE_LAYOUT_CAMCORDER, R_CAM_POST_CAPTURE_IMAGE_SIZE_LAYOUT_PORTRAIT, R_CAM_POST_CAPTURE_IMAGE_SIZE_LAYOUT_VIEWMODE, R_CAM_POST_CAPTURE_IMAGE_SIZE_LAYOUT_CAMCORDER },
// 130:      
    { R_CAM_POST_CAPTURE_VIDEO_SIZE_LAYOUT_CAMCORDER, R_CAM_POST_CAPTURE_VIDEO_SIZE_LAYOUT_PORTRAIT, R_CAM_POST_CAPTURE_VIDEO_SIZE_LAYOUT_VIEWMODE, R_CAM_POST_CAPTURE_VIDEO_SIZE_LAYOUT_CAMCORDER },
    { R_CAM_POST_CAPTURE_IMAGE_SIZE_LAYOUT_AH_CAMCORDER, R_CAM_POST_CAPTURE_IMAGE_SIZE_LAYOUT_AH_PORTRAIT, R_CAM_POST_CAPTURE_IMAGE_SIZE_LAYOUT_AH_VIEWMODE, R_CAM_POST_CAPTURE_IMAGE_SIZE_LAYOUT_AH_CAMCORDER },
    { R_CAM_POST_CAPTURE_VIDEO_SIZE_LAYOUT_AH_CAMCORDER, R_CAM_POST_CAPTURE_VIDEO_SIZE_LAYOUT_AH_PORTRAIT, R_CAM_POST_CAPTURE_VIDEO_SIZE_LAYOUT_AH_VIEWMODE, R_CAM_POST_CAPTURE_VIDEO_SIZE_LAYOUT_AH_CAMCORDER },
    { R_CAM_QUALITY_SLIDER_SHAFT, R_CAM_QUALITY_SLIDER_SHAFT, R_CAM_QUALITY_SLIDER_SHAFT, R_CAM_QUALITY_SLIDER_SHAFT },
    { R_CAM_QUALITY_SLIDER_SHAFT_AH, R_CAM_QUALITY_SLIDER_SHAFT_AH, R_CAM_QUALITY_SLIDER_SHAFT_AH, R_CAM_QUALITY_SLIDER_SHAFT_AH },
    { R_CAM_QUALITY_SLIDER_THUMB, R_CAM_QUALITY_SLIDER_THUMB, R_CAM_QUALITY_SLIDER_THUMB, R_CAM_QUALITY_SLIDER_THUMB },
    { R_CAM_QUALITY_SLIDER_THUMB_AH, R_CAM_QUALITY_SLIDER_THUMB_AH, R_CAM_QUALITY_SLIDER_THUMB_AH, R_CAM_QUALITY_SLIDER_THUMB_AH },
    { R_CAM_SETTING_PHOTO_QUALITY_SLIDER, R_CAM_SETTING_PHOTO_QUALITY_SLIDER, R_CAM_SETTING_PHOTO_QUALITY_SLIDER, R_CAM_SETTING_PHOTO_QUALITY_SLIDER },
    { R_CAM_SETTING_VIDEO_QUALITY_SLIDER, R_CAM_SETTING_VIDEO_QUALITY_SLIDER, R_CAM_SETTING_VIDEO_QUALITY_SLIDER, R_CAM_SETTING_VIDEO_QUALITY_SLIDER },   
    { R_CAM_SETTING_QUALITY_SLIDER_LAYOUT, R_CAM_SETTING_QUALITY_SLIDER_LAYOUT, R_CAM_SETTING_QUALITY_SLIDER_LAYOUT, R_CAM_SETTING_QUALITY_SLIDER_LAYOUT },
// 140:     
    { R_CAM_PHOTO_QUALITY_SLIDER_ARRAY_CAMCORDER, R_CAM_PHOTO_QUALITY_SLIDER_ARRAY_CAMCORDER, R_CAM_PHOTO_QUALITY_SLIDER_ARRAY_CAMCORDER, R_CAM_PHOTO_QUALITY_SLIDER_ARRAY_CAMCORDER },
    { R_CAM_PHOTO_QUALITY_SLIDER_ARRAY_AH_CAMCORDER, R_CAM_PHOTO_QUALITY_SLIDER_ARRAY_AH_CAMCORDER, R_CAM_PHOTO_QUALITY_SLIDER_ARRAY_AH_CAMCORDER, R_CAM_PHOTO_QUALITY_SLIDER_ARRAY_AH_CAMCORDER },
    { R_CAM_VIDEO_QUALITY_SLIDER_ARRAY_CAMCORDER, R_CAM_VIDEO_QUALITY_SLIDER_ARRAY_PORTRAIT, R_CAM_VIDEO_QUALITY_SLIDER_ARRAY_VIEWMODE, R_CAM_VIDEO_QUALITY_SLIDER_ARRAY_CAMCORDER },
    { R_CAM_VIDEO_QUALITY_SLIDER_ARRAY_AH_CAMCORDER, R_CAM_VIDEO_QUALITY_SLIDER_ARRAY_AH_PORTRAIT, R_CAM_VIDEO_QUALITY_SLIDER_ARRAY_AH_VIEWMODE, R_CAM_VIDEO_QUALITY_SLIDER_ARRAY_AH_CAMCORDER },
    { R_CAM_SIDEPANE_RECT_CAM1_CAMCORDER, R_CAM_SIDEPANE_RECT_CAM1_PORTRAIT, R_CAM_SIDEPANE_RECT_CAM1_VIEWMODE, R_CAM_SIDEPANE_RECT_CAM1_CAMCORDER },
    { R_CAM_SIDEPANE_RECT_CAM2_CAMCORDER, R_CAM_SIDEPANE_RECT_CAM2_PORTRAIT, R_CAM_SIDEPANE_RECT_CAM2_VIEWMODE, R_CAM_SIDEPANE_RECT_CAM2_CAMCORDER },
    { R_CAM_SETTING_LIST_VIEW, R_CAM_SETTING_LIST_VIEW, R_CAM_SETTING_LIST_VIEW, R_CAM_SETTING_LIST_VIEW },
    { R_CAM_SETTINGS_LIST_MENUBAR, R_CAM_SETTINGS_LIST_MENUBAR, R_CAM_SETTINGS_LIST_MENUBAR, R_CAM_SETTINGS_LIST_MENUBAR },
    { R_CAM_SETTINGS_LIST_MENU, R_CAM_SETTINGS_LIST_MENU, R_CAM_SETTINGS_LIST_MENU, R_CAM_SETTINGS_LIST_MENUBAR },   
    { R_CAM_VIDEO_SETTINGS_ITEM_LIST_CAMCORDER, R_CAM_VIDEO_SETTINGS_ITEM_LIST_PORTRAIT, R_CAM_VIDEO_SETTINGS_ITEM_LIST_CAMCORDER, R_CAM_VIDEO_SETTINGS_ITEM_LIST_CAMCORDER },
// 150:     
    { R_CAM_EMBEDDED_VIDEO_SETTINGS_ITEM_LIST_CAMCORDER, R_CAM_EMBEDDED_VIDEO_SETTINGS_ITEM_LIST_PORTRAIT, R_CAM_EMBEDDED_VIDEO_SETTINGS_ITEM_LIST_CAMCORDER, R_CAM_EMBEDDED_VIDEO_SETTINGS_ITEM_LIST_CAMCORDER },
    { R_CAM_SETTINGS_LIST_SETTINGS_PAGE, R_CAM_SETTINGS_LIST_SETTINGS_PAGE, R_CAM_SETTINGS_LIST_SETTINGS_PAGE, R_CAM_SETTINGS_LIST_SETTINGS_PAGE },
    { R_CAM_PHOTO_SETTINGS_ITEM_LIST_CAMCORDER, R_CAM_PHOTO_SETTINGS_ITEM_LIST_PORTRAIT, R_CAM_PHOTO_SETTINGS_ITEM_LIST_CAMCORDER, R_CAM_PHOTO_SETTINGS_ITEM_LIST_CAMCORDER },
    { R_CAM_EMBEDDED_PHOTO_SETTINGS_ITEM_LIST_CAMCORDER, R_CAM_EMBEDDED_PHOTO_SETTINGS_ITEM_LIST_PORTRAIT, R_CAM_EMBEDDED_PHOTO_SETTINGS_ITEM_LIST_CAMCORDER, R_CAM_EMBEDDED_PHOTO_SETTINGS_ITEM_LIST_CAMCORDER },
    { R_CAM_POST_CAPTURE_IMAGE_NAME_LAYOUT_CAMCORDER, R_CAM_POST_CAPTURE_IMAGE_NAME_LAYOUT_PORTRAIT, R_CAM_POST_CAPTURE_IMAGE_NAME_LAYOUT_VIEWMODE, R_CAM_POST_CAPTURE_IMAGE_NAME_LAYOUT_CAMCORDER_LEFT },
    { R_CAM_POST_CAPTURE_IMAGE_NAME_LAYOUT_AH_CAMCORDER, R_CAM_POST_CAPTURE_IMAGE_NAME_LAYOUT_AH_PORTRAIT, R_CAM_POST_CAPTURE_IMAGE_NAME_LAYOUT_AH_VIEWMODE, R_CAM_POST_CAPTURE_IMAGE_NAME_LAYOUT_AH_CAMCORDER_LEFT },
    { R_CAM_POST_CAPTURE_VIDEO_NAME_LAYOUT_CAMCORDER, R_CAM_POST_CAPTURE_VIDEO_NAME_LAYOUT_PORTRAIT, R_CAM_POST_CAPTURE_VIDEO_NAME_LAYOUT_VIEWMODE, R_CAM_POST_CAPTURE_VIDEO_NAME_LAYOUT_CAMCORDER_LEFT },
    { R_CAM_POST_CAPTURE_VIDEO_NAME_LAYOUT_AH_CAMCORDER, R_CAM_POST_CAPTURE_VIDEO_NAME_LAYOUT_AH_PORTRAIT, R_CAM_POST_CAPTURE_VIDEO_NAME_LAYOUT_AH_VIEWMODE, R_CAM_POST_CAPTURE_VIDEO_NAME_LAYOUT_AH_CAMCORDER_LEFT },
    { R_CAM_VIDEO_PRECAP_FILE_TYPE, R_CAM_VIDEO_PRECAP_FILE_TYPE, R_CAM_VIDEO_PRECAP_FILE_TYPE, R_CAM_VIDEO_PRECAP_FILE_TYPE_LEFT },
    { R_CAM_VIDEO_PRECAP_FILE_TYPE_AH, R_CAM_VIDEO_PRECAP_FILE_TYPE_AH, R_CAM_VIDEO_PRECAP_FILE_TYPE_AH, R_CAM_VIDEO_PRECAP_FILE_TYPE_AH_LEFT },
// 160:        
    { R_CAM_IMG_PRECAP_MEMORY_LOCATION, R_CAM_IMG_PRECAP_MEMORY_LOCATION_PORTRAIT, R_CAM_IMG_PRECAP_MEMORY_LOCATION_VIEWMODE, R_CAM_IMG_PRECAP_MEMORY_LOCATION_LEFT },
    { R_CAM_IMG_PRECAP_MEMORY_LOCATION_AH, R_CAM_IMG_PRECAP_MEMORY_LOCATION_AH_PORTRAIT, R_CAM_IMG_PRECAP_MEMORY_LOCATION_AH_PORTRAIT, R_CAM_IMG_PRECAP_MEMORY_LOCATION_AH_LEFT },
    { R_CAM_VIDEO_PRECAP_MEMORY_LOCATION, R_CAM_VIDEO_PRECAP_MEMORY_LOCATION_PORTRAIT, R_CAM_VIDEO_PRECAP_MEMORY_LOCATION_PORTRAIT, R_CAM_VIDEO_PRECAP_MEMORY_LOCATION_LEFT },
    { R_CAM_VIDEO_PRECAP_MEMORY_LOCATION_AH, R_CAM_VIDEO_PRECAP_MEMORY_LOCATION_AH_PORTRAIT, R_CAM_VIDEO_PRECAP_MEMORY_LOCATION_AH_PORTRAIT, R_CAM_VIDEO_PRECAP_MEMORY_LOCATION_AH_LEFT },    
    { R_CAM_SNAPSHOT_RECT_STILL_ROTATED, R_CAM_SNAPSHOT_RECT_STILL_ROTATED, R_CAM_SNAPSHOT_RECT_STILL_ROTATED, R_CAM_SNAPSHOT_RECT_STILL_ROTATED },
    { R_CAM_SETTING_QUALITY_SLIDER_LAYOUT_AH, R_CAM_SETTING_QUALITY_SLIDER_LAYOUT_AH, R_CAM_SETTING_QUALITY_SLIDER_LAYOUT_AH, R_CAM_SETTING_QUALITY_SLIDER_LAYOUT_AH },
    { R_CAM_SETTING_QUALITY_SLIDER_LAYOUT_APAC, R_CAM_SETTING_QUALITY_SLIDER_LAYOUT_APAC, R_CAM_SETTING_QUALITY_SLIDER_LAYOUT_APAC, R_CAM_SETTING_QUALITY_SLIDER_LAYOUT_APAC },
    { R_CAM_CAPTURE_SETUP_SELF_TIMER, R_CAM_CAPTURE_SETUP_SELF_TIMER, R_CAM_CAPTURE_SETUP_SELF_TIMER, R_CAM_CAPTURE_SETUP_SELF_TIMER },
    { R_CAM_VIDEO_CAP_LIMIT_RECORDING_ICON, R_CAM_VIDEO_CAP_LIMIT_RECORDING_ICON_PORTRAIT, R_CAM_VIDEO_CAP_LIMIT_RECORDING_ICON_VIEWMODE, R_CAM_VIDEO_CAP_LIMIT_RECORDING_ICON_LEFT },          
    { R_CAM_TIMELAPSE_POST_CAPTURE_MENUBAR, R_CAM_TIMELAPSE_POST_CAPTURE_MENUBAR, R_CAM_TIMELAPSE_POST_CAPTURE_MENUBAR, R_CAM_TIMELAPSE_POST_CAPTURE_MENUBAR },
// 170:      
    { R_CAM_LAYOUT_ZOOM_PANE_HORIZ_CAMCORDER, R_CAM_LAYOUT_ZOOM_PANE_HORIZ_CAMCORDER, R_CAM_LAYOUT_ZOOM_PANE_HORIZ_CAMCORDER, R_CAM_LAYOUT_ZOOM_PANE_HORIZ_CAMCORDER_LEFT },
    { R_CAM_LAYOUT_ZOOM_PANE_SHAFT_HORIZ_CAMCORDER, R_CAM_LAYOUT_ZOOM_PANE_SHAFT_HORIZ_CAMCORDER, R_CAM_LAYOUT_ZOOM_PANE_SHAFT_HORIZ_CAMCORDER, R_CAM_LAYOUT_ZOOM_PANE_SHAFT_HORIZ_CAMCORDER_LEFT },
    { R_CAM_CAPTURE_SETUP_CONT_NOVF_TITLETEXT_LAYOUT, R_CAM_CAPTURE_SETUP_CONT_NOVF_TITLETEXT_LAYOUT_ID, R_CAM_CAPTURE_SETUP_CONT_NOVF_TITLETEXT_LAYOUT, R_CAM_CAPTURE_SETUP_CONT_NOVF_TITLETEXT_LAYOUT },
    { R_CAM_CAPTURE_SETUP_CONT_NOVF_TITLETEXT_LAYOUT_AH, R_CAM_CAPTURE_SETUP_CONT_NOVF_TITLETEXT_LAYOUT_AH_ID, R_CAM_CAPTURE_SETUP_CONT_NOVF_TITLETEXT_LAYOUT_AH, R_CAM_CAPTURE_SETUP_CONT_NOVF_TITLETEXT_LAYOUT_AH },
    { R_CAM_CAPTURE_SETUP_CONT_NOVF_TITLETEXT_LAYOUT_APAC, R_CAM_CAPTURE_SETUP_CONT_NOVF_TITLETEXT_LAYOUT_APAC_ID, R_CAM_CAPTURE_SETUP_CONT_NOVF_TITLETEXT_LAYOUT_APAC, R_CAM_CAPTURE_SETUP_CONT_NOVF_TITLETEXT_LAYOUT_APAC },
    { R_CAM_VIDEO_FILETYPE_PANE_CAMCORDER, R_CAM_VIDEO_FILETYPE_PANE_PORTRAIT, R_CAM_VIDEO_FILETYPE_PANE_VIEWMODE, R_CAM_VIDEO_FILETYPE_PANE_CAMCORDER_LEFT },
    { R_CAM_VIDEO_CAP_LIMIT_FILE_TYPE, R_CAM_VIDEO_CAP_LIMIT_FILE_TYPE_PORTRAIT, R_CAM_VIDEO_CAP_LIMIT_FILE_TYPE_VIEWMODE, R_CAM_VIDEO_CAP_LIMIT_FILE_TYPE_LEFT },
    { R_CAM_VIDEO_PRECAP_QUALITY_ICONS, R_CAM_VIDEO_PRECAP_QUALITY_ICONS_PORTRAIT, R_CAM_VIDEO_PRECAP_QUALITY_ICONS_VIEWMODE, R_CAM_VIDEO_PRECAP_QUALITY_ICONS_LEFT },
    { R_CAM_VIDEO_CAP_LIMIT_QUALITY_ICONS, R_CAM_VIDEO_CAP_LIMIT_QUALITY_ICONS_PORTRAIT, R_CAM_VIDEO_CAP_LIMIT_QUALITY_ICONS_VIEWMODE, R_CAM_VIDEO_CAP_LIMIT_QUALITY_ICONS_LEFT },
    { R_CAM_IMG_PRECAP_QUALITY_ICONS, R_CAM_IMG_PRECAP_QUALITY_ICONS_PORTRAIT, R_CAM_IMG_PRECAP_QUALITY_ICONS_VIEWMODE, R_CAM_IMG_PRECAP_QUALITY_ICONS_LEFT },
// 180:
    { R_CAM_VIDEO_CAP_UNLIMITED_REMAINING_TIME, R_CAM_VIDEO_CAP_UNLIMITED_REMAINING_TIME_PORTRAIT, R_CAM_VIDEO_CAP_UNLIMITED_REMAINING_TIME_VIEWMODE, R_CAM_VIDEO_CAP_UNLIMITED_REMAINING_TIME_LEFT },
    { R_CAM_VIDEO_CAP_UNLIMITED_REMAINING_TIME_AH, R_CAM_VIDEO_CAP_UNLIMITED_REMAINING_TIME_AH_PORTRAIT, R_CAM_VIDEO_CAP_UNLIMITED_REMAINING_TIME_AH_VIEWMODE, R_CAM_VIDEO_CAP_UNLIMITED_REMAINING_TIME_AH_LEFT },
    { R_CAM_VIDEO_CAP_UNLIMIT_RECORDING_ICON, R_CAM_VIDEO_CAP_UNLIMIT_RECORDING_ICON_PORTRAIT, R_CAM_VIDEO_CAP_UNLIMIT_RECORDING_ICON_VIEWMODE, R_CAM_VIDEO_CAP_UNLIMIT_RECORDING_ICON_LEFT },
    { R_CAM_VIDEO_CAP_UNLIMIT_FILE_TYPE, R_CAM_VIDEO_CAP_UNLIMIT_FILE_TYPE_PORTRAIT, R_CAM_VIDEO_CAP_UNLIMIT_FILE_TYPE_VIEWMODE, R_CAM_VIDFILETYPE_CAPTURE_ICON_RECT_NOPROGBAR_CAMCORDER_LEFT },
    { R_CAM_VIDEO_CAP_UNLIMIT_QUALITY_ICONS, R_CAM_VIDEO_CAP_UNLIMIT_QUALITY_ICONS_PORTRAIT, R_CAM_VIDEO_CAP_UNLIMIT_QUALITY_ICONS_VIEWMODE, R_CAM_VIDEO_CAP_UNLIMIT_QUALITY_ICONS_LEFT },
    { R_CAM_CAPTURE_SETUP_LISTBOX_WIDTH_NOVF, R_CAM_CAPTURE_SETUP_LISTBOX_WIDTH_NOVF, R_CAM_CAPTURE_SETUP_LISTBOX_WIDTH_NOVF, R_CAM_CAPTURE_SETUP_LISTBOX_WIDTH_NOVF },
    { R_CAM_CAPSETUP_SCENE_LISTBOX_TEXT_RECT, R_CAM_CAPSETUP_SCENE_LISTBOX_TEXT_RECT, R_CAM_CAPSETUP_SCENE_LISTBOX_TEXT_RECT, R_CAM_CAPSETUP_SCENE_LISTBOX_TEXT_RECT },
    { R_CAM_CAPSETUP_SCENE_LISTBOX_TEXT_RECT_APAC, R_CAM_CAPSETUP_SCENE_LISTBOX_TEXT_RECT_APAC, R_CAM_CAPSETUP_SCENE_LISTBOX_TEXT_RECT_APAC, R_CAM_CAPSETUP_SCENE_LISTBOX_TEXT_RECT_APAC },
    { R_CAM_CAPSETUP_SCENE_LISTBOX_TEXT_RECT_AH, R_CAM_CAPSETUP_SCENE_LISTBOX_TEXT_RECT_AH, R_CAM_CAPSETUP_SCENE_LISTBOX_TEXT_RECT_AH, R_CAM_CAPSETUP_SCENE_LISTBOX_TEXT_RECT_AH },
    { R_CAM_VIDEO_CAP_UNLIMITED_ELAPSED_TIME, R_CAM_VIDEO_CAP_UNLIMITED_ELAPSED_TIME_PORTRAIT, R_CAM_VIDEO_CAP_UNLIMITED_ELAPSED_TIME_VIEWMODE, R_CAM_VIDEO_CAP_UNLIMITED_ELAPSED_TIME_LEFT },
// 190:
    { R_CAM_VIDEO_CAP_UNLIMITED_ELAPSED_TIME_AH, R_CAM_VIDEO_CAP_UNLIMITED_ELAPSED_TIME_AH_PORTRAIT, R_CAM_VIDEO_CAP_UNLIMITED_ELAPSED_TIME_AH_VIEWMODE, R_CAM_VIDEO_CAP_UNLIMITED_ELAPSED_TIME_AH_LEFT },
    { R_CAM_CAPSETUP_MODE_LISTBOX_ICON_RECT_AH, R_CAM_CAPSETUP_MODE_LISTBOX_ICON_RECT_AH, R_CAM_CAPSETUP_MODE_LISTBOX_ICON_RECT_AH, R_CAM_CAPSETUP_MODE_LISTBOX_ICON_RECT_AH },
    { R_CAM_VIDEO_CAP_UNLIMIT_MEMORY_LOCATION, R_CAM_VIDEO_CAP_UNLIMIT_MEMORY_LOCATION_PORTRAIT, R_CAM_VIDEO_CAP_UNLIMIT_MEMORY_LOCATION_VIEWMODE, R_CAM_VIDEO_CAP_UNLIMIT_MEMORY_LOCATION_LEFT },
    { R_CAM_VIDEO_CAP_LIMIT_RECORDING_ICON_AH, R_CAM_VIDEO_CAP_LIMIT_RECORDING_ICON_AH_PORTRAIT, R_CAM_VIDEO_CAP_LIMIT_RECORDING_ICON_AH_VIEWMODE, R_CAM_VIDEO_CAP_LIMIT_RECORDING_ICON_AH_LEFT },
    { R_CAM_VIDEO_CAP_UNLIMIT_MEMORY_LOCATION_AH, R_CAM_VIDEO_CAP_UNLIMIT_MEMORY_LOCATION_AH_PORTRAIT, R_CAM_VIDEO_CAP_UNLIMIT_MEMORY_LOCATION_AH_VIEWMODE, R_CAM_VIDEO_CAP_UNLIMIT_MEMORY_LOCATION_AH_LEFT },
    { R_CAM_VIDEO_CAP_UNLIMIT_RECORDING_ICON_AH, R_CAM_VIDEO_CAP_UNLIMIT_RECORDING_ICON_AH_PORTRAIT, R_CAM_VIDEO_CAP_UNLIMIT_RECORDING_ICON_AH_VIEWMODE, R_CAM_VIDEO_CAP_UNLIMIT_RECORDING_ICON_AH_LEFT },
    { R_CAM_IMG_PRECAP_LOCATION, R_CAM_IMG_PRECAP_LOCATION_PORTRAIT, R_CAM_IMG_PRECAP_LOCATION_VIEWMODE, R_CAM_IMG_PRECAP_LOCATION_LEFT }

};

#endif // CAM_RESOURCE_LOOKUP_H
