/*
* Copyright (c) 2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  tabbed view control implementation class with doublestyle listbox 
*
*/

#ifndef     __CVIMPSTUISINGLELISTBOXTABVIEWCONTROL_H
#define     __CVIMPSTUISINGLELISTBOXTABVIEWCONTROL_H

#include "mvimpstuitabbedviewcontrol.h"
#include "cvimpstuisinglestylelistbox.h"

class CVIMPSTUiSingleStyleListBox;
// CLASS DECLARATION
/**
 * Tabbed view control. Shows list of contacts.
 *  @lib vimpstui.lib
 *  @since S60 v5.0 
 */
class CVIMPSTUiSingleListBoxTabViewControl : public CCoeControl,
									            public MVIMPSTProcessArrayObserver,
									            public MEikListBoxObserver,
            									public MCoeControlObserver,
            								    public MVIMPSTUiTabbedViewControl
    {
    public: // Constructor and destructor
        void  HandleAvatarChangeL( const TDesC& aUserId );
        /**
         * Creates a new CImContactsTabbedViewControl.
         *
         * @param aTabbedView reference to view.
         * @param aKeyEventHandler Key event handler to be used
         * @param aCommandHandler reference to commandhandler
         * @param aServiceId Id of the service
         * @param aBrandHandler reference to brandhandler
         * @param aEngine reference to engine
         */
        static CVIMPSTUiSingleListBoxTabViewControl* NewL( CVIMPSTUiTabbedView& aTabbedView, MPbk2KeyEventHandler* aKeyEventHandler, 
        										MVIMPSTCmdHandler& aCommandHandler,
        										TUint32 aServiceId,
        										CVIMPSTUiBrandData& aBrandHandler,
        										MVIMPSTEngine& aEngine,
        										CEikButtonGroupContainer* aCba);
        
        /**
         * Creates a new CImContactsTabbedViewControl and leaves it to
         * cleanup stack.
         * @see NewL
         *
         * @param aTabbedView reference to view.
         * @param aKeyEventHandler Key event handler to be used
         * @param aCommandHandler reference to commandhandler
         * @param aServiceId Id of the service
         * @param aBrandHandler reference to brandhandler
         * @param aEngine reference to engine
         */
        static CVIMPSTUiSingleListBoxTabViewControl* NewLC( CVIMPSTUiTabbedView& aTabbedView,MPbk2KeyEventHandler* aKeyEventHandler,
        											MVIMPSTCmdHandler& aCommandHandler,
        											TUint32 aServiceId,
        											CVIMPSTUiBrandData& aBrandHandler,
        											MVIMPSTEngine& aEngine,
        											CEikButtonGroupContainer* aCba);
        
        /**
         * Destructor.
         */
        ~CVIMPSTUiSingleListBoxTabViewControl();
    
    public : // from MIMArrayProcessObserver
        /**
         * @see MIMArrayProcessObserver.
         */
        void HandleAdditionL(TVIMPSTEnums::TItem type, TInt aIndex);
        
       
     	 /**
          * @see MIMArrayProcessObserver.
          */
     	void HandleDeletionL(TVIMPSTEnums::TItem type, TInt aIndex);
        
    public://from MEikListBoxObserver
    
		/**
         * From MEikListBoxObserver, Handles event's generated by listbox
		 * @see MEikListBoxObserver
         */
		void HandleListBoxEventL( CEikListBox* aListBox,
			TListBoxEvent aEventType );
    
    public: //from MCoeControlObserver
    	/**
	     * Handles events from findpane and forwards them to listbox filter.
	     * @see MCoeControlObserver
	     */
	    void HandleControlEventL( CCoeControl* aControl,TCoeEvent aEventType );
	    
            /**

        /**
         * Get access to listbox model's filter
         * @return model's filter
         */                     
        CAknListBoxFilterItems* ListFilter();
        
   
    public: // New functions
        
        /**
         * Returns the currently focused item's index.
         * @return TInt, current item index.
         */
        TInt CurrentItemIndex() const;
        
        /**
         * Sets the currently focused item's index.
         *
         * @param aIndex new currently focused index
         */
        void SetCurrentItemIndex( TInt aIndex );
        
		/**
         * Sets the currently focused item's index and updates the control
         * on the display.
         *
         * @param aIndex new currently focused index
         */
        void SetCurrentItemIndexAndDraw( TInt aIndex );
        
        /**
         * Handles item addition for this control.
         */
        void HandleItemAdditionL();
        /**
         * Handles item removal for this control.
         */
        void HandleItemRemovalL();

        /**
         * Sets list box empty text.
         *
         * @param aResourceId resource id of a empty text
         */
        void SetListEmptyTextL( TInt aResourceId );
        
        /**
         * send the message using selected item
         * this will launch the conversation view if im is enabled.
         */
        void SendMessageL();
        
        /**
         * Updates view after edit.
         * @param aIndex is the index of item that has changed.
         * @param aType is list item type. 
         */
        void UpdateViewL( TInt aIndex, TVIMPSTEnums::TItem aType);
        
		/**
		* @see MVIMPSTUiTabbedViewControl.
		*/
		void HandleAvatarRefreshL( const TDesC& aUserId,TBool aBlock );
		
        
        /**
	     * LoadsBitmap array.
	     */	
        void LoadBitmapsL();
        
     
        
        /**
        * Activates find-pane
		*/
		void ActivateFindPaneL();

        /**
        * De-activates find-pane
		*/
		void DeactivateFindPaneL();
		
		/**
         * Sets the lock status of softkeys
         * @param aLock new status of lock (ETrue: locked, EFalse: Unlocked)
         */                     
        void SetCbaLockL( TBool aLock );


        /**
         * Updates Softkeys according to current focus
         * @param aUseDefaultCba Flag to force the default sofkeys for view.
         * Default value is false.
         */                     
        void UpdateCbaL( TBool aUseDefaultCba = EFalse );
        
		/**
		*Handle the avatar deletion in UI
		*/
		void SetFocussedId(const TDesC& aContact)  ;

		/**
		* the avatar deletion in UI
		*/
		TPtrC GetFocussedId() ;

    private: // From CCoeControl, standard control functionality
        
        /**
         * @see CCoeControl
         */
        TKeyResponse OfferKeyEventL
            ( const TKeyEvent& aKeyEvent, TEventCode aType );
        
        /**
         * @see CCoeControl
         */
        void SizeChanged();
        
        /**
         * @see CCoeControl
         */
        TInt CountComponentControls() const;
        
        /**
         * @see CCoeControl
         */
        CCoeControl* ComponentControl( TInt aIndex ) const;
        
        /**
         * @see CCoeControl
         */
        void FocusChanged( TDrawNow aDrawNow );

    private: // Implementation
        /**
         * Standard C++ constructor
         *
         * @param aTabbedView reference to view.
         * @param aKeyEventHandler Key event handler to be used
         * @param aCommandHandler reference to commandhandler
         * @param aServiceId Id of the service
         * @param aBrandHandler reference to brandhandler
         * @param aEngine reference to engine
         */    
        CVIMPSTUiSingleListBoxTabViewControl(   CVIMPSTUiTabbedView& aTabbedView,MPbk2KeyEventHandler* aKeyEventHandler,
                    							MVIMPSTCmdHandler& aCommandHandler,
                    							TUint32 aServiceId,
                    							CVIMPSTUiBrandData& aBrandHandler,
                    							MVIMPSTEngine& aEngine,
                    							CEikButtonGroupContainer* aCba);
        
        /**
         * Performs the 2nd phase of construction.
         * 
         */        
        void ConstructL();
		
		/**
         * Layouts current components according to AVKON LAF
		 */
		void SetLayout();
		
		
		void SetFocusAndMakeItemVisible();
		
    public:
        
        /**
        * Sets the iClrFindPaneFlag
        */
        void SetClrFindPaneFlag(TBool aFlag);
        
        /**
        * Checks if the last contact is focused and Sets the iLastItemFlag
        */            
        void CheckAndSetLastItemFlag(); 
       
        /**
         * returns the CCoeControl* pointer 
         */
        CCoeControl* CoeControl();

		
		
    private: // Data
    
    	// not owned
    	 CVIMPSTUiTabbedView& iTabbedView;
    	 
    	// Not owned: key event handler
    	MPbk2KeyEventHandler* iKeyEventHandler;
    	
    	//Holds the Ref to CMd Handler - Doesnt Own
    	MVIMPSTCmdHandler& iCommandHandler;
    	
    	//Doesnt Own
        MVIMPSTProcessArray& iArrayProcess;         
         
        //Service Id 
		TUint32 iServiceId ;
		
		//doesnt own - Brand Handler
		CVIMPSTUiBrandData& iBrandHandler;
		
		//doesnt own - Engine Handler
		MVIMPSTEngine& iEngine;
		   	

        // Owns. Listbox to view friends-list data
        CVIMPSTUiSingleStyleListBox* iListBox;
         
        // Owns. Search field.
		CAknSearchField* iFindbox;
		
		// is find pane visible.
        TBool iFindPaneIsVisible;
        
        //current state
        TBool iCurrentState;
        
        // Owns: Flag to check whether the last contact was selected
        TBool iLastItemFlag;
 
        // CBA. not owned
        CEikButtonGroupContainer* iCba;     

        // Lock status foc softkeys
        TBool iCbaLock;
        
        // Storage for previous focus
        TVIMPSTEnums::TItem iLastFocusedItemType;
        
        //flag to check to clear find pane
        TBool iClrFindPaneFlag;

        //indicate command to be executed on enter key event
        TInt iCurrentCmdToExe;
    };

#endif // __CVIMPSTUISINGLELISTBOXTABVIEWCONTROL_H

// End of file
