/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.cssparser;

import com.nokia.tools.themeinstaller.cssparser.CSSMatchMaker;
import com.nokia.tools.themeinstaller.cssparser.CSSPropertyValue;
import com.nokia.tools.themeinstaller.cssparser.CSSRule;
import com.nokia.tools.themeinstaller.cssparser.CSSStyleProperty;
import com.nokia.tools.themeinstaller.cssparser.ElementTypeResolver;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class CSSDOMProcessor {
    public static final String STRING_PROPERTY = "styleproperty";
    public static final String STRING_PSEUDOCLASS = "pseudoclass";
    public static final String STRING_NAME = "name";
    public static final String STRING_VALUE = "value";
    public static final String STRING_INHERIT = "inherit";
    private static final char CHAR_COLON = ':';
    private static final String STRING_SEPARATOR = "|";
    private static final String[] UNSTYLABLE_ELEMENTS_TABLE = new String[]{"styleproperty"};
    private static ElementTypeResolver iElementTypeResolver = new ElementTypeResolver();
    public static final String[] INHERITABLE_PROPERTIES = new String[]{"visibility", "block-progression", "direction", "color", "font-family", "font-size", "font-weight", "font-style", "_s60-tab-style", "_s60-tab-color"};
    private CSSMatchMaker iCSSMatchMaker = new CSSMatchMaker();

    private static void sortRules(Vector rules) {
        Collections.sort(rules);
    }

    private static boolean isStylableElement(Element aElement) {
        int i = 0;
        while (i < UNSTYLABLE_ELEMENTS_TABLE.length) {
            if (UNSTYLABLE_ELEMENTS_TABLE[i].equals(aElement.getTagName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void applyRulesToDom(Document aDocument, Vector aRuleList) {
        DocumentTraversal traversal = (DocumentTraversal)((Object)aDocument);
        NodeIterator iterator = traversal.createNodeIterator(aDocument.getDocumentElement(), 1, null, true);
        Node node = iterator.nextNode();
        while (node != null) {
            Element element = (Element)node;
            if (CSSDOMProcessor.isStylableElement(element)) {
                Vector<CSSRule> rulesMatch = new Vector<CSSRule>();
                int i = 0;
                while (i < aRuleList.size()) {
                    CSSRule rule = (CSSRule)aRuleList.get(i);
                    if (this.iCSSMatchMaker.match(rule, element)) {
                        rulesMatch.add(rule);
                    }
                    ++i;
                }
                CSSDOMProcessor.sortRules(rulesMatch);
                int j = 0;
                while (j < rulesMatch.size()) {
                    CSSRule matchingRule = (CSSRule)rulesMatch.elementAt(j);
                    this.applyRuleToElement(element, matchingRule);
                    ++j;
                }
            }
            node = iterator.nextNode();
        }
        this.applyInheritance(aDocument);
    }

    public boolean isInheritableProperty(String aProperty) {
        int i = 0;
        while (i < INHERITABLE_PROPERTIES.length) {
            if (aProperty.equals(INHERITABLE_PROPERTIES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean canInherit(Element aElement, String aPropertyName) {
        return this.canInherit(aElement, aPropertyName, null);
    }

    public boolean canInherit(Element aElement, String aPropertyName, String aPropertyValue) {
        if (aPropertyValue != null && aPropertyValue.equals(STRING_INHERIT)) {
            return true;
        }
        if (!this.isInheritableProperty(aPropertyName)) {
            return false;
        }
        return iElementTypeResolver.canInherit(aElement.getNodeName());
    }

    private void applyInheritance(Document aDocument) {
        DocumentTraversal traversal = (DocumentTraversal)((Object)aDocument);
        NodeIterator iterator = traversal.createNodeIterator(aDocument.getDocumentElement(), 1, null, true);
        Node node = iterator.nextNode();
        while (node != null) {
            Element element = (Element)node;
            if (CSSDOMProcessor.isStylableElement(element) && iElementTypeResolver.canInherit(element.getNodeName())) {
                this.applyInheritance(element);
            }
            node = iterator.nextNode();
        }
    }

    private void applyInheritance(Element aElement) {
        int i = 0;
        while (i < INHERITABLE_PROPERTIES.length) {
            String inheritableProperty = INHERITABLE_PROPERTIES[i];
            if (iElementTypeResolver.canInherit(aElement.getNodeName()) && !CSSDOMProcessor.hasAttribute(aElement, inheritableProperty) && CSSDOMProcessor.hasParentElementWithAttribute(aElement, inheritableProperty) && CSSDOMProcessor.hasChildElementWithAttribute(aElement, STRING_PROPERTY, inheritableProperty) == null) {
                this.addNewChildElement(aElement, STRING_PROPERTY, inheritableProperty, "35|inherit");
            }
            ++i;
        }
    }

    private static boolean hasParentElementWithAttribute(Element aElement, String aAttributeName) {
        Node n = aElement.getParentNode();
        while (n != null) {
            if (n.getNodeType() == 1 && CSSDOMProcessor.hasChildElementWithAttribute((Element)n, STRING_PROPERTY, aAttributeName) != null) {
                return true;
            }
            n = n.getParentNode();
        }
        return false;
    }

    private void applyRuleToElement(Element aElement, CSSRule aRule) {
        HashMap styleMap = aRule.getStyleMap();
        for (String keyName : styleMap.keySet()) {
            CSSPropertyValue propertyValue;
            Vector values;
            CSSStyleProperty property;
            if (aRule.isPseudo()) {
                CSSStyleProperty property2;
                String selectorString = aRule.getSelector().toString();
                String pseudoPart = selectorString.substring(selectorString.lastIndexOf(58) + 1);
                Vector<NameValuePair> elementsAttributes = new Vector<NameValuePair>();
                elementsAttributes.add(new NameValuePair(STRING_NAME, keyName));
                elementsAttributes.add(new NameValuePair(STRING_PSEUDOCLASS, pseudoPart));
                Element e = CSSDOMProcessor.hasChildElementWithAttributes(aElement, STRING_PROPERTY, elementsAttributes);
                if (e != null && CSSDOMProcessor.hasAttribute(e, STRING_NAME, keyName)) {
                    property2 = (CSSStyleProperty)styleMap.get(keyName);
                    Vector values2 = property2.getValues();
                    CSSPropertyValue propertyValue2 = (CSSPropertyValue)values2.elementAt(0);
                    e.setAttribute(STRING_VALUE, propertyValue2.getValueTypeAndValue());
                    int i = 1;
                    while (i < values2.size()) {
                        propertyValue2 = (CSSPropertyValue)values2.elementAt(i);
                        e.setAttribute(STRING_VALUE + i, propertyValue2.getValueTypeAndValue());
                        ++i;
                    }
                    continue;
                }
                property2 = (CSSStyleProperty)styleMap.get(keyName);
                Vector values3 = property2.getValues();
                CSSPropertyValue propertyValue3 = (CSSPropertyValue)values3.elementAt(0);
                Element newElement = this.addNewChildElement(aElement, STRING_PROPERTY, keyName, propertyValue3.getValueTypeAndValue(), pseudoPart);
                int i = 1;
                while (i < values3.size()) {
                    propertyValue3 = (CSSPropertyValue)values3.elementAt(i);
                    newElement.setAttribute(STRING_VALUE + i, propertyValue3.getValueTypeAndValue());
                    ++i;
                }
                continue;
            }
            Vector<NameValuePair> elementsAttributes = new Vector<NameValuePair>();
            elementsAttributes.add(new NameValuePair(STRING_NAME, keyName));
            Element e = CSSDOMProcessor.hasChildElementWithAttributes(aElement, STRING_PROPERTY, elementsAttributes);
            if (e != null && CSSDOMProcessor.hasAttribute(e, STRING_NAME, keyName)) {
                property = (CSSStyleProperty)styleMap.get(keyName);
                values = property.getValues();
                propertyValue = (CSSPropertyValue)values.elementAt(0);
                e.setAttribute(STRING_VALUE, propertyValue.getValueTypeAndValue());
                int i = 1;
                while (i < values.size()) {
                    propertyValue = (CSSPropertyValue)values.elementAt(i);
                    e.setAttribute(STRING_VALUE + i, propertyValue.getValueTypeAndValue());
                    ++i;
                }
                continue;
            }
            property = (CSSStyleProperty)styleMap.get(keyName);
            values = property.getValues();
            propertyValue = (CSSPropertyValue)values.elementAt(0);
            Element newElement = this.addNewChildElement(aElement, STRING_PROPERTY, keyName, propertyValue.getValueTypeAndValue());
            int i = 1;
            while (i < values.size()) {
                propertyValue = (CSSPropertyValue)values.elementAt(i);
                newElement.setAttribute(STRING_VALUE + i, propertyValue.getValueTypeAndValue());
                ++i;
            }
        }
    }

    private static boolean hasAttribute(Element aElement, String aValue) {
        return CSSDOMProcessor.hasAttribute(aElement, null, aValue);
    }

    private static boolean hasAttribute(Element aElement, String aName, String aValue) {
        if (aElement == null) {
            return false;
        }
        if (aElement.hasAttributes()) {
            NamedNodeMap nnm = aElement.getAttributes();
            int i = 0;
            while (i < nnm.getLength()) {
                Node att = nnm.item(i);
                if (aName != null ? att.getNodeValue().equals(aValue) && att.getNodeName().equals(aName) : att.getNodeValue().equals(aValue)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean hasAttributes(Element aElement, Vector aAttributes) {
        if (aElement == null) {
            return false;
        }
        if (aElement.hasAttributes()) {
            int i = 0;
            while (i < aAttributes.size()) {
                String value;
                NameValuePair nameValuePair = (NameValuePair)aAttributes.get(i);
                String name = nameValuePair.getName();
                if (!CSSDOMProcessor.hasAttribute(aElement, name, value = nameValuePair.getValue())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static Element hasChildElementWithAttribute(Element aParent, String aElementName, String aName) {
        Node n = aParent.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 1 && CSSDOMProcessor.hasAttribute((Element)n, aName) && n.getNodeName().equals(aElementName)) {
                return (Element)n;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    private static Element hasChildElementWithAttributes(Element aParent, String aElementName, Vector aNameValuePairs) {
        Node n = aParent.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 1 && n.getNodeName().equals(aElementName) && CSSDOMProcessor.hasAttributes((Element)n, aNameValuePairs)) {
                return (Element)n;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    private Element addNewChildElement(Element aParent, String aElementName, String aKeyName, String aKeyValue) {
        return this.addNewChildElement(aParent, aElementName, aKeyName, aKeyValue, null);
    }

    private Element addNewChildElement(Element aParent, String aElementName, String aKeyName, String aKeyValue, String aPseudo) {
        Document document = aParent.getOwnerDocument();
        String namespaceUri = aParent.getNamespaceURI();
        Element newElement = document.createElementNS(namespaceUri, aElementName);
        if (aPseudo != null) {
            newElement.setAttribute(STRING_PSEUDOCLASS, aPseudo);
        }
        newElement.setAttribute(STRING_NAME, aKeyName);
        newElement.setAttribute(STRING_VALUE, aKeyValue);
        aParent.appendChild(newElement);
        return newElement;
    }

    private class NameValuePair {
        private String iName;
        private String iValue;

        NameValuePair(String aName, String aValue) {
            this.iName = aName;
            this.iValue = aValue;
        }

        public String getName() {
            return this.iName;
        }

        public String getValue() {
            return this.iValue;
        }
    }
}

