/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.installationmanager;

import java.util.Vector;

public class InstallationList {
    private static final int NOT_FOUND = -1;
    private static final String EXT_PREFIX = ".o";
    private Vector iLanguages = new Vector();

    public void addInstall(Integer aLanguage) {
        this.iLanguages.add(aLanguage);
    }

    public boolean removeInstall(String aODTFileName) {
        String language;
        int languageId = -1;
        int extIndex = -1;
        if (aODTFileName != null) {
            extIndex = aODTFileName.lastIndexOf(EXT_PREFIX);
        }
        if (extIndex >= 0 && (language = aODTFileName.substring(extIndex + EXT_PREFIX.length())) != null && !language.equals("")) {
            languageId = Integer.valueOf(language);
        }
        return this.removeInstall(languageId);
    }

    public boolean removeInstall(int aLanguage) {
        boolean result = false;
        int index = this.findLanguage(aLanguage);
        if (index >= 0) {
            this.iLanguages.remove(index);
            result = true;
        }
        return result;
    }

    public boolean installsExist() {
        return this.iLanguages.size() > 0;
    }

    private int findLanguage(int aLanguage) {
        int count = this.iLanguages.size();
        int i = 0;
        while (i < count) {
            Integer integer = (Integer)this.iLanguages.elementAt(i);
            if (integer == aLanguage) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

