/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.odtconverter;

import com.nokia.tools.themeinstaller.odtconverter.ODTDataOutputStream;
import com.nokia.tools.themeinstaller.odtconverter.ODTException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public class ODTHeader
extends Hashtable {
    private static final long serialVersionUID = 1L;
    public static final String ApplicationUID = "ApplicationUID";
    public static final String ProviderUID = "ProviderUID";
    public static final String ThemeUID = "ThemeUID";
    public static final String ProviderName = "ProviderName";
    public static final String ThemeFullName = "ThemeFullName";
    public static final String ThemeShortName = "ThemeShortName";
    public static final String ThemeVersion = "ThemeVersion";
    public static final String ScreenSizeX = "ScreenSizeX";
    public static final String ScreenSizeY = "ScreenSizeY";
    public static final String Language = "Language";
    public static final String Flags = "Flags";

    public byte[] getBinaryODTHeader() throws IOException, ODTException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ODTDataOutputStream dos = new ODTDataOutputStream(baos);
        byte[] binaryODTHeader = null;
        try {
            try {
                dos.writeUnsignedInt32((Long)this.get(ApplicationUID));
                dos.writeUnsignedInt32((Long)this.get(ProviderUID));
                dos.writeUnsignedInt32((Long)this.get(ThemeUID));
                dos.writeString16((String)this.get(ProviderName));
                dos.writeString16((String)this.get(ThemeFullName));
                dos.writeString16((String)this.get(ThemeShortName));
                dos.writeString16((String)this.get(ThemeVersion));
                dos.writeInt32((Integer)this.get(ScreenSizeX));
                dos.writeInt32((Integer)this.get(ScreenSizeY));
                dos.writeInt32((Integer)this.get(Language));
                dos.writeInt32((Integer)this.get(Flags));
                binaryODTHeader = baos.toByteArray();
            }
            catch (Exception e) {
                throw new ODTException(e.getMessage());
            }
        }
        finally {
            if (dos != null) {
                dos.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return binaryODTHeader;
    }
}

