/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.defrep;

import com.nokia.tools.themeinstaller.defrep.IDefinitionRepository;
import com.nokia.tools.themeinstaller.defrep.operations.CopyOperation;
import com.nokia.tools.themeinstaller.defrep.operations.FileOperation;
import com.nokia.tools.themeinstaller.defrep.operations.StoreOperation;
import com.nokia.tools.themeinstaller.odtconverter.ConverterProperties;
import com.nokia.tools.themeinstaller.odtconverter.ODTHeader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Observer;

public class DefinitionRepository
implements IDefinitionRepository {
    private static final String THEMES_ROOT_ROM = "themes_datacage_rom";
    private static final String THEMES_ROOT_USER_DISC = "themes_datacage_user_disc";
    private static final String ODT_FILE_EXT_FORMAT = "odt_file_ext_format";
    private static final String ODT_RESOURCES_FOLDER = "odt_resources_folder";
    private static final String ODT_LANG_RESOURCES_FOLDER = "odt_lang_resources_folder";
    private static DefinitionRepository sInstance = null;

    private DefinitionRepository() {
    }

    public static DefinitionRepository getInstance() {
        if (sInstance == null) {
            sInstance = new DefinitionRepository();
        }
        return sInstance;
    }

    public void copy(File aSource, File aDestination, boolean aAppend, Observer aListener) {
        CopyOperation operation = new CopyOperation(aSource, aDestination, aAppend);
        operation.addObserver(aListener);
        this.performOperation(operation);
    }

    public void store(File aDestination, InputStream aStream, Observer aListener) {
        StoreOperation operation = new StoreOperation(aDestination, aStream);
        operation.addObserver(aListener);
        this.performOperation(operation);
    }

    public void storeODT(File aDestination, ODTHeader aHeader, InputStream aStream, Observer aListener) throws IOException {
        File destination = new File(this.createODTPath(aDestination, aHeader));
        this.store(destination, aStream, aListener);
    }

    public void copyResource(File aSource, File aDestination, ODTHeader aHeader, Observer aListener) throws IOException {
        ConverterProperties properties = ConverterProperties.getInstance();
        StringBuffer odtPath = this.combineDirectory(aDestination, aHeader, properties);
        Integer language = (Integer)aHeader.get("Language");
        if (language != null) {
            String template = properties.getProperty(ODT_LANG_RESOURCES_FOLDER);
            Object[] formatArguments = new Integer[]{language};
            odtPath.append(String.format(template, formatArguments));
        } else {
            odtPath.append(properties.get(ODT_RESOURCES_FOLDER));
        }
        odtPath.append(aSource.getName());
        File destFile = new File(odtPath.toString());
        this.copy(aSource, destFile, false, aListener);
    }

    public String createODTPath(File aDestination, ODTHeader aHeader) {
        ConverterProperties properties = ConverterProperties.getInstance();
        StringBuffer odtPath = this.combineDirectory(aDestination, aHeader, properties);
        odtPath.append(aHeader.get("ThemeShortName"));
        String format = properties.getProperty(ODT_FILE_EXT_FORMAT);
        Object[] formatArguments = new Integer[]{(Integer)aHeader.get("Language")};
        odtPath.append(String.format(format, formatArguments));
        return odtPath.toString();
    }

    private StringBuffer combineDirectory(File aDestination, ODTHeader aHeader, ConverterProperties aProperties) {
        StringBuffer odtPath = new StringBuffer();
        odtPath.append(aDestination.getPath());
        if (!aDestination.getPath().endsWith(File.separator)) {
            odtPath.append(File.separator);
        }
        if (((Integer)aHeader.get("Flags") & 2) != 0) {
            odtPath.append(aProperties.getProperty(THEMES_ROOT_ROM));
        } else {
            odtPath.append(aProperties.getProperty(THEMES_ROOT_USER_DISC));
        }
        odtPath.append((Long)aHeader.get("ApplicationUID"));
        odtPath.append(File.separator);
        odtPath.append((Long)aHeader.get("ProviderUID"));
        odtPath.append(File.separator);
        odtPath.append((Long)aHeader.get("ThemeUID"));
        odtPath.append(File.separator);
        odtPath.append(aHeader.get("ThemeVersion"));
        odtPath.append(File.separator);
        return odtPath;
    }

    private void performOperation(FileOperation aOperation) {
        Thread thread = new Thread(aOperation);
        thread.start();
    }
}

