/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.installationmanager;

import com.nokia.tools.themeinstaller.installationmanager.IResourceInstaller;
import com.nokia.tools.themeinstaller.installationmanager.IThemeManifest;
import com.nokia.tools.themeinstaller.installationmanager.LanguageInstallEvent;
import com.nokia.tools.themeinstaller.installationmanager.LanguageSpecificData;
import com.nokia.tools.themeinstaller.localisation.Localisation;
import com.nokia.tools.themeinstaller.localisation.LocalisationStore;
import com.nokia.tools.themeinstaller.odtconverter.IParseOperationListener;
import com.nokia.tools.themeinstaller.odtconverter.ODTConverter;
import com.nokia.tools.themeinstaller.odtconverter.ODTDocument;
import com.nokia.tools.themeinstaller.odtconverter.ODTHeader;
import com.nokia.tools.themeinstaller.odtconverter.ODTResource;
import java.io.File;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class LanguageInstaller
extends Observable
implements IParseOperationListener {
    private ODTDocument iODTDocument = new ODTDocument();
    private ODTConverter iConverter = new ODTConverter();
    private IThemeManifest iManifest;
    private LanguageSpecificData iLanguage;
    private Vector iResources;
    private IResourceInstaller iResourceInstaller;
    private File iLocSettings;

    public LanguageInstaller(Observer aListener, IThemeManifest aManifest, LanguageSpecificData aLanguage, File aLocSettings, IResourceInstaller aResourceInstaller) {
        this.iConverter.addListener(this);
        this.iManifest = aManifest;
        this.iLanguage = aLanguage;
        this.iLocSettings = aLocSettings;
        this.iResources = new Vector();
        this.iResourceInstaller = aResourceInstaller;
        this.addObserver(aListener);
    }

    public void addResources(Vector aResources) {
        this.iResources.addAll(aResources);
    }

    public void install() throws IOException {
        ODTHeader header = LanguageInstaller.createHeader(this.iManifest, this.iLanguage);
        this.iODTDocument.setODTHeader(header);
        Vector langResources = this.iLanguage.getResources();
        Vector odtLangResources = this.iResourceInstaller.installResources(langResources, header);
        odtLangResources.addAll(this.iResources);
        ODTResource langODTResource = this.iResourceInstaller.createODTResource(header, this.iManifest.getNameSpace());
        odtLangResources.add(langODTResource);
        this.iODTDocument.setODTResources(odtLangResources);
        String dataDir = this.iManifest.getDataDir();
        String dtdName = null;
        File dtdFile = null;
        if (this.iLanguage.getDTDFile() != null) {
            dtdName = this.iLanguage.getDTDFile();
        } else if (this.iManifest.getDTDFile() != null) {
            dtdName = this.iManifest.getDTDFile();
        }
        if (this.iLocSettings != null && dtdName != null) {
            LocalisationStore ls = LocalisationStore.getInstance(this.iLocSettings);
            Localisation l = ls.getLocalisation(this.iManifest.getApplicationUid(), this.iManifest.getProviderUid(), this.iManifest.getThemeUid());
            dtdFile = l.composeDTD(dtdName, this.iLanguage.getLanguageId());
        } else if (dtdName != null) {
            dtdFile = new File(String.valueOf(dataDir) + dtdName);
        }
        if (dtdFile != null) {
            this.iConverter.addXML(String.valueOf(dataDir) + this.iManifest.getXMLFile(), dtdFile.getPath());
        } else {
            this.iConverter.addXML(String.valueOf(dataDir) + this.iManifest.getXMLFile());
        }
        if (this.iLanguage.getCSSFile() != null) {
            this.iConverter.addCSS(String.valueOf(dataDir) + this.iLanguage.getCSSFile());
        } else if (this.iManifest.getCSSFile() != null) {
            this.iConverter.addCSS(String.valueOf(dataDir) + this.iManifest.getCSSFile());
        }
        try {
            this.iConverter.parse();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to read resource files");
        }
    }

    public static ODTHeader createHeader(IThemeManifest aManifest, LanguageSpecificData aLanguage) {
        ODTHeader header = new ODTHeader();
        header.put("ApplicationUID", aManifest.getApplicationUid());
        header.put("ProviderUID", aManifest.getProviderUid());
        header.put("ThemeUID", aManifest.getThemeUid());
        header.put("ProviderName", aManifest.getProviderName());
        header.put("ThemeFullName", aManifest.getThemeFullName());
        header.put("ThemeShortName", aManifest.getThemeShortName());
        header.put("ThemeVersion", aManifest.getThemeVersion());
        header.put("ScreenSizeX", aManifest.getScreenSizeX());
        header.put("ScreenSizeY", aManifest.getScreenSizeY());
        header.put("Flags", aManifest.getThemeStatus());
        if (aLanguage != null) {
            header.put("Language", aLanguage.getLanguageId());
            String locFullName = aLanguage.getThemeFullName();
            if (locFullName != null) {
                header.put("ThemeFullName", locFullName);
            }
        }
        return header;
    }

    public void parseOperationCompleted(int aErr, String aReason) {
        this.iODTDocument.setDOMDocument(this.iConverter.getDOMDocument());
        super.setChanged();
        super.notifyObservers(new LanguageInstallEvent(this.iODTDocument, aErr, aReason));
    }
}

