/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.localisation;

import com.nokia.tools.themeinstaller.installationmanager.Lock;
import com.nokia.tools.themeinstaller.localisation.IncludeSetting;
import com.nokia.tools.themeinstaller.localisation.Localisation;
import com.nokia.tools.themeinstaller.localisation.Settings;
import com.nokia.tools.themeinstaller.odtconverter.IParseOperationListener;
import com.nokia.tools.themeinstaller.xmlparser.XMLParser;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LocalisationStore {
    private static final String THEME_ELEMENT = "theme";
    private static final String APP_UID_ATTR = "appuid";
    private static final String PROVIDER_UID_ATTR = "provideruid";
    private static final String THEME_UID_ATTR = "themeuid";
    private static final String MAIN_DTD_ELEMENT = "maindtd";
    private static final String SEARCH_TREE_ELEMENT = "searchtree";
    private static final String DIR_ELEMENT = "dir";
    private static final String DTD_INCLUDE_ELEMENT = "dtdinclude";
    private static final String ENTITY_ELEMENT = "entity";
    private static final String FILE_ATTR = "file";
    private static final String ALL_ATTR = "all";
    private static final String TRUE = "true";
    private static final int RADIX = 16;
    private Vector iLocalisations;
    private Lock iLock = new Lock();
    private Vector iParsedFileNames;
    private static LocalisationStore sInstance = null;

    private LocalisationStore(File aFile) {
        this.iLocalisations = new Vector();
        this.iParsedFileNames = new Vector();
    }

    public static LocalisationStore getInstance(File aFile) {
        if (sInstance == null) {
            sInstance = new LocalisationStore(aFile);
        }
        if (!sInstance.alreadyParsed(aFile)) {
            Document d = sInstance.parseSettings(aFile);
            sInstance.createLocalisations(d);
        }
        return sInstance;
    }

    public Localisation getLocalisation(long aApplicationUid, long aProviderUid, long aThemeUid) {
        Localisation l = this.findLocalisation(aApplicationUid, aProviderUid, aThemeUid);
        if (l == null) {
            throw new IllegalArgumentException("Can't find localisation information with Uid's : ApplicationUid: " + aApplicationUid + ", ProviderUid: " + aProviderUid + ", ThemeUid: " + aThemeUid);
        }
        return l;
    }

    private Localisation findLocalisation(long aApplicationUid, long aProviderUid, long aThemeUid) {
        Enumeration e = this.iLocalisations.elements();
        Localisation l = null;
        while (e.hasMoreElements()) {
            l = (Localisation)e.nextElement();
            Settings s = l.getSettings();
            if (aApplicationUid != s.getAppUid() || aProviderUid != s.getProviderUid() || aThemeUid != s.getThemeUid()) continue;
            return l;
        }
        return null;
    }

    private boolean alreadyParsed(File aSettings) {
        Enumeration e = this.iParsedFileNames.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!s.equals(aSettings.getPath())) continue;
            return true;
        }
        return false;
    }

    private void createLocalisations(Document aDocument) {
        NodeList nodes = aDocument.getElementsByTagName(THEME_ELEMENT);
        int i = 0;
        while (i < nodes.getLength()) {
            Settings settings = new Settings();
            Node theme = nodes.item(i);
            NamedNodeMap list = theme.getAttributes();
            int j = 0;
            while (j < list.getLength()) {
                Node attr = list.item(j);
                if (attr.getNodeType() == 2) {
                    String name = attr.getNodeName();
                    String value = attr.getNodeValue();
                    if (APP_UID_ATTR.equals(name)) {
                        settings.setAppUid(Long.valueOf(value, 16));
                    } else if (PROVIDER_UID_ATTR.equals(name)) {
                        settings.setProviderUid(Long.valueOf(value, 16));
                    } else if (THEME_UID_ATTR.equals(name)) {
                        settings.setThemeUid(Long.valueOf(value, 16));
                    }
                }
                ++j;
            }
            Node element = theme.getFirstChild();
            while (element != null) {
                String elementName = element.getNodeName();
                if (MAIN_DTD_ELEMENT.equals(elementName)) {
                    Node maindtdChild = element.getFirstChild();
                    while (maindtdChild != null) {
                        if (SEARCH_TREE_ELEMENT.equals(maindtdChild.getNodeName())) {
                            settings.addSearchTree(this.parseSearchTree(maindtdChild));
                        }
                        maindtdChild = maindtdChild.getNextSibling();
                    }
                } else if (DTD_INCLUDE_ELEMENT.equals(elementName)) {
                    IncludeSetting incl = new IncludeSetting();
                    NamedNodeMap inclAttr = element.getAttributes();
                    int j2 = 0;
                    while (j2 < inclAttr.getLength()) {
                        Node attr = inclAttr.item(j2);
                        if (attr.getNodeType() == 2) {
                            String name = attr.getNodeName();
                            String value = attr.getNodeValue();
                            if (FILE_ATTR.equals(name)) {
                                incl.setFile(value);
                            } else if (ALL_ATTR.equals(name)) {
                                incl.setIncludeAll(TRUE.equals(value));
                            }
                        }
                        ++j2;
                    }
                    Node inclNode = element.getFirstChild();
                    while (inclNode != null) {
                        if (SEARCH_TREE_ELEMENT.equals(inclNode.getNodeName())) {
                            incl.addSearchTree(this.parseSearchTree(inclNode));
                        } else if (ENTITY_ELEMENT.equals(inclNode.getNodeName())) {
                            incl.addEntity(inclNode.getTextContent());
                        }
                        inclNode = inclNode.getNextSibling();
                    }
                    settings.addInclude(incl);
                }
                element = element.getNextSibling();
            }
            Localisation l = this.findLocalisation(settings.getAppUid(), settings.getProviderUid(), settings.getThemeUid());
            if (l != null) {
                throw new IllegalArgumentException("Localisation Store: Localisation settings already exists for theme: appuid: " + settings.getAppUid() + ", provideruid: " + settings.getProviderUid() + ", themeuid: " + settings.getThemeUid());
            }
            this.iLocalisations.add(new Localisation(settings));
            ++i;
        }
    }

    private Document parseSettings(File aSettings) {
        IParseOperationListener listener = new IParseOperationListener(){

            public void parseOperationCompleted(int aErr, String aReason) {
                LocalisationStore.this.iLock.unLock();
                if (aErr != 0) {
                    throw new IllegalArgumentException("Localisation settings parsing failed: " + aErr + ", " + aReason);
                }
            }
        };
        XMLParser parser = new XMLParser(aSettings.getPath());
        parser.addListener(listener);
        try {
            parser.parse();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Localisation settings parsing failed: " + e.getMessage());
        }
        this.iLock.lock();
        this.iParsedFileNames.add(aSettings.getPath());
        return parser.getDOMDocument();
    }

    private Vector parseSearchTree(Node aParent) {
        Vector<String> result = new Vector<String>();
        Node dir = aParent.getFirstChild();
        while (dir != null) {
            if (DIR_ELEMENT.equals(dir.getNodeName())) {
                result.add(dir.getTextContent());
            }
            dir = dir.getNextSibling();
        }
        return result;
    }
}

