/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.odtconverter;

import com.ibm.icu.text.UnicodeCompressor;
import com.nokia.tools.themeinstaller.odtconverter.ODTException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ODTDataOutputStream
extends DataOutputStream {
    public ODTDataOutputStream(OutputStream aStream) {
        super(aStream);
    }

    public void writeUnsignedInt32(long aValue) throws IOException, ODTException {
        if (aValue < 0L || aValue > 0xFFFFFFFFL) {
            throw new ODTException("ODTDataOutputStream writeUnsignedInt32s failed, value out of range");
        }
        byte[] bArray = new byte[4];
        bArray[3] = (byte)((aValue & 0xFF000000L) >> 24);
        bArray[2] = (byte)((aValue & 0xFF0000L) >> 16);
        bArray[1] = (byte)((aValue & 0xFF00L) >> 8);
        bArray[0] = (byte)(aValue & 0xFFL);
        int len = bArray.length;
        super.write(bArray, 0, len);
    }

    public void writeInt32(int aValue) throws ODTException, IOException {
        byte[] bArray = new byte[4];
        ByteBuffer buf = ByteBuffer.wrap(bArray);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(aValue);
        if (!buf.hasArray()) {
            throw new ODTException("ODTDataOutputStream writeInt32 failed");
        }
        bArray = buf.array();
        int len = bArray.length;
        super.write(bArray, 0, len);
    }

    public void writeInt16(int aValue) throws ODTException, IOException {
        Integer value = new Integer(aValue);
        byte[] bArray = new byte[2];
        ByteBuffer buf = ByteBuffer.wrap(bArray);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putShort(value.shortValue());
        if (!buf.hasArray()) {
            throw new ODTException("ODTDataOutputStream writeInt16 failed");
        }
        bArray = buf.array();
        int len = bArray.length;
        super.write(bArray, 0, len);
    }

    public void writeTReal64(double aValue) throws ODTException, IOException {
        byte[] bArray = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(bArray);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putDouble(aValue);
        if (!buf.hasArray()) {
            throw new ODTException("ODTDataOutputStream writeTReal64 failed");
        }
        bArray = buf.array();
        int len = bArray.length;
        super.write(bArray, 0, len);
    }

    public void writeString8(String aS) throws ODTException, IOException {
        byte[] ba = aS.getBytes();
        int len = ba.length;
        this.writeCardinality(len, true);
        super.write(ba, 0, len);
    }

    public void writeString16(String aS) throws ODTException, IOException {
        int clen = aS.length();
        byte[] ba = UnicodeCompressor.compress(aS);
        int len = ba.length;
        this.writeCardinality(clen, false);
        super.write(ba, 0, len);
    }

    private void writeCardinality(int aLenght, boolean a8bit) throws IOException, ODTException {
        int count = aLenght * 2;
        if (a8bit) {
            ++count;
        }
        if (count <= 127) {
            super.writeByte(count << 1);
        } else if (count <= 16383) {
            this.writeInt16((count << 2) + 1);
        } else {
            this.writeInt32((count << 3) + 3);
        }
    }
}

