/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.xmlparser;

import com.nokia.tools.themeinstaller.logger.LogWriter;
import com.nokia.tools.themeinstaller.odtconverter.ParseOperation;
import com.nokia.tools.themeinstaller.xmlparser.DTDEntityResolver;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class XMLParser
extends ParseOperation
implements Runnable {
    private static final String DBF_KEY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String DBF_VALUE = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
    private static final String PARSER_CONFIG_KEY = "org.apache.xerces.xni.parser.XMLParserConfiguration";
    private static final String PARSER_CONFIG_VALUE = "org.apache.xerces.parsers.XIncludeAwareParserConfiguration";
    private DocumentBuilder iDocumentBuilder;
    private String iFileName;

    static {
        System.setProperty(DBF_KEY, DBF_VALUE);
        System.setProperty(PARSER_CONFIG_KEY, PARSER_CONFIG_VALUE);
    }

    public XMLParser(String aFileName) {
        this(aFileName, null);
    }

    public XMLParser(String aFileName, String aExtDTD) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            if (aExtDTD == null) {
                dbf.setExpandEntityReferences(false);
                dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            dbf.setXIncludeAware(true);
            dbf.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
            dbf.setFeature("http://apache.org/xml/features/xinclude/fixup-language", false);
            this.iDocumentBuilder = dbf.newDocumentBuilder();
            if (aExtDTD != null) {
                this.iDocumentBuilder.setEntityResolver(new DTDEntityResolver(aExtDTD));
            }
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Could not load XML parser: " + e.toString());
        }
        this.iFileName = aFileName;
    }

    public void run() {
        int error = 0;
        String reason = null;
        try {
            LogWriter.getInstance().logInfo(String.valueOf(this.getClass().getSimpleName()) + ": Parsing " + this.iFileName);
            this.iDOMDocument = this.iDocumentBuilder.parse(this.iFileName);
        }
        catch (SAXException e) {
            reason = e.getMessage();
            error = -2;
        }
        catch (IOException e) {
            reason = e.getMessage();
            error = -3;
        }
        super.operationCompleted(error, reason);
    }

    public void parse() {
        Thread thread = new Thread(this);
        thread.start();
    }
}

