/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.defrep.operations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileOperationUtils {
    private static final int READ_BUFFER_SIZE = 1024;
    private static final String REGEXP_PREFIX = "\\";
    private static final char EPOC_DRIVE_SEP = ':';
    private static final String EPOC_PATH_SEP = "\\";
    private static final char EPOC_DRIVE_LETTER_FIRST_U = 'A';
    private static final char EPOC_DRIVE_LETTER_LAST_U = 'Z';
    private static final char EPOC_DRIVE_LETTER_FIRST_L = 'a';
    private static final char EPOC_DRIVE_LETTER_LAST_L = 'z';
    private static final String EPOC32_DIR = "epoc32";

    public static void copyFile(File aSource, File aDestination, boolean aAppend) throws FileNotFoundException, IOException {
        if (aDestination.exists() && !aAppend) {
            aDestination.delete();
        }
        FileOperationUtils.createDirs(aDestination);
        FileInputStream input = new FileInputStream(aSource);
        FileOutputStream output = new FileOutputStream(aDestination, aAppend);
        byte[] buffer = new byte[1024];
        int i = 0;
        try {
            while ((i = input.read(buffer)) != -1) {
                output.write(buffer, 0, i);
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    public static boolean createDirs(File aFile) {
        String parent = aFile.getParent();
        File dir = new File(parent);
        return dir.mkdirs();
    }

    public static String parseSymbianFSPath(File aFile) {
        String result = null;
        String path = aFile.getPath();
        File file = aFile.getParentFile();
        while (file != null) {
            String name = file.getName();
            if (name.length() == 1) {
                char c = name.charAt(0);
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                    result = name;
                }
            } else if (EPOC32_DIR.equalsIgnoreCase(name)) break;
            file = file.getParentFile();
        }
        if (result != null) {
            String pattern = String.valueOf(File.separatorChar) + result + File.separatorChar;
            int pathStart = path.indexOf(pattern) + pattern.length();
            result = String.valueOf(result) + ':' + "\\" + path.substring(pathStart);
            pattern = "\\" + File.separator;
            String replacement = "\\\\";
            result = result.replaceAll(pattern, replacement);
        }
        return result;
    }

    public static String parseSymbianFSPath(String aFile) {
        File f = new File(aFile);
        return FileOperationUtils.parseSymbianFSPath(f);
    }
}

