/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.localisation;

import java.io.File;
import java.io.FileFilter;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileSearch {
    private static Vector iFiles;

    public static Vector findFiles(Vector aRootDirs, String aFileNameExpression, boolean aIncludeSubfolders, boolean aAllowSame) {
        Vector allFiles = new Vector();
        Vector fileFromOneSearch = new Vector();
        int i = 0;
        while (i < aRootDirs.size()) {
            fileFromOneSearch = FileSearch.findFiles((String)aRootDirs.elementAt(i), aFileNameExpression, aIncludeSubfolders, aAllowSame);
            int j = 0;
            while (j < fileFromOneSearch.size()) {
                if (aAllowSame && !allFiles.contains(fileFromOneSearch.get(j))) {
                    allFiles.add(fileFromOneSearch.get(j));
                }
                if (!aAllowSame && !FileSearch.hasSameName(allFiles, (File)fileFromOneSearch.get(j))) {
                    allFiles.add(fileFromOneSearch.get(j));
                }
                ++j;
            }
            ++i;
        }
        return allFiles;
    }

    public static Vector findFiles(Vector aRootDirs, String aFileNameExpression, boolean aIncludeSubfolders) {
        return FileSearch.findFiles(aRootDirs, aFileNameExpression, aIncludeSubfolders, true);
    }

    public static File findFile(Vector aRootDirs, String aFileNameExpression, boolean aIncludeSubfolders) {
        Vector results = FileSearch.findFiles(aRootDirs, aFileNameExpression, aIncludeSubfolders, true);
        if (results.size() == 0) {
            throw new IllegalArgumentException("Localisation: File Search: File not found: " + aFileNameExpression);
        }
        return (File)results.elementAt(0);
    }

    public static Vector findFiles(String aRootDir, String aFileNameExpression, boolean aIncludeSubfolders, boolean aAllowSameName) {
        iFiles = new Vector();
        if (aIncludeSubfolders) {
            FileSearch.findFilesInSubfolder(new File(aRootDir), aFileNameExpression, aAllowSameName);
        }
        if (!aIncludeSubfolders) {
            FileSearch.findFilesInFolder(new File(aRootDir), aFileNameExpression, aAllowSameName);
        }
        return iFiles;
    }

    public static Vector findFiles(String aRootDir, String aFileNameExpression, boolean aIncludeSubfolders) {
        return FileSearch.findFiles(aRootDir, aFileNameExpression, aIncludeSubfolders, true);
    }

    private static void findFilesInFolder(File dir, final String aFileNameExpression, boolean aAllowSameName) {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory() && FileSearch.match(aFileNameExpression, file.getName());
            }
        };
        File[] files = dir.listFiles(fileFilter);
        int i = 0;
        while (i < files.length) {
            if (aAllowSameName) {
                iFiles.add(files[i]);
            }
            if (!aAllowSameName && !FileSearch.hasSameName(iFiles, files[i])) {
                iFiles.add(files[i]);
            }
            ++i;
        }
    }

    private static void findFilesInSubfolder(File dir, String aFileNameExpression, boolean aAllowSameName) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                FileSearch.findFilesInSubfolder(files[i], aFileNameExpression, aAllowSameName);
                ++i;
            }
        } else if (FileSearch.match(aFileNameExpression, dir.getName())) {
            if (aAllowSameName) {
                iFiles.add(dir);
            }
            if (!aAllowSameName && !FileSearch.hasSameName(iFiles, dir)) {
                iFiles.add(dir);
            }
        }
    }

    private static boolean match(String patternStr, CharSequence input) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    private static boolean hasSameName(Vector aFiles, File aFile) {
        int i = 0;
        while (i < aFiles.size()) {
            if (((File)aFiles.get(i)).getName().equals(aFile.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

