/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.localisation;

import com.nokia.tools.themeinstaller.odtconverter.ConverterProperties;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Set;

public class DTDComposer {
    private static final String FORMAT = "<!ENTITY %s \"%s\">";
    private static final String CARRIAGE_RETURN = System.getProperty("line.separator");
    private static final String ENCODING_KEY = "dtd_encoding";

    public static String formatEntity(String aEntity, String aLocString) {
        Object[] formatArguments = new String[]{aEntity, aLocString};
        return String.format(FORMAT, formatArguments);
    }

    public static File writeEntitiesToDtd(File aDestination, Hashtable aEntities, boolean aAppend) throws IOException {
        String encoding = ConverterProperties.getInstance().getProperty(ENCODING_KEY);
        BufferedWriter out = null;
        out = encoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(aDestination, aAppend), encoding)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(aDestination, aAppend)));
        try {
            Set entries = aEntities.keySet();
            for (String entity : entries) {
                String locString = (String)aEntities.get(entity);
                out.write(String.valueOf(DTDComposer.formatEntity(entity, locString)) + CARRIAGE_RETURN);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return aDestination;
    }
}

