/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.cssparser;

import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.Selector;

public class CSSSelectorParser {
    public static boolean isPseudo(Selector aSelector) {
        switch (aSelector.getSelectorType()) {
            case 4: {
                return false;
            }
            case 0: {
                ConditionalSelector cSelector = (ConditionalSelector)aSelector;
                return CSSSelectorParser.isPseudoCondition(cSelector.getCondition());
            }
            case 11: {
                DescendantSelector dSelector = (DescendantSelector)aSelector;
                return CSSSelectorParser.isPseudo((Selector)dSelector.getSimpleSelector());
            }
            case 10: {
                DescendantSelector dSelector = (DescendantSelector)aSelector;
                return CSSSelectorParser.isPseudo((Selector)dSelector.getSimpleSelector());
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                throw new CSSException("Selector : " + aSelector.getSelectorType() + " not supported");
            }
        }
        throw new CSSException("Unknown selector : " + aSelector.getSelectorType());
    }

    private static boolean isPseudoCondition(Condition aCondition) {
        switch (aCondition.getConditionType()) {
            case 5: {
                return false;
            }
            case 9: {
                return false;
            }
            case 0: {
                CombinatorCondition combCondition = (CombinatorCondition)aCondition;
                return CSSSelectorParser.isPseudoCondition(combCondition.getFirstCondition()) || CSSSelectorParser.isPseudoCondition(combCondition.getSecondCondition());
            }
            case 10: {
                return true;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                throw new CSSException("condition : " + aCondition.getConditionType() + " not supported");
            }
        }
        throw new CSSException("Unknown condition : " + aCondition.getConditionType());
    }
}

