/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.odtconverter;

import com.nokia.tools.themeinstaller.odtconverter.DOMExternalizer;
import com.nokia.tools.themeinstaller.odtconverter.ODTDataOutputStream;
import com.nokia.tools.themeinstaller.odtconverter.ODTDocument;
import com.nokia.tools.themeinstaller.odtconverter.ODTException;
import com.nokia.tools.themeinstaller.odtconverter.ODTResource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public class ODTInputStream
extends InputStream {
    ODTDocument iODTDocument;
    ByteArrayOutputStream iBaos;
    ODTDataOutputStream iODTDos;
    byte[] iByteArray = null;
    int iIndex = 0;
    private static final char DELIM = '#';
    private static final int WRITE_ONCE_FILE_STORE_UID = 268435511;
    private static final int UNKNOWN_MEDIA_UID = 73066445;

    public ODTInputStream(ODTDocument aODTDocument) throws ODTException {
        this.iODTDocument = aODTDocument;
        this.iBaos = new ByteArrayOutputStream();
        this.iODTDos = new ODTDataOutputStream(this.iBaos);
        this.getBinaryRepresentations();
    }

    private void getBinaryRepresentations() throws ODTException {
        try {
            this.iODTDos.writeInt32(268435511);
            this.iODTDos.writeInt(0);
            this.iODTDos.writeInt(0);
            this.iODTDos.writeInt32(73066445);
            this.iODTDos.writeInt32(20);
            this.iBaos.write(this.iODTDocument.getODTHeader().getBinaryODTHeader());
            this.iODTDos.writeInt16(35);
            int resCount = this.iODTDocument.getODTResources().size();
            this.iODTDos.writeInt32(resCount);
            Enumeration resources = this.iODTDocument.getODTResources().elements();
            while (resources.hasMoreElements()) {
                ODTResource odtResource = (ODTResource)resources.nextElement();
                this.iBaos.write(odtResource.getBinaryODTResource());
            }
            DOMExternalizer domExt = new DOMExternalizer(this.iODTDocument.getDOMDocument());
            this.iBaos.write(domExt.getByteArray());
        }
        catch (IOException e) {
            throw new ODTException(e.getMessage());
        }
    }

    public void close() throws IOException {
        this.iODTDos.close();
        this.iBaos.close();
    }

    public int read() throws IOException {
        byte b;
        if (this.iByteArray == null) {
            this.iByteArray = this.iBaos.toByteArray();
        }
        if (this.iIndex >= this.iByteArray.length) {
            this.iByteArray = null;
            return -1;
        }
        if ((b = this.iByteArray[this.iIndex++]) == -1) {
            return 255;
        }
        return b;
    }
}

