/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.cssparser;

import com.nokia.tools.themeinstaller.cssparser.CSSDOMProcessor;
import com.nokia.tools.themeinstaller.cssparser.CSSPropertyValue;
import com.nokia.tools.themeinstaller.cssparser.CSSRule;
import com.nokia.tools.themeinstaller.cssparser.CSSStyleProperty;
import com.nokia.tools.themeinstaller.cssparser.ColorResolver;
import com.nokia.tools.themeinstaller.logger.LogWriter;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Vector;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.helpers.ParserFactory;
import org.w3c.dom.Document;

public class CSSHandler
implements DocumentHandler {
    private HashMap iStyleMap;
    private Vector iRuleList;
    private Document iDocument;
    private ColorResolver iColorResolver;
    private String iImportDirectory;
    public static final String FUNCTION_HSL = "hsl";
    public static final String COMMA = ",";
    private static final char CHAR_APOSTROPHE = '\"';
    private static final char CHAR_SPACE = ' ';
    private static final char CHAR_COLON = ':';
    public static final String SEPARATOR = "|";
    public static final String FORWARD_SLASH = "/";
    public static final String BACKWARD_SLASH = "\\";
    private CSSDOMProcessor iCSSDOMProcessor = new CSSDOMProcessor();

    public CSSHandler() {
        this.iStyleMap = new HashMap();
        this.iRuleList = new Vector();
        this.iColorResolver = new ColorResolver();
    }

    private CSSHandler(CSSHandler aHandler) {
        this.iStyleMap = new HashMap();
        this.iRuleList = aHandler.iRuleList;
        this.iDocument = aHandler.iDocument;
        this.iColorResolver = new ColorResolver();
    }

    public void setDocument(Document aDocument) {
        this.iDocument = aDocument;
    }

    public Document getDocument() {
        return this.iDocument;
    }

    public void setImportDirectory(String aImportDirectory) {
        this.iImportDirectory = aImportDirectory;
    }

    public void startDocument(InputSource arg0) throws CSSException {
        this.iRuleList = new Vector();
    }

    public void startSelector(SelectorList aSelectorList) throws CSSException {
        this.iStyleMap = new HashMap();
    }

    public void endSelector(SelectorList aSelectors) throws CSSException {
        if (this.iStyleMap.size() != 0) {
            int i = 0;
            while (i < aSelectors.getLength()) {
                CSSRule rule = new CSSRule(aSelectors.item(i), this.iStyleMap);
                this.iRuleList.add(rule);
                ++i;
            }
        }
    }

    public void property(String aName, LexicalUnit aLexicalUnit, boolean aImportant) throws CSSException {
        Vector propertyValues = new Vector();
        this.lexicalValue(aLexicalUnit, propertyValues);
        this.iStyleMap.put(aName, new CSSStyleProperty(propertyValues, aImportant));
    }

    public void endDocument(InputSource aInputSource) throws CSSException {
        if (this.iDocument == null) {
            throw new IllegalStateException("CSSHandler has null DOM Document");
        }
        this.iCSSDOMProcessor.applyRulesToDom(this.iDocument, this.iRuleList);
    }

    public void lexicalValue(LexicalUnit aLexicalUnit, Vector aPropertyValues) {
        while (aLexicalUnit != null) {
            switch (aLexicalUnit.getLexicalUnitType()) {
                case 0: {
                    break;
                }
                case 13: {
                    aPropertyValues.add(new CSSPropertyValue(13, Integer.toString(aLexicalUnit.getIntegerValue())));
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 42: {
                    aPropertyValues.add(new CSSPropertyValue(aLexicalUnit.getLexicalUnitType(), Float.toString(aLexicalUnit.getFloatValue())));
                    break;
                }
                case 27: {
                    StringBuffer sb = new StringBuffer();
                    this.colorValue(aLexicalUnit.getParameters(), sb);
                    aPropertyValues.add(new CSSPropertyValue(aLexicalUnit.getLexicalUnitType(), sb.toString()));
                    break;
                }
                case 24: 
                case 35: 
                case 36: 
                case 37: {
                    if (this.iColorResolver.get(aLexicalUnit.getStringValue()) != null) {
                        Color color = (Color)this.iColorResolver.get(aLexicalUnit.getStringValue());
                        aPropertyValues.add(new CSSPropertyValue(27, "13|" + color.getRed() + COMMA + 13 + SEPARATOR + color.getGreen() + COMMA + 13 + SEPARATOR + color.getBlue()));
                        break;
                    }
                    if (aLexicalUnit.getStringValue().indexOf(32) != -1) {
                        aPropertyValues.add(new CSSPropertyValue(aLexicalUnit.getLexicalUnitType(), String.valueOf('\"') + aLexicalUnit.getStringValue() + '\"'));
                        break;
                    }
                    aPropertyValues.add(new CSSPropertyValue(aLexicalUnit.getLexicalUnitType(), aLexicalUnit.getStringValue()));
                    break;
                }
                case 12: {
                    aPropertyValues.add(new CSSPropertyValue(35, "inherit"));
                    break;
                }
                case 41: {
                    String functionName = aLexicalUnit.getFunctionName();
                    if (functionName.equals(FUNCTION_HSL)) {
                        Color color = this.colorFromHsl(aLexicalUnit.getParameters());
                        aPropertyValues.add(new CSSPropertyValue(27, "13|" + color.getRed() + COMMA + 13 + SEPARATOR + color.getGreen() + COMMA + 13 + SEPARATOR + color.getBlue()));
                        break;
                    }
                    throw new IllegalStateException("Unknown CSS Function : " + functionName);
                }
            }
            aLexicalUnit = aLexicalUnit.getNextLexicalUnit();
        }
    }

    private Color colorFromHsl(LexicalUnit aLexicalUnit) {
        float h = 0.0f;
        float s = 0.0f;
        float l = 0.0f;
        try {
            h = aLexicalUnit.getIntegerValue();
            aLexicalUnit = aLexicalUnit.getNextLexicalUnit().getNextLexicalUnit();
            s = aLexicalUnit.getFloatValue();
            aLexicalUnit = aLexicalUnit.getNextLexicalUnit().getNextLexicalUnit();
            l = aLexicalUnit.getFloatValue();
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Illegal HSL Color values");
        }
        if (aLexicalUnit.getNextLexicalUnit() != null) {
            throw new IllegalStateException("Too many parameters in HSL color");
        }
        return this.iColorResolver.hslToRgb(h, s, l);
    }

    public void colorValue(LexicalUnit aLexicalUnit, StringBuffer aProperty) {
        while (aLexicalUnit != null) {
            switch (aLexicalUnit.getLexicalUnitType()) {
                case 0: {
                    aProperty.append(COMMA);
                    break;
                }
                case 13: {
                    aProperty.append(aLexicalUnit.getLexicalUnitType());
                    aProperty.append(SEPARATOR);
                    aProperty.append(aLexicalUnit.getIntegerValue());
                    break;
                }
                case 23: {
                    aProperty.append(13);
                    aProperty.append(SEPARATOR);
                    aProperty.append(this.iColorResolver.getColorValueFromPercentage(aLexicalUnit.getFloatValue()));
                    break;
                }
            }
            aLexicalUnit = aLexicalUnit.getNextLexicalUnit();
        }
    }

    public void startFontFace() throws CSSException {
    }

    public void startPage(String arg0, String arg1) throws CSSException {
    }

    public void endFontFace() throws CSSException {
    }

    public void endPage(String arg0, String arg1) throws CSSException {
    }

    public void comment(String arg0) throws CSSException {
    }

    public void endMedia(SACMediaList arg0) throws CSSException {
    }

    public void ignorableAtRule(String arg0) throws CSSException {
    }

    public void importStyle(String aCSSFileName, SACMediaList aMedia, String aNameSpaceUri) throws CSSException {
        try {
            CSSHandler handler = new CSSHandler(this);
            ParserFactory factory = new ParserFactory();
            Parser parser = factory.makeParser();
            parser.setDocumentHandler((DocumentHandler)handler);
            FileReader r = null;
            File cssImport = new File(aCSSFileName);
            if (this.isAbsolutePath(aCSSFileName) && cssImport.exists()) {
                r = new FileReader(aCSSFileName);
                LogWriter.getInstance().logInfo("Imported CSS : " + cssImport.getAbsolutePath());
            } else if (!this.isAbsolutePath(aCSSFileName) && this.iImportDirectory != null) {
                File relativeCSS = new File(String.valueOf(this.iImportDirectory) + File.separator + aCSSFileName);
                r = new FileReader(relativeCSS);
                LogWriter.getInstance().logInfo("Imported CSS : " + relativeCSS.getAbsolutePath());
            } else {
                throw new IllegalStateException("Can't resolve imported CSS File: " + aCSSFileName);
            }
            InputSource is = new InputSource((Reader)r);
            parser.parseStyleSheet(is);
        }
        catch (Exception e) {
            throw new CSSException(e.getMessage());
        }
    }

    private boolean isAbsolutePath(String aFilePath) {
        if (aFilePath.startsWith(FORWARD_SLASH)) {
            return true;
        }
        if (aFilePath.startsWith(BACKWARD_SLASH)) {
            return true;
        }
        return aFilePath.length() > 1 && aFilePath.charAt(1) == ':';
    }

    public void namespaceDeclaration(String arg0, String arg1) throws CSSException {
    }

    public void startMedia(SACMediaList arg0) throws CSSException {
    }
}

