/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.tools.security.midp;

import com.nokia.mj.impl.security.midp.authorization.SecurityPolicy;
import com.nokia.mj.impl.security.midp.authorization.SecurityPolicyPermission;
import com.nokia.mj.impl.security.midp.authorization.SecurityPolicyPermissionSettings;
import com.nokia.mj.impl.security.midp.common.MIDPPermission;
import com.nokia.mj.impl.security.midp.common.PermissionMappingTable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Vector;

public final class PolicyEditor {
    private int offset = 0;
    private byte[] policy;
    private SecurityPolicy securityPolicy;
    private static String destPath;
    private static final String POLICY_FILE_EXTENSION = ".txt";

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Usage: SecurityPolicyEditor <sourcePath> <destPath>\n       where <sourcePath> = Path to the directory from where policies in the external format will be read\n             <destPath> = Path to the directory where the policies in the internal format will be stored");
            System.exit(1);
        }
        destPath = stringArray[1];
        File[] fileArray = new File(stringArray[0]).listFiles();
        if (fileArray == null || fileArray.length == 0) {
            System.out.println("No files under " + stringArray[0] + ". Security system can not operate without security policy files");
            System.exit(1);
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isFile() || !fileArray[i].getName().toLowerCase().endsWith(POLICY_FILE_EXTENSION)) continue;
            PolicyEditor policyEditor = new PolicyEditor();
            policyEditor.edit(fileArray[i].getAbsolutePath());
        }
    }

    private void edit(String string) {
        try {
            this.policy = this.read(string);
            this.parse();
            this.serialize(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] read(String string) throws IOException {
        FileInputStream fileInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[2048];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
    }

    private void parse() {
        SecurityPolicyPermissionSettings securityPolicyPermissionSettings;
        String string = null;
        this.find("domain", true);
        if (this.offset >= this.policy.length) {
            throw new IllegalArgumentException("Invalid security policy - missing domain information");
        }
        string = this.extractToken(';');
        Vector<SecurityPolicyPermission> vector = new Vector<SecurityPolicyPermission>();
        this.find("grant");
        while (this.offset < this.policy.length) {
            Object[] objectArray;
            Object object;
            String string2;
            String string3;
            securityPolicyPermissionSettings = null;
            int n = this.getType(this.extractToken());
            if (n == 1) {
                string3 = this.extractToken('\"', '\"');
                this.check(string3, "User grant group without name");
                if (string3.startsWith("\"")) {
                    string3 = string3.substring(1);
                }
                if (string3.endsWith("\"")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                string2 = this.extractToken('{');
                this.check(string2, "User grant group without interaction modes");
                object = this.split(string2, ",");
                if (object == null || ((String[])object).length == 0) {
                    throw new IllegalArgumentException("Missing interaction modes for an user grant group");
                }
                int n2 = this.getInteractionMode(object[0]);
                objectArray = this.getInteractionModes((String[])object);
                securityPolicyPermissionSettings = new SecurityPolicyPermissionSettings(string3, n2, (int[])objectArray);
            }
            this.find("permission");
            while (this.offset < this.policy.length && this.policy[this.offset] != 125) {
                MIDPPermission mIDPPermission;
                string3 = this.extractToken(';');
                string2 = null;
                object = null;
                if (this.policy[this.offset] != 59) {
                    string2 = this.extractToken(';');
                    if (string2 != null && string2.length() > 2) {
                        if (string2.charAt(0) == '\"') {
                            string2 = string2.substring(1);
                        }
                        if (string2.charAt(string2.length() - 1) == '\"') {
                            string2 = string2.substring(0, string2.length() - 1);
                        }
                    }
                    if (this.policy[this.offset] != 59 && (object = this.extractToken(';')) != null && ((String)object).length() > 2) {
                        if (((String)object).charAt(0) == '\"') {
                            object = ((String)object).substring(1);
                        }
                        if (((String)object).charAt(((String)object).length() - 1) == '\"') {
                            object = ((String)object).substring(0, ((String)object).length() - 1);
                        }
                    }
                }
                if ((mIDPPermission = PermissionMappingTable.get((String)string3)) != null) {
                    string3 = mIDPPermission.getName();
                }
                if ((objectArray = this.split((String)object, ",")) != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        vector.add(this.getPermission(string3, string2, objectArray[i], n, securityPolicyPermissionSettings));
                    }
                } else {
                    vector.add(this.getPermission(string3, string2, (String)object, n, securityPolicyPermissionSettings));
                }
                this.find("permission");
            }
            this.find("grant", true);
        }
        if (vector.size() == 0) {
            throw new IllegalArgumentException("Invalid security policy - missing/invalid permissions information");
        }
        securityPolicyPermissionSettings = new SecurityPolicyPermission[vector.size()];
        vector.copyInto((Object[])securityPolicyPermissionSettings);
        this.securityPolicy = new SecurityPolicy(string, (SecurityPolicyPermission[])securityPolicyPermissionSettings);
    }

    private void serialize(String string) throws IOException {
        int n = (string = new File(string).getName()).indexOf(".");
        if (n == -1) {
            n = string.length();
        }
        string = string.substring(0, n);
        FileOutputStream fileOutputStream = new FileOutputStream(destPath + File.separator + string + ".ser");
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(this.securityPolicy);
        objectOutputStream.close();
    }

    private void find(String string, boolean bl) {
        byte[] byArray = string.getBytes();
        while (this.offset < this.policy.length && (bl || this.policy[this.offset] != 125)) {
            if (this.policy[this.offset] == byArray[0]) {
                int n;
                ++this.offset;
                for (n = 1; n < byArray.length && this.policy[this.offset] == byArray[n]; ++n) {
                    ++this.offset;
                }
                if (n == byArray.length) break;
            }
            ++this.offset;
        }
    }

    private String extractToken(char c, char c2, char c3) {
        String string = "";
        while (c != ' ' && this.offset < this.policy.length && this.policy[this.offset] == 32) {
            ++this.offset;
        }
        while (this.offset < this.policy.length && this.policy[this.offset] == c) {
            ++this.offset;
        }
        while (this.offset < this.policy.length && this.policy[this.offset] != c2 && this.policy[this.offset] != 10 && this.policy[this.offset] != 13 && (c3 == '\uffff' || this.policy[this.offset] != c3)) {
            string = string + (char)this.policy[this.offset];
            ++this.offset;
        }
        if (string.length() == 0) {
            return null;
        }
        if (c2 != ' ') {
            ++this.offset;
        }
        return string;
    }

    private int getInteractionMode(String string) {
        if (string.equalsIgnoreCase("oneshot")) {
            return 1;
        }
        if (string.equalsIgnoreCase("session")) {
            return 2;
        }
        if (string.equalsIgnoreCase("blanket")) {
            return 3;
        }
        if (string.equalsIgnoreCase("no")) {
            return 4;
        }
        throw new IllegalArgumentException("Invalid interaction mode " + string);
    }

    private int[] getInteractionModes(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = this.getInteractionMode(stringArray[i]);
        }
        return nArray;
    }

    private int getType(String string) {
        if (string.equalsIgnoreCase("user")) {
            return 1;
        }
        if (string.equalsIgnoreCase("allowed")) {
            return 2;
        }
        if (string.equalsIgnoreCase("assigned")) {
            return 3;
        }
        throw new IllegalArgumentException("Invalid grant group type " + string);
    }

    private void find(String string) {
        this.find(string, false);
    }

    private String extractToken() {
        return this.extractToken(' ', ' ', '\uffff');
    }

    private String extractToken(char c) {
        return this.extractToken(' ', ' ', c);
    }

    private String extractToken(char c, char c2) {
        return this.extractToken(c, c2, '\uffff');
    }

    private void check(String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(string2);
        }
    }

    private String[] split(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            return new String[]{string};
        }
        Vector<String> vector = new Vector<String>();
        int n = string.indexOf(string2);
        while (n != -1) {
            vector.addElement(string.substring(0, n));
            string = string.substring(n + string2.length());
            n = string.indexOf(string2);
        }
        vector.addElement(string);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private SecurityPolicyPermission getPermission(String string, String string2, String string3, int n, SecurityPolicyPermissionSettings securityPolicyPermissionSettings) {
        if (securityPolicyPermissionSettings == null) {
            return new SecurityPolicyPermission(string, string2, string3, n);
        }
        return new SecurityPolicyPermission(string, string2, string3, securityPolicyPermissionSettings);
    }
}

