package hellotouch;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.midlet.MIDlet;

public class HelloTouch extends MIDlet
    implements CommandListener
{
    private static final String MY_NAME = "HelloTouch";

    private Form form;
    private Command exitCommand;

    public HelloTouch()
    {
        try
        {
            form = new Form("HelloTouch");
            exitCommand = new Command("Exit", 7, 1);
            form.addCommand(exitCommand);
            form.append("Hello Touch!");
            form.setCommandListener(this);
        }
        catch(Throwable t)
        {
            t.printStackTrace();
            form.append("Exception: " + t);
        }
    }

    public void startApp()
    {
        Display.getDisplay(this).setCurrent(form);
    }

    public void destroyApp(boolean flag)
    {
    }

    public void pauseApp()
    {
    }

    public void commandAction(Command cmd, Displayable displayable)
    {
        if(cmd == exitCommand)
        {
            destroyApp(false);
            notifyDestroyed();
        }
    }

    public void pointerDragged(int x, int y)
    {
        System.out.println(MY_NAME + " pointerDragged: x=" + x + ", y=" + y);
    }

    public void pointerPressed(int x, int y)
    {
        System.out.println(MY_NAME + " pointerPressed: x=" + x + ", y=" + y);
    }

    public void pointerReleased(int x, int y)
    {
        System.out.println(MY_NAME + " pointerReleased: x=" + x + ", y=" + y);
    }

    public void otherMethod(int x, int y)
    {
        System.out.println(MY_NAME + " otherMethod: x=" + x + ", y=" + y);
    }
}
