/*
* Copyright (c) 2001-2006 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  EAP and WLAN authentication protocols.
*
*/

/*
* %version: 7 %
*/

#if !defined(_EAP_AM_DH_PRIMES_H_)
#define _EAP_AM_DH_PRIMES_H_

//--------------------------------------------------

const u32_t OAKLEY_DEFAULT_GROUP_1_PRIME_LENGTH	= 96;	/* bytes */

const u8_t OAKLEY_DEFAULT_GROUP_1_PRIME[OAKLEY_DEFAULT_GROUP_1_PRIME_LENGTH] =
{
	 0xFF,0xFF,0xFF,0xFF ,0xFF,0xFF,0xFF,0xFF
	,0xC9,0x0F,0xDA,0xA2 ,0x21,0x68,0xC2,0x34
	,0xC4,0xC6,0x62,0x8B ,0x80,0xDC,0x1C,0xD1
	,0x29,0x02,0x4E,0x08 ,0x8A,0x67,0xCC,0x74
	,0x02,0x0B,0xBE,0xA6 ,0x3B,0x13,0x9B,0x22
	,0x51,0x4A,0x08,0x79 ,0x8E,0x34,0x04,0xDD
	,0xEF,0x95,0x19,0xB3 ,0xCD,0x3A,0x43,0x1B
	,0x30,0x2B,0x0A,0x6D ,0xF2,0x5F,0x14,0x37
	,0x4F,0xE1,0x35,0x6D ,0x6D,0x51,0xC2,0x45
	,0xE4,0x85,0xB5,0x76 ,0x62,0x5E,0x7E,0xC6
	,0xF4,0x4C,0x42,0xE9 ,0xA6,0x3A,0x36,0x20
	,0xFF,0xFF,0xFF,0xFF ,0xFF,0xFF,0xFF,0xFF
};

const u32_t OAKLEY_DEFAULT_GROUP_GENERATOR_LENGTH = 1;	/* bytes */

const u8_t OAKLEY_DEFAULT_GROUP_GENERATOR[OAKLEY_DEFAULT_GROUP_GENERATOR_LENGTH] =
{
	0x02
};


const u32_t OAKLEY_DEFAULT_GROUP_2_PRIME_LENGTH	= 128;	/* bytes */

const u8_t OAKLEY_DEFAULT_GROUP_2_PRIME[OAKLEY_DEFAULT_GROUP_2_PRIME_LENGTH] =
{
	 0xFF,0xFF,0xFF,0xFF ,0xFF,0xFF,0xFF,0xFF
	,0xC9,0x0F,0xDA,0xA2 ,0x21,0x68,0xC2,0x34
	,0xC4,0xC6,0x62,0x8B ,0x80,0xDC,0x1C,0xD1
	,0x29,0x02,0x4E,0x08 ,0x8A,0x67,0xCC,0x74
	,0x02,0x0B,0xBE,0xA6 ,0x3B,0x13,0x9B,0x22
	,0x51,0x4A,0x08,0x79 ,0x8E,0x34,0x04,0xDD
	,0xEF,0x95,0x19,0xB3 ,0xCD,0x3A,0x43,0x1B
	,0x30,0x2B,0x0A,0x6D ,0xF2,0x5F,0x14,0x37
	,0x4F,0xE1,0x35,0x6D ,0x6D,0x51,0xC2,0x45
	,0xE4,0x85,0xB5,0x76 ,0x62,0x5E,0x7E,0xC6
	,0xF4,0x4C,0x42,0xE9 ,0xA6,0x37,0xED,0x6B
	,0x0B,0xFF,0x5C,0xB6 ,0xF4,0x06,0xB7,0xED
	,0xEE,0x38,0x6B,0xFB ,0x5A,0x89,0x9F,0xA5
	,0xAE,0x9F,0x24,0x11 ,0x7C,0x4B,0x1F,0xE6
	,0x49,0x28,0x66,0x51 ,0xEC,0xE6,0x53,0x81
	,0xFF,0xFF,0xFF,0xFF ,0xFF,0xFF,0xFF,0xFF
};


const u32_t OAKLEY_DEFAULT_GROUP_5_PRIME_LENGTH	= 192;	/* bytes */

const u8_t OAKLEY_DEFAULT_GROUP_5_PRIME[OAKLEY_DEFAULT_GROUP_5_PRIME_LENGTH] =
{
	 0xFF,0xFF,0xFF,0xFF ,0xFF,0xFF,0xFF,0xFF 
	,0xC9,0x0F,0xDA,0xA2 ,0x21,0x68,0xC2,0x34 
	,0xC4,0xC6,0x62,0x8B ,0x80,0xDC,0x1C,0xD1
	,0x29,0x02,0x4E,0x08 ,0x8A,0x67,0xCC,0x74 
	,0x02,0x0B,0xBE,0xA6 ,0x3B,0x13,0x9B,0x22 
	,0x51,0x4A,0x08,0x79 ,0x8E,0x34,0x04,0xDD
	,0xEF,0x95,0x19,0xB3 ,0xCD,0x3A,0x43,0x1B 
	,0x30,0x2B,0x0A,0x6D ,0xF2,0x5F,0x14,0x37 
	,0x4F,0xE1,0x35,0x6D ,0x6D,0x51,0xC2,0x45
	,0xE4,0x85,0xB5,0x76 ,0x62,0x5E,0x7E,0xC6 
	,0xF4,0x4C,0x42,0xE9 ,0xA6,0x37,0xED,0x6B 
	,0x0B,0xFF,0x5C,0xB6 ,0xF4,0x06,0xB7,0xED
	,0xEE,0x38,0x6B,0xFB ,0x5A,0x89,0x9F,0xA5 
	,0xAE,0x9F,0x24,0x11 ,0x7C,0x4B,0x1F,0xE6 
	,0x49,0x28,0x66,0x51 ,0xEC,0xE4,0x5B,0x3D
	,0xC2,0x00,0x7C,0xB8 ,0xA1,0x63,0xBF,0x05 
	,0x98,0xDA,0x48,0x36 ,0x1C,0x55,0xD3,0x9A 
	,0x69,0x16,0x3F,0xA8 ,0xFD,0x24,0xCF,0x5F
	,0x83,0x65,0x5D,0x23 ,0xDC,0xA3,0xAD,0x96 
	,0x1C,0x62,0xF3,0x56 ,0x20,0x85,0x52,0xBB 
	,0x9E,0xD5,0x29,0x07 ,0x70,0x96,0x96,0x6D
	,0x67,0x0C,0x35,0x4E ,0x4A,0xBC,0x98,0x04 
	,0xF1,0x74,0x6C,0x08 ,0xCA,0x23,0x73,0x27 
	,0xFF,0xFF,0xFF,0xFF ,0xFF,0xFF,0xFF,0xFF
};

const u32_t OAKLEY_DEFAULT_DH_EXPONENT_SIZE = 20;	/* bytes (= 160 bits) */

const u32_t OAKLEY_DEFAULT_NONCE_SIZE = (128 / 8);	/* 128 bits */

//--------------------------------------------------

#if 0
	#define SAE_GROUP_PRIME            OAKLEY_DEFAULT_GROUP_5_PRIME
	#define SAE_GROUP_PRIME_LENGTH     OAKLEY_DEFAULT_GROUP_5_PRIME_LENGTH
	#define SAE_GROUP_GENERATOR        OAKLEY_DEFAULT_GROUP_GENERATOR
	#define SAE_GROUP_GENERATOR_LENGTH OAKLEY_DEFAULT_GROUP_GENERATOR_LENGTH
#else
	#define SAE_GROUP_PRIME            OAKLEY_DEFAULT_GROUP_2_PRIME
	#define SAE_GROUP_PRIME_LENGTH     OAKLEY_DEFAULT_GROUP_2_PRIME_LENGTH
	#define SAE_GROUP_GENERATOR        OAKLEY_DEFAULT_GROUP_GENERATOR
	#define SAE_GROUP_GENERATOR_LENGTH OAKLEY_DEFAULT_GROUP_GENERATOR_LENGTH
#endif

//--------------------------------------------------

#endif //#if !defined(_EAP_AM_DH_PRIMES_H_)




// End.
