/*
* Copyright (c) 2006-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


/**
 @file 
 @internalComponent 
*/

#ifndef __SISFILEDATA_H__
#define __SISFILEDATA_H__
#pragma warning(disable: 4786)

#include "options.h"
#include "launchprocess.h"
#include <sstream>

const std::string KEciFile = "executablecapabilities.eci";

/**
 * SISFileData Class reads the execapabilities.eci file(containing information of the executable
 * and their corressponding capabilities).
 * @internalComponent 
 */
class SISFileData
{

public:

	struct ExeLabelAndCapabilitiesList
		{
		ExeLabelAndCapabilitiesList* iNext;
		std::string iExeLabel;
		int iExeCapability;
		};

public:

	SISFileData();

	~SISFileData();

	/**
	  Extracts executable and capabilities information from the given eci file 
	  generated by dumpsis.
	  @param	aECIFile	execapabilities.eci file
	 */
	int EciFileRead(const char* aEciFile ,const Options& aOptions);

	const ExeLabelAndCapabilitiesList* ExeNameAndCapabilityList() const  { return iExeLabelAndCapabilities ; }

private:

	std::string iExeName;
	ExeLabelAndCapabilitiesList* iExeLabelAndCapabilities;
};

#endif	
	
