#
# Copyright (c) 2009-2010 Nokia Corporation and/or its subsidiary(-ies).
# All rights reserved.
# This component and the accompanying materials are made available
# under the terms of the License "Eclipse Public License v1.0"
# which accompanies this distribution, and is available
# at the URL "http://www.eclipse.org/legal/epl-v10.html".
#
# Initial Contributors:
# Nokia Corporation - initial contribution.
#
# Contributors:
#
# Description: 
#


use Cwd;
use File::Copy;
use File::Basename;

# Helpers
sub ReadFile($);
sub WriteFile($$);
sub EditFile($$$);

print "This script creates SIS files containing LEEs for SIF integration tests\n";

my $PLATFORM=@ARGV[0];
my $CONFIGURATION=@ARGV[1];

my $securitySourceDir = $ENV{SECURITYSOURCEDIR};
my $CERTPATH = "$securitySourceDir\\installationservices\\switestfw\\testcertificates\\swi\\test\\tsisfile\\data\\signedsis\\Root5CA\\cert_chain_dsa_len1\\first.dsa.cer";
my $KEYPATH = "$securitySourceDir\\installationservices\\swi\\test\\tsisfile\\data\\signedsis\\Root5CA\\cert_chain_dsa_len1\\dsa1.key";
my $PKGDIR = "$securitySourceDir\\installationservices\\swinstallationfw\\test\\tusif\\scripts\\data";
my $BUILDDIR = "\\epoc32\\release\\$PLATFORM\\$CONFIGURATION";
my $DATADIR = "$BUILDDIR\\z\\tusif\\tswtype\\data";
my $DATADIR_TSIF = "$BUILDDIR\\z\\tusif\\tsif\\data";
my $ARMV5DATADIR = "\\epoc32\\data\\z\\tusif\\tswtype\\data";
my $ARMV5DATADIR_TSIF = "\\epoc32\\data\\z\\tusif\\tsif\\data";

my $BASE = 'sifswtypebase';
my $UPGRADE = 'sifswtypeupgrade';
my $SIFGETCOMAPPARCINFOTEST = 'sifgetcompapparcinfotest';
my $SIFGETCOMAPPARCINFOTESTMULTILANG = 'sifgetcompapparcinfotestmultilang';
my $SIFGETCOMAPPARCINFOTESTMULTIFILES = 'sifgetcompapparcinfotestmultifiles';
my $SIFGETCOMAPPARCINFOTESTNONAPPARCRSC = 'sifgetcompapparcinfotestnonapparcrsc';
my $SIFGETCOMAPPARCINFOTESTNONAPPARCPATH = 'sifgetcompapparcinfotestnonapparcpath';
my $SIFGETCOMAPPARCINFOTESTMULTIAPP = 'sifgetcompapparcinfotestmultiapp';
my $SIFGETCOMAPPARCINFOTESTMULTIAPPONEAPPWITHNONAPPARCRSC = 'sifgetcompapparcinfotestmultiapp_OneAppWithNonApparcRsc';
my $SIFGETCOMAPPARCINFOTESTCORRUPTRSC = 'sifgetcompapparcinfotest_corruptrsc';
my $SIFGETCOMAPPARCINFOTESTEMBEDDED = 'sifgetcompapparcinfotestembedded_innerwithdifficon';
my $SIFGETCOMAPPARCINFOTESTNOLOCALE = 'sifgetcompapparcinfotest_nolocale';
my $SIFGETCOMAPPARCINFOTESTLARGEANDSMALLEXTN = 'sifgetcompapparcinfotestmultifiles_largeandsmallextn';
my $SWIAPPREGINTEGRATION_CASE05 = 'swiappregintegration_case05';
my $SWIAPPREGINTEGRATION_CASE05_SU = 'swiappregintegration_case05_SU';
my $SWIAPPREGINTEGRATION_CASE06_BASE = 'swiappregintegration_case06_base';
my $SWIAPPREGINTEGRATION_CASE06_SP3 = 'swiappregintegration_case06_sp3';
my $SWIAPPREGINTEGRATION_CASE06_SP2 = 'swiappregintegration_case06_sp2';
my $SWIAPPREGINTEGRATION_CASE06_PU = 'swiappregintegration_case06_pu';
my $SWIAPPREGINTEGRATION_CASE06_SP1 = 'swiappregintegration_case06_sp1';
my $SWIAPPREGINTEGRATION_CASE06_SA = 'swiappregintegration_case06_sa';
my $SWIAPPREGINTEGRATION_CASE08_SA1 = 'swiappregintegration_case08_sa1';
my $SWIAPPREGINTEGRATION_CASE08_SA2 = 'swiappregintegration_case08_sa2';
my $suffix = '_edited';

# Replace <BUILDMIDPATH> and <ZDRIVEMIDPATH> in the PKG files with the current values
my $ZDRIVEMIDPATH = 'data';
if (lc($PLATFORM) ne "armv5")
	{
	$ZDRIVEMIDPATH = "release\\$PLATFORM\\$CONFIGURATION";
	}
my $BUILDMIDPATH = "release\\$PLATFORM\\$CONFIGURATION";
EditFile("$PKGDIR\\$BASE.pkg", "$PKGDIR\\$BASE$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$UPGRADE.pkg", "$PKGDIR\\$UPGRADE$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SIFGETCOMAPPARCINFOTEST.pkg", "$PKGDIR\\$SIFGETCOMAPPARCINFOTEST$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTILANG.pkg", "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTILANG$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIFILES.pkg", "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIFILES$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTNONAPPARCRSC.pkg", "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTNONAPPARCRSC$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTNONAPPARCPATH.pkg", "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTNONAPPARCPATH$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIAPP.pkg", "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIAPP$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIAPPONEAPPWITHNONAPPARCRSC.pkg", "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIAPPONEAPPWITHNONAPPARCRSC$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTCORRUPTRSC.pkg", "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTCORRUPTRSC$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTEMBEDDED.pkg", "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTEMBEDDED$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTNOLOCALE.pkg", "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTNOLOCALE$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTLARGEANDSMALLEXTN.pkg", "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTLARGEANDSMALLEXTN$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE05.pkg", "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE05$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE05_SU.pkg", "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE05_SU$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_BASE.pkg", "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_BASE$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP3.pkg", "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP3$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP2.pkg", "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP2$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_PU.pkg", "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_PU$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP1.pkg", "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP1$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SA.pkg", "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SA$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE08_SA1.pkg", "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE08_SA1$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });
EditFile("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE08_SA2.pkg", "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE08_SA2$suffix.pkg" , sub { s/<BUILDMIDPATH>/$BUILDMIDPATH/gm; s/<ZDRIVEMIDPATH>/$ZDRIVEMIDPATH/gm; });


my $dir = getcwd;
chdir $PKGDIR;

# Generate SIS files for SIF integration tests
my $CREATESISCMD = "createsis create -cert $CERTPATH -key $KEYPATH";
`$CREATESISCMD $PKGDIR\\$BASE$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$UPGRADE$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SIFGETCOMAPPARCINFOTEST$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTILANG$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIFILES$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SIFGETCOMAPPARCINFOTESTNONAPPARCRSC$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SIFGETCOMAPPARCINFOTESTNONAPPARCPATH$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIAPP$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIAPPONEAPPWITHNONAPPARCRSC$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SIFGETCOMAPPARCINFOTESTCORRUPTRSC$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SIFGETCOMAPPARCINFOTESTNOLOCALE$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SIFGETCOMAPPARCINFOTESTLARGEANDSMALLEXTN$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SWIAPPREGINTEGRATION_CASE05$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SWIAPPREGINTEGRATION_CASE05_SU$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_BASE$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP3$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP2$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_PU$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP1$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SA$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SWIAPPREGINTEGRATION_CASE08_SA1$suffix.pkg`;
`$CREATESISCMD $PKGDIR\\$SWIAPPREGINTEGRATION_CASE08_SA2$suffix.pkg`;

# Copy generated SIS files onto the Z drive
if (lc($PLATFORM) ne "armv5")
	{
	unlink "$DATADIR\\$BASE.sis";
	move("$PKGDIR\\$BASE$suffix.sis", "$DATADIR\\$BASE.sis");
	unlink "$DATADIR\\$UPGRADE.sis";
	move("$PKGDIR\\$UPGRADE$suffix.sis", "$DATADIR\\$UPGRADE.sis");
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTEST.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTEST$suffix.sis", "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTEST.sis");
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTMULTILANG.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTILANG$suffix.sis", "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTMULTILANG.sis");
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTMULTIFILES.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIFILES$suffix.sis", "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTMULTIFILES.sis");
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTNONAPPARCRSC.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTNONAPPARCRSC$suffix.sis", "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTNONAPPARCRSC.sis");
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTNONAPPARCPATH.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTNONAPPARCPATH$suffix.sis", "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTNONAPPARCPATH.sis");
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTMULTIAPP.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIAPP$suffix.sis", "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTMULTIAPP.sis");	
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTMULTIAPPONEAPPWITHNONAPPARCRSC.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIAPPONEAPPWITHNONAPPARCRSC$suffix.sis", "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTMULTIAPPONEAPPWITHNONAPPARCRSC.sis");	
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTCORRUPTRSC.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTCORRUPTRSC$suffix.sis", "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTCORRUPTRSC.sis");	
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTNOLOCALE.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTNOLOCALE$suffix.sis", "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTNOLOCALE.sis");	
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTLARGEANDSMALLEXTN.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTLARGEANDSMALLEXTN$suffix.sis", "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTLARGEANDSMALLEXTN.sis");
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE05.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE05$suffix.sis", "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE05.sis");	
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE05_SU.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE05_SU$suffix.sis", "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE05_SU.sis");	
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_BASE.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_BASE$suffix.sis", "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_BASE.sis");	
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_SP3.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP3$suffix.sis", "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_SP3.sis");	
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_SP2.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP2$suffix.sis", "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_SP2.sis");	
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_PU.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_PU$suffix.sis", "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_PU.sis");	
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_SP1.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP1$suffix.sis", "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_SP1.sis");	
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_SA.sis";	
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SA$suffix.sis", "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_SA.sis");	
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE08_SA1.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE08_SA1$suffix.sis", "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE08_SA1.sis");	
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE08_SA2.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE08_SA2$suffix.sis", "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE08_SA2.sis");		

	`$CREATESISCMD $PKGDIR\\$SIFGETCOMAPPARCINFOTESTEMBEDDED$suffix.pkg`;
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTEMBEDDED.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTEMBEDDED$suffix.sis", "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTEMBEDDED.sis");	

	}
else
	{
	mkdir "$ARMV5DATADIR" unless -d "$ARMV5DATADIR";
	unlink "$DATADIR\\$BASE.sis";
	move("$PKGDIR\\$BASE$suffix.sis", "$ARMV5DATADIR\\$BASE.sis");
	unlink "$DATADIR\\$UPGRADE.sis";
	move("$PKGDIR\\$UPGRADE$suffix.sis", "$ARMV5DATADIR\\$UPGRADE.sis");
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTEST.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTEST$suffix.sis", "$ARMV5DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTEST.sis");
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTMULTILANG.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTILANG$suffix.sis", "$ARMV5DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTMULTILANG.sis");	
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTMULTIFILES.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIFILES$suffix.sis", "$ARMV5DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTMULTIFILES.sis");
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTNONAPPARCRSC.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTNONAPPARCRSC$suffix.sis", "$ARMV5DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTNONAPPARCRSC.sis");
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTNONAPPARCPATH.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTNONAPPARCPATH$suffix.sis", "$ARMV5DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTNONAPPARCPATH.sis");
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTMULTIAPP.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIAPP$suffix.sis", "$ARMV5DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTMULTIAPP.sis");
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTMULTIAPPONEAPPWITHNONAPPARCRSC.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIAPPONEAPPWITHNONAPPARCRSC$suffix.sis", "$ARMV5DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTMULTIAPPONEAPPWITHNONAPPARCRSC.sis");
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTCORRUPTRSC.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTCORRUPTRSC$suffix.sis", "$ARMV5DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTCORRUPTRSC.sis");
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTNOLOCAL.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTNOLOCAL$suffix.sis", "$ARMV5DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTNOLOCAL.sis");	
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTLARGEANDSMALLEXTN.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTLARGEANDSMALLEXTN$suffix.sis", "$ARMV5DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTLARGEANDSMALLEXTN.sis");
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE05.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE05$suffix.sis", "$ARMV5DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE05.sis");
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE05_SU.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE05_SU$suffix.sis", "$ARMV5DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE05_SU.sis");
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_BASE.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_BASE$suffix.sis", "$ARMV5DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_BASE.sis");
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_SP3.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP3$suffix.sis", "$ARMV5DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_SP3.sis");
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_SP2.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP2$suffix.sis", "$ARMV5DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_SP2.sis");
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_PU.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_PU$suffix.sis", "$ARMV5DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_PU.sis");
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_SP1.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP1$suffix.sis", "$ARMV5DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_SP1.sis");
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_SA.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SA$suffix.sis", "$ARMV5DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE06_SA.sis");
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE08_SA1.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE08_SA1$suffix.sis", "$ARMV5DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE08_SA1.sis");
	unlink "$DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE08_SA2.sis";
	move("$PKGDIR\\$SWIAPPREGINTEGRATION_CASE08_SA2$suffix.sis", "$ARMV5DATADIR_TSIF\\$SWIAPPREGINTEGRATION_CASE08_SA2.sis");
				
	`$CREATESISCMD $PKGDIR\\$SIFGETCOMAPPARCINFOTESTEMBEDDED$suffix.pkg`;
	unlink "$DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTEMBEDDED.sis";
	move("$PKGDIR\\$SIFGETCOMAPPARCINFOTESTEMBEDDED$suffix.sis", "$ARMV5DATADIR_TSIF\\$SIFGETCOMAPPARCINFOTESTEMBEDDED.sis");	
		
		}			
			
unlink "*.cer"; #delete all certificates to avoid failure on checklocationofcertificates test

unlink "$PKGDIR\\$BASE$suffix.pkg";
unlink "$PKGDIR\\$UPGRADE$suffix.pkg";
unlink "$PKGDIR\\$SIFGETCOMAPPARCINFOTEST$suffix.pkg";
unlink "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTILANG$suffix.pkg";
unlink "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIFILES$suffix.pkg";
unlink "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTNONAPPARCRSC$suffix.pkg";
unlink "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTNONAPPARCPATH$suffix.pkg";
unlink "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIAPP$suffix.pkg";
unlink "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTMULTIAPPONEAPPWITHNONAPPARCRSC$suffix.pkg";
unlink "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTCORRUPTRSC$suffix.pkg";
unlink "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTNOLOCALE$suffix.pkg";
unlink "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTEMBEDDED$suffix.pkg";
unlink "$PKGDIR\\$SIFGETCOMAPPARCINFOTESTLARGEANDSMALLEXTN$suffix.pkg";
unlink "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE05$suffix.pkg";
unlink "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE05_SU$suffix.pkg";
unlink "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_BASE$suffix.pkg";
unlink "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP3$suffix.pkg";
unlink "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP2$suffix.pkg";
unlink "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_PU$suffix.pkg";
unlink "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SP1$suffix.pkg";
unlink "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE06_SA$suffix.pkg";
unlink "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE08_SA1$suffix.pkg";
unlink "$PKGDIR\\$SWIAPPREGINTEGRATION_CASE08_SA2$suffix.pkg";

chdir $dir;


# Read the contents of a file into a string and return it
sub ReadFile ($) {
	my ($file) = @_;
	open FILE, "<$file" or die "Can't read from $file: $!";
	local $/ = undef;
	my $data = <FILE>;
	close FILE;
	return $data;
}

# Replace a file with a string
sub WriteFile ($$) {
	my ($file, $data) = @_;

	# Ensure directory exists
	if ($1 && $file =~ basename($1) && ! -e $1)
		{
		mkdir($1);
		}
	
	if (-e $file)
		{
		system("attrib -r $file");
		}
	
	open FILE, ">$file" or die "Can't write to $file: $!";
	print FILE $data;
	close FILE;
}

# Edit a file
sub EditFile ($$$) {
	my ($infile, $outfile, $coderef) = @_;
	local $_ = ReadFile($infile);
	&$coderef();
	WriteFile($outfile, $_);
}

