/*
* Copyright (c) 2006 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:   CNcdUnknownParser declaration
*
*/


#include "ncdsubparser.h"

/**
 * Unkown data parser. It is used to skip over unknown xml elements.
 * All data to the corresponding end tag is skipped.
 */
class CNcdUnknownParser : public CNcdSubParser
    {
public:
    static CNcdUnknownParser* NewL( MNcdParserObserverBundle& aObservers, 
                                    MNcdSubParserObserver& aSubParserObserver,
                                    TInt aDepth,
                                    const Xml::RTagInfo& aElement, 
                                    const Xml::RAttributeArray& aAttributes );
    virtual ~CNcdUnknownParser();
private:
    CNcdUnknownParser( MNcdParserObserverBundle& aObservers, 
                       MNcdSubParserObserver& aSubParserObserver,
                       TInt aDepth );
    void ConstructL( const Xml::RTagInfo& aElement, 
                     const Xml::RAttributeArray& aAttributes );
protected:
    virtual void OnStartElementL(const Xml::RTagInfo& aElement, const Xml::RAttributeArray& aAttributes, 
                                 TInt aErrorCode) ;
    virtual void OnEndElementL(const Xml::RTagInfo& aElement, TInt aErrorCode );
    virtual void OnContentL(const TDesC8& aBytes, TInt aErrorCode) ;

private:
    /**
     * The initial depth is required to check whether received end tag is
     * actually the closing tag for this parser.
     */
    TInt iInitialDepth;
    };
