/*
* Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  test data for DrmHelperTest test module.
*
*/


#ifndef DRMHELPERTESTDATA_H
#define DRMHELPERTESTDATA_H
#include <f32file.h>
// -----------------------------------------------------------------------------
// OMA DRM 1 SD image, no RI Url
// -----------------------------------------------------------------------------
//
_LIT( KDcf1JpegFile, "C:\\jpg.dcf" );


_LIT8( KDcf1JpegData,
"\
\001\012\057\151\155\141\147\145\057\152\160\145\147\143\151\144\
\072\155\171\055\164\145\170\164\055\062\060\060\067\060\071\061\
\070\062\060\061\071\062\061\055\062\060\064\061\066\063\061\062\
\064\063\100\156\157\153\151\141\056\143\157\155\054\224\000\105\
\156\143\162\171\160\164\151\157\156\055\115\145\164\150\157\144\
\072\040\101\105\123\061\062\070\103\102\103\073\160\141\144\144\
\151\156\147\075\122\106\103\062\066\063\060\257\173\160\346\212\
\252\052\072\276\261\144\203\332\340\105\065\004\273\161\353\216\
\264\266\045\001\373\373\342\102\223\050\205\316\352\046\015\031\
\101\156\264\122\221\257\277\017\027\145\353\341\350\321\240\134\
\245\273\207\064\145\130\047\275\345\027\206\106\010\274\060\106\
\060\355\165\217\341\000\143\026\304\317\264\054\114\036\322\361\
\254\222\273\267\103\054\026\207\025\315\037\123\060\003\044\006\
\165\206\115\340\112\017\057\250\114\031\275\101\001\374\155\125\
\142\141\131\364\143\170\044\355\057\134\320\312\314\257\062\105\
\322\061\367\257\140\042\300\312\141\326\132\370\021\231\057\162\
\155\111\010\223\266\305\330\110\247\322\070\357\021\144\155\134\
\335\233\261\171\356\170\065\304\044\102\210\230\124\071\371\244\
\230\147\332\145\324\361\213\302\010\176\164\260\332\132\345\206\
\034\177\107\215\253\201\157\164\355\256\314\263\275\205\370\301\
\357\112\276\056\353\060\277\040\340\036\277\033\164\010\335\350\
\120\122\225\326\205\031\103\217\345\336\161\121\264\206\262\007\
\306\123\267\103\340\313\245\014\307\042\045\273\005\170\001\207\
\372\001\227\107\276\154\231\214\327\055\024\015\220\073\250\040\
\142\020\223\353\031\345\110\010\076\303\015\345\177\074\244\254\
\042\340\076\341\036\256\030\176\255\046\266\162\347\250\101\160\
\240\372\260\161\254\221\307\335\341\221\000\213\002\370\215\207\
\347\332\035\315\131\172\374\357\057\250\171\215\137\315\044\311\
\252\122\056\031\034\144\034\363\346\236\307\073\312\103\332\267\
\175\024\332\071\026\315\011\264\035\211\161\153\326\267\024\260\
\005\057\320\257\321\146\256\245\225\007\242\321\050\011\051\232\
\242\305\233\254\272\034\060\206\024\336\272\370\150\263\160\306\
\042\127\143\160\154\010\233\112\042\025\366\044\212\321\137\017\
\173\211\221\053\056\331\337\342\107\233\177\076\201\051\205\300\
\131\336\166\026\374\263\011\112\027\055\067\126\302\165\146\205\
\024\366\046\212\202\126\264\332\030\145\167\134\072\354\217\220\
\035\154\344\301\147\064\156\340\001\353\371\300\141\337\150\015\
\204\056\265\320\367\374\250\037\153\074\014\223\266\232\116\263\
\206\016\273\015\121\375\226\010\343\223\351\313\004\122\012\047\
\373\365\275\316\160\302\253\263\140\032\114\146\157\011\117\207\
\110\173\264\266\116\036\344\352\023\135\360\243\337\255\140\275\
\062\023\375\167\223\175\036\172\012\214\060\320\156\151\065\062\
\357\337\275\172\335\057\164\240\115\372\164\370\057\104\255\334\
\144\216\221\243\221\161\117\212\023\350\213\353\177\313\203\142\
\213\157\213\045\065\041\262\301\242\207\305\332\167\352\111\164\
\154\135\101\236\264\052\307\273\107\215\247\330\270\175\260\254\
\105\030\000\057\163\217\031\002\215\365\017\130\340\134\200\217\
\367\261\071\300\251\213\252\336\073\176\170\143\244\172\144\015\
\054\345\342\166\224\237\362\350\033\167\312\133\271\324\176\374\
\262\011\137\066\166\117\313\033\212\116\063\120\210\347\132\123\
\146\275\173\320\102\372\256\237\303\260\247\320\066\205\142\252\
\017\337\110\014\065\320\174\230\227\033\171\350\230\373\251\011\
\006\274\305\136\332\206\377\316\064\115\072\245\342\003\150\003\
\014\035\064\157\220\317\162\314\063\036\320\137\107\364\012\043\
\076\036\271\061\234\312\122\005\240\116\363\217\336\026\151\102\
\236\265\343\200\116\201\260\210\151\210\005\264\025\163\343\224\
\054\030\136\045\217\312\360\312\313\124\271\240\065\202\073\031\
\062\152\255\347\104\042\142\276\266\152\365\213\373\056\121\033\
\112\145\343\005\271\113\275\353\116\163\234\100\230\240\230\035\
\163\141\112\113\252\366\337\154\117\266\110\013\040\304\167\057\
\267\260\136\245\305\172\017\057\325\371\041\126\171\271\270\137\
\106\360\036\113\312\231\024\327\256\030\316\026\036\141\255\244\
\153\123\363\060\021\057\124\127\025\316\227\117\172\276\336\075\
\000\360\275\141\221\226\255\015\055\341\202\255\352\173\301\012\
\234\102\161\317\160\337\134\044\223\177\064\323\102\041\015\326\
\256\056\277\157\264\001\143\301\077\107\031\371\262\163\021\072\
\223\270\072\234\152\236\225\164\262\023\106\356\202\022\102\145\
\343\307\107\315\241\375\204\166\147\035\367\027\272\347\016\051\
\017\353\141\326\237\123\271\101\045\272\254\314\111\103\124\342\
\007\203\076\256\332\272\103\223\024\073\333\134\166\061\354\370\
\212\233\357\047\355\311\241\161\222\127\065\046\351\374\231\230\
\015\214\001\351\315\266\023\005\051\212\135\313\271\004\033\035\
\334\210\224\005\235\262\307\172\160\136\327\166\036\326\362\173\
\144\365\364\015\076\144\273\270\227\224\276\210\073\071\033\215\
\354\135\063\107\115\060\202\340\305\003\025\112\335\130\123\034\
\305\075\174\211\120\274\231\123\333\146\202\325\364\140\320\330\
\060\245\310\143\137\307\241\226\057\015\102\365\240\277\340\157\
\310\161\230\124\160\352\134\354\027\200\063\022\341\263\226\123\
\343\143\246\345\311\310\131\265\076\205\173\134\377\176\010\327\
\005\102\365\103\206\264\141\207\126\116\017\255\200\221\132\110\
\014\165\340\151\150\336\043\267\071\027\215\251\022\106\102\314\
\367\335\103\125\167\356\355\322\376\331\251\105\175\036\020\034\
\277\313\157\047\265\051\300\316\212\247\212\314\022\350\040\216\
\137\214\142\153\222\352\255\173\276\263\156\005\006\213\304\255\
\232\277\350\261\143\156\116\352\210\301\230\065\270\366\050\114\
\043\323\267\253\252\035\321\246\114\140\006\012\254\255\207\025\
\230\245\352\120\243\137\030\116\346\145\026\351\134\031\135\334\
\201\342\016\073\114\132\023\141\320\003\277\047\051\304\210\215\
\024\226\241\227\050\167\046\333\052\154\223\167\236\065\203\323\
\365\263\000\356\352\306\240\170\002\213\216\236\047\250\044\115\
\332\162\033\216\126\050\010\315\030\301\340\275\357\240\124\204\
\060\103\376\315\273\131\107\305\213\301\047\254\315\113\246\371\
\046\112\360\050\114\207\102\240\323\061\001\311\275\344\211\220\
\304\251\320\326\213\072\124\226\074\054\321\363\044\156\271\213\
\256\241\236\227\001\020\204\256\041\223\051\150\244\177\071\112\
\236\227\245\310\223\252\173\216\105\176\220\165\132\366\121\345\
\207\102\173\256\231\035\353\364\367\015\361\055\133\230\102\351\
\240\226\231\114\342\323\176\336\071\033\231\001\331\036\137\000\
\117\222\265\163\052\257\174\200\015\264\306\015\274\300\014\163\
\201\057\336\005\042\006\361\236\167\141\213\070\037\223\243\265\
\244\253\117\275\012\275\101\111\112\072\306\004\316\252\245\061\
\064\374\321\131\066\277\015\173\330\303\206\202\066\151\031\365\
\054\364\352\250\204\250\226\175\042\123\057\363\265\302\043\361\
\323\062\377\272\001\203\373\345\365\246\021\310\160\155\200\055\
\216\205\231\057\177\360\242\351\030\023\100\030\107\274\354\211\
\354\306\073\207\166\175\004\045\270\263\367\366\100\261\234\020\
\125\003\220\351\355\114\267\343\120\077\002\030\222\201\067\340\
\226\322\307\151\162\273\247\240\243\352\005\327\122\054\210\017\
\104\237\071\273\005\044\323\057\352\361\351\253\007\373\133\240\
\345\202\273\334\140\322\252\006\110\011\040\355\372\014\133\137\
\205\212\142\150\222\050\027\201\031\011\135\154\206\022\114\073\
\215\276\244\065\330\067\323\211\217\331\265\340\036\362\231\243\
\071\165\233\006\265\063\072\213\346\030\262\035\326\012\277\004\
\233\042\072\246\045\043\303\111\257\016\075\260\215\372\264\010\
\234\313\241\216\142\351\145\371\171\010\037\020\307\334\347\074\
\137\034\051\264\332\375\231\353\013\275\222\275\331\347\173\257\
\022\313\010\330\323\002\262\073\264\267\163\356\162\052\375\307\
\206\171\122\361\375\124\345\213\024\123\214\305\161\206\067\340\
\137\261\232\354\105\010\235\005\325\153\027\270\123\152\203\115\
\367\372\031\116\241\215\075\217\177\022\063\044\117\015\133\014\
\335\275\035\314\050\344\214\242\350\017\254\226\340\312\114\377\
\327\007\044\025\324\072\362\200\120\371\221\222\316\044\266\137\
\173\214\337\043\032\124\354\357\062\267\151\110\241\305\030\056\
\312\075\251\301\253\141\140\000\134\146\055\062\052\132\140\176\
\123\161\256\065\100\152\110\311\045\110\034\347\202\056\012\072\
\174\204\003\207\153\246\041\372\334\015\103\040\365\136\310\056\
\353\230\022\075\227\136\370\160\373\346\040\371\166\261\251\044\
\137\144\253\054\036\052\246\242\036\144\303\164\237\171\376\246\
\067\171\034\205\057\300\224\165\260\365\050\152\306\262\346\054\
\226\133\207\202\033\001\323\000\051\206\351\060\343\251\167\116\
\144\041\073\125\276\362\155\336\065\266\350\067\163\100\256\124\
\233\347\055\157\020\311\373\302\020\265\355\055\247\302\305\340\
\006\020\271\324\133\175\174\016\073\176\374\123\071\350\300\066\
\274\326\206\062\237\153\255\121\300\312\076\375\075\015\255\101\
\333\366\155\274\217\357\267\166\066\326\012\326\107\162\115\175\
\041\000\374\327\346\146\012\352\051\173\157\105\262\264\337\161\
\203\251\147\052\010\300\372\213\127\264\165\113\000\323\334\304\
\135\114\304\354\333\105\240\261\160\254\256\134\215\327\067\236\
\364\314\212\115\360\336\026\013\274\165\131\363\323\072\336\322\
\372\243\344\347\133\343\043\314\361\305\055\113\032\131\121\062\
\217\022\047\062\301\341\317\212\374\270\050\233\023\313\106\245\
\160\373\046\271\160\323\122\033\303\055\035\072\161\027\051\166\
\234\216\372\161\106\114\376\151\135\024\213\217\173\221\343\371\
\174\035\172\371\252\312\147\153\217\205\104\004\235\105\373\047\
\316\055\016\300\260\053\177\246\062\307\273\032\245\116\252\363\
\256\131\006\304\141\055\005\205\153\151\135\002\221\075\237\351\
\311\032\150\341\344\341\211\361\335\133\252\210\075\200\224\137\
\124\162\316\361\235\013\167\222\035\142\114\023\361\054\164\377\
\007\371\124\043\266\156\067\121\006\316\033\312\213\175\224\072\
\341\204\300\343\357\016\257\025\335\024\364\035\074\224\373\336\
\370\246\130\167\177\112\251\222\241\265\237\232\270\355\340\114\
\330\031\332\144\025\051\052\255\054\311\064\206\152\027\005\250\
\260\251\371\327\232\300\223\153\236\214\004\377\373\020\036\162\
\231\221\033\311\115\112\264\334\227\347\152\176\220\262\273\022\
\107\170\043\102\241\132\315\375\251\156\157\347\242\007\275\273\
\034\114\367\127\163\327\071\056\127\131\152\325\344\105\101\155\
\346\006\362\255\027\161\051\266\377\174\117\037\074\230\335\047\
\173\346\015\201\042\212\107\304\302\333\173\277\131\270\365\137\
\312\035\351\261\147\011\334\150\317\142\004\172\051\213\077\141\
\020\327\174\244\166\266\076\314\076\256\110\254\021\315\310\030\
\206\334\071\252\363\127\117\052\212\142\316\050\261\135\152\036\
\111\303\264\160\273\367\160\250\056\371\200\117\306\203\344\015\
\226\356\231\073\236\202\217\227\043\042\361\025\166\230\266\065\
\322\156\016\262\105\313\004\156\010\010\161\071\047\101\071\063\
\164\214\213\120\026\255\210\151\263\231\251\300\306\300\344\031\
\134\307\224\010\213\102\221\341\123\011\060\375\217\165\176\126\
\023\375\211\217\034\106\135\137\376\261\327\
"
);

_LIT8( KCid1Jpeg, "cid:my-text-20070918201921-2041631243@nokia.com" );
_LIT8( KCek1Jpeg, "N+CIARh8CAcOBvc3if5sQA==" );

// -----------------------------------------------------------------------------
// Plain text
// -----------------------------------------------------------------------------
//
_LIT( KPlainTextFile, "c:\\text.txt" );


_LIT8( KPlainTextData,
"\
kokkokokookokoonkokokokkokokokokkokokokookokokokkokokoonkokoonkokokokon\r\n\
sanonopeastimustankissanpaksutposket\r\n\
katkatkatkara\
" );

// ----------------------------------------------------------------------------
// DRM 2 audio file witn infourl and with contenturl
// -----------------------------------------------------------------------------
//
_LIT( KDcf2MpegFile, "C:\\mp3.odf" );


// ----------------------------------------------------------------------------
// DRM 2 JPEG file without extra information
// -----------------------------------------------------------------------------
//
_LIT( KDcf2JpegFile, "C:\\jpg.odf" );
_LIT8( KDcf2JpegData, "" );

// -----------------------------------------------------------------------------
// nonexistent contentid
// -----------------------------------------------------------------------------
//
_LIT8( KCidNotExist, "cid:cid-does-not-exist@nokia.com" );



// -----------------------------------------------------------------------------
// Rights objects
// -----------------------------------------------------------------------------
//

// -----------------------------------------------------------------------------
// Formatter for OMA 1 RO head
// Use example
// TDesC8 cid, cek, permissioins;
// TDesC& RO
// RO.AppendFormat( KRO1HeadFormatter, &cid, &cek &permissions);
// -----------------------------------------------------------------------------
//
_LIT8( KRO1Formatter,
"\
<o-ex:rights\r\n\
   xmlns:o-ex=\"http://odrl.net/1.1/ODRL-EX\"\r\n\
   xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\"\r\n\
   xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#/\"\r\n\
>\r\n\
<o-ex:context>\r\n\
<o-dd:version>1.0</o-dd:version>\r\n\
</o-ex:context>\r\n\
<o-ex:agreement>\r\n\
<o-ex:asset>\r\n\
<o-ex:context>\r\n\
<o-dd:uid>%S</o-dd:uid>\r\n\
</o-ex:context>\r\n\
<ds:KeyInfo>\r\n\
<ds:KeyValue>%S</ds:KeyValue>\r\n\
</ds:KeyInfo>\r\n\
</o-ex:asset>\r\n\
<o-ex:permission>\r\n\
%S\
</o-ex:permission>\r\n\
</o-ex:agreement>\r\n\
</o-ex:rights>\r\n\
\r\n\
" );

_LIT8( KDisplayCount1,
"\
<o-dd:display>\r\n\
<o-ex:constraint>\r\n\
<o-dd:count>1</o-dd:count>\r\n\
</o-ex:constraint>\r\n\
</o-dd:display>\r\n\
" );

_LIT8( KDisplayFull, "<o-dd:display/>\r\n" );

_LIT8( KDisplayCount1PrintInterval1Second,
"\
<o-dd:display>\r\n\
<o-ex:constraint>\r\n\
<o-dd:count>1</o-dd:count>\r\n\
</o-ex:constraint>\r\n\
</o-dd:display>\r\n\
<o-dd:print>\r\n\
<o-ex:constraint>\r\n\
<o-dd:interval>PT1S</o-dd:interval>\r\n\
</o-ex:constraint>\r\n\
</o-dd:print>\r\n\
" );


struct TFileDataMap
    {
public:
    const TDesC& iFile;
    const TDesC8& iData;
    };

void CreateDataFilesL( RFs& aFs )
    {
    const TFileDataMap files[] =
        {
            { KPlainTextFile, KPlainTextData },
            { KDcf1JpegFile, KDcf1JpegData },
            { KDcf2JpegFile, KDcf2JpegData },
        };
    const TInt numElements( sizeof ( files ) / sizeof( TFileDataMap ) );


    for ( TInt i( 0 ); i < numElements; ++i )
        {
        RFile file;
        User::LeaveIfError ( file.Replace( aFs, files[ i ].iFile, EFileWrite ) );
        CleanupClosePushL( file );
        User::LeaveIfError( file.Write( files[ i ].iData ) );
        CleanupStack::PopAndDestroy( &file );
        }
    }

#endif      // DRMHELPERTESTDATA_H

// End of File
