/* GStreamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* First, include the header file for the plugin, to bring in the
 * object definition and other useful things.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gst/gst.h>

#include "avcodec.h"

extern gboolean gst_ffmpegcolorspace_register (GstPlugin * plugin);

static gboolean
plugin_init (GstPlugin * plugin)
{
  avcodec_init ();
  gst_ffmpegcolorspace_register (plugin);

  /* Now we can return the pointer to the newly created Plugin object. */
  return TRUE;
}

GST_PLUGIN_DEFINE (GST_VERSION_MAJOR,
    GST_VERSION_MINOR,
    "ffmpegcolorspace",
    "colorspace conversion copied from FFMpeg " FFMPEG_VERSION,
    plugin_init, VERSION, "LGPL", "FFMpeg", "http://ffmpeg.sourceforge.net/");


#ifdef __SYMBIAN32__
EXPORT_C 
#endif
GstPluginDesc* _GST_PLUGIN_DESC()
{
    return &gst_plugin_desc;
}

