/*
* Copyright (c) 2005-2006 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  Operator/Service provider name publisher.
*
*/


#ifndef C_AIOPERATORPROVIDERNAMEPUBLISHER_H
#define C_AIOPERATORPROVIDERNAMEPUBLISHER_H

// System includes
#include <e32base.h>
#include <AknUtils.h>
#include <MProEngProfileActivationObserver.h>

// User includes
#include "aidevicestatuspublisher.h"
#include "ainetworkinfoobserver.h"

// Forward declarations
class MProfileEngine;
class MProEngNotifyHandler;
class CAiNetworkInfoListener;
class MAiDeviceStatusContentObserver;
class CHsContentPublisher;


/**
 *  @ingroup group_devicestatusplugin
 *
 *  Operator/Service provider name publisher.
 *
 *  Listens network info changes and publishes operator name
 *  if it is received.
 *
 *  @since S60 3.2
 */
NONSHARABLE_CLASS( CAiOperatorNamePublisher ) : public CBase, 
    public MAiDeviceStatusPublisher,
    public MAiNetworkInfoObserver,
    public MProEngProfileActivationObserver
    {
public:

    static CAiOperatorNamePublisher* NewL();

    virtual ~CAiOperatorNamePublisher();

//from base class MAiDeviceStatusPublisher

    void ResumeL();
    void Subscribe( MAiContentObserver& aObserver, 
                    CHsContentPublisher& aExtension,
                    MAiPublishPrioritizer& aPrioritizer,
                    MAiPublisherBroadcaster& aBroadcaster );
    void RefreshL( TBool aClean );
    TBool RefreshL( TInt aContentId, TBool aClean );
    TBool SuspendL( TInt aContentId, TBool aClean );
    TBool RefreshContentWithPriorityL( TInt aContentId, TInt aPriority );


protected:

//from base class MAiNetworkInfoObserver

    /**
     * From MAiNetworkInfoObserver.
     * Called when network info changes.
     */
    void HandleNetworkInfoChange( const MNWMessageObserver::TNWMessages& aMessage, 
    							  const TNWInfo& aInfo, 
    							  const TBool aShowOpInd );

private:
    // from MProEngProfileActivationObserver
    
    /**
     * @see MProEngProfileActivationObserver    
     */    
    void HandleProfileActivatedL( TInt aProfileId );

private:

    CAiOperatorNamePublisher();

    void ConstructL();

    /**
     * Check SPN status from PLMNField. Also check if current country and network
     * codes are in PLMNField.
     */
    void CAiOperatorNamePublisher::CheckServiceProviderDisplayListStatus(
        TInt aMCC,
        TInt aMNC,
        TBool& aShowSPN,
        TBool& aIsInSPDI ) const;

    /**
     * Check if current network is ready. Returns ETrue if all needed messages are
     * received from network info listener.
     */
    TBool CurrentNetworkOk() const;

    /**
     * Returns ETrue if phone is currently roaming.
     */
    TBool IsRoaming() const;

    /**
     * If operator indicator needs to be animated, start delayed clean operation.
     * Operator indicator will be replaced by plmn indicator after clean operation.
     */
    void StartDelayedPLMNOperation();

    /**
     * Called by CPeriodic when timer expires.
     */
    static TInt CleanAndShowPLMNOperationCallback( TAny* aPtr );

    /**
     * Do delayed clean operation.
     */
    void DoCleanOperationL();
    
    /**
     * Show network indicator
     * @param aTryToPublish 
     * ETrue: Sets operator name, priority and tries to publish operator name. 
     * EFalse: Sets operator name, priority and not to try to publish it.
     */
    void ShowNetworkIdentityNameL( TBool aTryToPublish );
    
    /**
     * Check priority of operator name
     */	
    TBool OperatorNamePriority( TInt& aPriority );
    
    /**
     * Construct PLMN and SPN indicators to same string
     */
    HBufC* ConstructOperatorNameStringL( const TDesC& aServiceProviderName );
    
    /**
     * Check status of keylock
     */
    TBool IsKeyLockEnabled();

private: // data

    /** Network info listener, not owned */
    CAiNetworkInfoListener* iListener;
    /** Property extension, not owned */
    CHsContentPublisher* iExtension;
	/** Content prioritizer, not owned */
	MAiPublishPrioritizer* iPrioritizer;    
	/** Publish broadcaster, not owned */
	MAiPublisherBroadcaster* iBroadcaster;    
    /** Used to do delayed clean operation, owned */
    CPeriodic* iPeriodic;    
    /** True if publish was successful */
    TBool iSuccess;    
    /** Operator name priority */
    TInt iPriority;    
    /** Show operator indicator */
    TBool iShowOpInd;    
    /** Network identity name */
    TPtrC iNetworkIdentityName;    
    /** Flag to indicate if the content is suspended */ 
    TBool iSuspended;
    /** Profile engine, owned */
    MProfileEngine* iProfileEngine;
    /** Profile change notifier, owned */
    MProEngNotifyHandler* iProfileNotifier;
    };

#endif // C_AIOPERATORPROVIDERNAMEPUBLISHER_H

// End of file
