/*
* Copyright (c) 2006 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  Contains common internal consts, typedefs for the Access Point 
*                settings.
*
*/

#ifndef CMPSETTINGS_CONSTS_H
#define CMPSETTINGS_CONSTS_H

// CONSTANTS

#define KMaxConnNameLength            30
#define KMaxGprsApNameLength          100
#define KMaxLoginNameLength           50
#define KMaxStartPageLength           1000
#define KMaxAccessNumLength           20
#define KMaxLoginScriptLength         1000
#define KMaxLoginPasswordLength       50
#define KMaxModInitStringLength       50
#define KMaxProxyServerLength         1000
#define KMaxProxyPortNumberLength     5
#define KMaxNetworkNameLength         50
#define KMaxIPv6NameServerLength      50
#define KMaxIPv4NameServerLength      15
#define KMaxWlanNetworkameLength      32
#define KMaxAdhocChannelNumberLength  2
#define KAdhocChannelMin              1
#define KAdhocChannelMax              11
#define KMaxDialUpNumLength           20
#define KMaxNumericPageLength         50

#define KConnNameWidth                10
#define KGprsApNameWidth              10
#define KLoginNameWidth               10
#define KStartPageWidth               10
#define KAccessNumWidth               10
#define KCBInfoWidth                  10
#define KServiceCentreAddrWidth       10
#define KServiceAccessNumWidth        10
#define KIpAddressWidth               15
#define KLoginScriptWidth             10
#define KModInitStringWidth           10
#define KProxyServerWidth             10
#define KProxyPortNumberWidth         10
#define KNetworkNameWidth             10
#define KNumericPageWidth             50

#define KConnNameLines                2
#define KGprsApNameLines              2
#define KLoginNameLines               2
#define KStartPageLines               2
#define KAccessNumLines               2
#define KCBInfoLines                  2
#define KServiceCentreAddrLines       2
#define KServiceAccessNumLines        2
#define KIpAddressLines               2
#define KLoginScriptLines             2
#define KModInitStringLines           2
#define KProxyServerLines             2
#define KProxyPortNumberLines         2
#define KNetworkNameLines             1
#define KNumericPageLines             2

#define KSettingsItemMaxLength        100
#define KSettingsNumItemMaxLength     10
    

#define KListQueryHeight              6
#define KListQueryWidth               2

#endif  // CMPSETTINGS_CONSTS_H
