/*
* Copyright (c) 2002-2004 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:   Implementation of CMessageAddress interface.
*                Encapsulates message real address and alias.
*
*/



// ============================ MEMBER FUNCTIONS ===============================

// -----------------------------------------------------------------------------
// CMessageAddressImpl::Address
// Returns  real address.
// (other items were commented in a header).
// -----------------------------------------------------------------------------
//
inline const TPtrC CMessageAddressImpl::Address() const
    {
    return iRealAddress ? TPtrC( *iRealAddress ) : TPtrC();
    }

// -----------------------------------------------------------------------------
// CMessageAddressImpl::Alias
// Returns the alias for the real address.
// (other items were commented in a header).
// -----------------------------------------------------------------------------
//
inline const TPtrC CMessageAddressImpl::Alias() const
    {
    return iAlias ? TPtrC( *iAlias ) : TPtrC();
    }

//  End of File
