/*
* Copyright (c) 2004 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  This file contains the header file of the CCbsRecWcdmaMessage 
*               class.
*
*/


#ifndef CCBSRECWCDMAMESSAGE_H
#define CCBSRECWCDMAMESSAGE_H

// INCLUDES
		/*****************************************************
		*	Series 60 Customer / ETel
		*	Series 60  ETel API
		*****************************************************/
#include <etelmm.h>

#include "CbsCommon.h"
#include "CbsReceiverTypes.h"
#include "CCbsMessage.h"


// CLASS DECLARATION

/**
*  CCbsRecWcdmaMessage represents a WCDMA message page generated by 
*   CCbsRecEtelMonitor.
*
*  CCbsRecWcdmaMessage is constructed from a CB message page received from 
*   EPOC Telephony Server.
*/
class CCbsRecWcdmaMessage : public CCbsMessage
    {
    public:        // Constructors and Destructors
        /**
        *   Constructs a new CCbsRecMessage based on TDes8&
        *   (which is a descriptor) received from EPOC Telephony Server.
        *   
        *   @param  aMessagePage        Source message descriptor
        *   @param  aAttributes         Message attributes
        *   @return                     A new instance of CCbsRecWcdmaMessage
        */
        static CCbsRecWcdmaMessage* NewL( const TDes8& aMessagePage,
            const RMobileBroadcastMessaging::TMobileBroadcastAttributesV2& aAttributes );

        /**
        *   Constructs a new CCbsRecMessage based on TDes8&
        *   (which is a descriptor) received from EPOC Telephony Server.
        *   
        *   @param  aMessage        Source message
        *   @return                 A new instance of CCbsRecWcdmaMessage
        */
        static CCbsRecWcdmaMessage* NewL( const CCbsMessage& aMessage );        

        /**
        *   Destructor
        */
        ~CCbsRecWcdmaMessage();

    public:
        /**
        *   Returns the page number of this page in the message page sequence,
        *
        *   @return                     Page number of this page.
        */
        TUint ThisPage() const;

        /**
        *   Returns the total number of pages in this page's message.
        *
        *   @return                     Total number of pages in this message
        */
        TUint TotalPages() const;

    public: // from CCbsMessage

        /**
        *   Appends another message's content to this message's content.
        *
        *   @return                     Type of this message
        */
        TInt MessageType() const;

    private:

        /**
        *   2nd-phase constructor.
        *
        *   @param aMessagePage         Message page
        *   @param aAttributes          Message attributes
        */
        void ConstructL( const TDes8& aMessagePage,
            const RMobileBroadcastMessaging::TMobileBroadcastAttributesV2& aAttributes );

        /**
        *   2nd-phase constructor.
        *
        *   @param aMessage             Message page
        */
        void ConstructL( const CCbsMessage& aMessage );
        
        /**
        *   Default constructor
        */
        CCbsRecWcdmaMessage( const RMobileBroadcastMessaging::TMobileBroadcastAttributesV2& aAttributes );

        /**
        *   Default constructor
        */
        CCbsRecWcdmaMessage();

    private:    // prohibited functions and operators
        
        // Copy constructor: NewL() used instead
       CCbsRecWcdmaMessage( const CCbsRecWcdmaMessage& );

        // Assignment operator
       CCbsRecWcdmaMessage& operator=( const CCbsRecWcdmaMessage& );

    private:    // data

        // Message type (CBS message, schedule message, CBS41 message)
        TUint8 iMessageType;

        // WCDMA message attributes
        RMobileBroadcastMessaging::TMobileBroadcastAttributesV2 iWcdmaAttributes;
        
    };

#endif // CCBSRECWCDMAMESSAGE_H

// End of File
