/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXMLHttpRequestUpload.h"

#include "Event.h"
#include "EventListener.h"
#include "Frame.h"
#include "JSDOMGlobalObject.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "RegisteredEventListener.h"
#include "XMLHttpRequestUpload.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSXMLHttpRequestUpload);

/* Hash table */

static const HashTableValue JSXMLHttpRequestUploadTableValues[7] =
{
    { "onabort", DontDelete, (intptr_t)jsXMLHttpRequestUploadOnabort, (intptr_t)setJSXMLHttpRequestUploadOnabort },
    { "onerror", DontDelete, (intptr_t)jsXMLHttpRequestUploadOnerror, (intptr_t)setJSXMLHttpRequestUploadOnerror },
    { "onload", DontDelete, (intptr_t)jsXMLHttpRequestUploadOnload, (intptr_t)setJSXMLHttpRequestUploadOnload },
    { "onloadstart", DontDelete, (intptr_t)jsXMLHttpRequestUploadOnloadstart, (intptr_t)setJSXMLHttpRequestUploadOnloadstart },
    { "onprogress", DontDelete, (intptr_t)jsXMLHttpRequestUploadOnprogress, (intptr_t)setJSXMLHttpRequestUploadOnprogress },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsXMLHttpRequestUploadConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSXMLHttpRequestUploadTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSXMLHttpRequestUploadTableValues, 0 };
#else
    { 16, 15, JSXMLHttpRequestUploadTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSXMLHttpRequestUploadConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSXMLHttpRequestUploadConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSXMLHttpRequestUploadConstructorTableValues, 0 };
#else
    { 1, 0, JSXMLHttpRequestUploadConstructorTableValues, 0 };
#endif

class JSXMLHttpRequestUploadConstructor : public DOMConstructorObject {
public:
    JSXMLHttpRequestUploadConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSXMLHttpRequestUploadConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSXMLHttpRequestUploadPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSXMLHttpRequestUploadConstructor::s_info = { "XMLHttpRequestUploadConstructor", 0, &JSXMLHttpRequestUploadConstructorTable, 0 };

bool JSXMLHttpRequestUploadConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXMLHttpRequestUploadConstructor, DOMObject>(exec, &JSXMLHttpRequestUploadConstructorTable, this, propertyName, slot);
}

bool JSXMLHttpRequestUploadConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSXMLHttpRequestUploadConstructor, DOMObject>(exec, &JSXMLHttpRequestUploadConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSXMLHttpRequestUploadPrototypeTableValues[4] =
{
    { "addEventListener", DontDelete|Function, (intptr_t)jsXMLHttpRequestUploadPrototypeFunctionAddEventListener, (intptr_t)3 },
    { "removeEventListener", DontDelete|Function, (intptr_t)jsXMLHttpRequestUploadPrototypeFunctionRemoveEventListener, (intptr_t)3 },
    { "dispatchEvent", DontDelete|Function, (intptr_t)jsXMLHttpRequestUploadPrototypeFunctionDispatchEvent, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSXMLHttpRequestUploadPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSXMLHttpRequestUploadPrototypeTableValues, 0 };
#else
    { 8, 7, JSXMLHttpRequestUploadPrototypeTableValues, 0 };
#endif

static const HashTable* getJSXMLHttpRequestUploadPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSXMLHttpRequestUploadPrototypeTable);
}
const ClassInfo JSXMLHttpRequestUploadPrototype::s_info = { "XMLHttpRequestUploadPrototype", 0, 0, getJSXMLHttpRequestUploadPrototypeTable };

JSObject* JSXMLHttpRequestUploadPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXMLHttpRequestUpload>(exec, globalObject);
}

bool JSXMLHttpRequestUploadPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSXMLHttpRequestUploadPrototypeTable(exec), this, propertyName, slot);
}

bool JSXMLHttpRequestUploadPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, getJSXMLHttpRequestUploadPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSXMLHttpRequestUploadTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSXMLHttpRequestUploadTable);
}
const ClassInfo JSXMLHttpRequestUpload::s_info = { "XMLHttpRequestUpload", 0, 0, getJSXMLHttpRequestUploadTable };

JSXMLHttpRequestUpload::JSXMLHttpRequestUpload(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<XMLHttpRequestUpload> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSXMLHttpRequestUpload::~JSXMLHttpRequestUpload()
{
    impl()->invalidateEventListeners();
    forgetDOMObject(*Heap::heap(this)->globalData(), impl());
}

JSObject* JSXMLHttpRequestUpload::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSXMLHttpRequestUploadPrototype(JSXMLHttpRequestUploadPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSXMLHttpRequestUpload::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXMLHttpRequestUpload, Base>(exec, getJSXMLHttpRequestUploadTable(exec), this, propertyName, slot);
}

bool JSXMLHttpRequestUpload::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSXMLHttpRequestUpload, Base>(exec, getJSXMLHttpRequestUploadTable(exec), this, propertyName, descriptor);
}

JSValue jsXMLHttpRequestUploadOnabort(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSXMLHttpRequestUpload* castedThis = static_cast<JSXMLHttpRequestUpload*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    if (EventListener* listener = imp->onabort()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsXMLHttpRequestUploadOnerror(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSXMLHttpRequestUpload* castedThis = static_cast<JSXMLHttpRequestUpload*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    if (EventListener* listener = imp->onerror()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsXMLHttpRequestUploadOnload(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSXMLHttpRequestUpload* castedThis = static_cast<JSXMLHttpRequestUpload*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    if (EventListener* listener = imp->onload()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsXMLHttpRequestUploadOnloadstart(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSXMLHttpRequestUpload* castedThis = static_cast<JSXMLHttpRequestUpload*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    if (EventListener* listener = imp->onloadstart()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsXMLHttpRequestUploadOnprogress(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSXMLHttpRequestUpload* castedThis = static_cast<JSXMLHttpRequestUpload*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(castedThis->impl());
    if (EventListener* listener = imp->onprogress()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsXMLHttpRequestUploadConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSXMLHttpRequestUpload* domObject = static_cast<JSXMLHttpRequestUpload*>(asObject(slot.slotBase()));
    return JSXMLHttpRequestUpload::getConstructor(exec, domObject->globalObject());
}
void JSXMLHttpRequestUpload::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSXMLHttpRequestUpload, Base>(exec, propertyName, value, getJSXMLHttpRequestUploadTable(exec), this, slot);
}

void setJSXMLHttpRequestUploadOnabort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnabort(globalObject->createJSAttributeEventListener(value));
}

void setJSXMLHttpRequestUploadOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnerror(globalObject->createJSAttributeEventListener(value));
}

void setJSXMLHttpRequestUploadOnload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnload(globalObject->createJSAttributeEventListener(value));
}

void setJSXMLHttpRequestUploadOnloadstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnloadstart(globalObject->createJSAttributeEventListener(value));
}

void setJSXMLHttpRequestUploadOnprogress(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnprogress(globalObject->createJSAttributeEventListener(value));
}

JSValue JSXMLHttpRequestUpload::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXMLHttpRequestUploadConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsXMLHttpRequestUploadPrototypeFunctionAddEventListener(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSXMLHttpRequestUpload::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequestUpload* castedThisObj = static_cast<JSXMLHttpRequestUpload*>(asObject(thisValue));
    return castedThisObj->addEventListener(exec, args);
}

JSValue JSC_HOST_CALL jsXMLHttpRequestUploadPrototypeFunctionRemoveEventListener(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSXMLHttpRequestUpload::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequestUpload* castedThisObj = static_cast<JSXMLHttpRequestUpload*>(asObject(thisValue));
    return castedThisObj->removeEventListener(exec, args);
}

JSValue JSC_HOST_CALL jsXMLHttpRequestUploadPrototypeFunctionDispatchEvent(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSXMLHttpRequestUpload::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequestUpload* castedThisObj = static_cast<JSXMLHttpRequestUpload*>(asObject(thisValue));
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Event* evt = toEvent(args.at(0));


    JSC::JSValue result = jsBoolean(imp->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return result;
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, XMLHttpRequestUpload* object)
{
    return getDOMObjectWrapper<JSXMLHttpRequestUpload>(exec, globalObject, object);
}
XMLHttpRequestUpload* toXMLHttpRequestUpload(JSC::JSValue value)
{
    return value.inherits(&JSXMLHttpRequestUpload::s_info) ? static_cast<JSXMLHttpRequestUpload*>(asObject(value))->impl() : 0;
}

}
