/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSMediaError.h"

#include "MediaError.h"
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMediaError);

/* Hash table */

static const HashTableValue JSMediaErrorTableValues[3] =
{
    { "code", DontDelete|ReadOnly, (intptr_t)jsMediaErrorCode, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsMediaErrorConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSMediaErrorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSMediaErrorTableValues, 0 };
#else
    { 5, 3, JSMediaErrorTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSMediaErrorConstructorTableValues[5] =
{
    { "MEDIA_ERR_ABORTED", DontDelete|ReadOnly, (intptr_t)jsMediaErrorMEDIA_ERR_ABORTED, (intptr_t)0 },
    { "MEDIA_ERR_NETWORK", DontDelete|ReadOnly, (intptr_t)jsMediaErrorMEDIA_ERR_NETWORK, (intptr_t)0 },
    { "MEDIA_ERR_DECODE", DontDelete|ReadOnly, (intptr_t)jsMediaErrorMEDIA_ERR_DECODE, (intptr_t)0 },
    { "MEDIA_ERR_SRC_NOT_SUPPORTED", DontDelete|ReadOnly, (intptr_t)jsMediaErrorMEDIA_ERR_SRC_NOT_SUPPORTED, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSMediaErrorConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSMediaErrorConstructorTableValues, 0 };
#else
    { 9, 7, JSMediaErrorConstructorTableValues, 0 };
#endif

class JSMediaErrorConstructor : public DOMConstructorObject {
public:
    JSMediaErrorConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSMediaErrorConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSMediaErrorPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSMediaErrorConstructor::s_info = { "MediaErrorConstructor", 0, &JSMediaErrorConstructorTable, 0 };

bool JSMediaErrorConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaErrorConstructor, DOMObject>(exec, &JSMediaErrorConstructorTable, this, propertyName, slot);
}

bool JSMediaErrorConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMediaErrorConstructor, DOMObject>(exec, &JSMediaErrorConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSMediaErrorPrototypeTableValues[5] =
{
    { "MEDIA_ERR_ABORTED", DontDelete|ReadOnly, (intptr_t)jsMediaErrorMEDIA_ERR_ABORTED, (intptr_t)0 },
    { "MEDIA_ERR_NETWORK", DontDelete|ReadOnly, (intptr_t)jsMediaErrorMEDIA_ERR_NETWORK, (intptr_t)0 },
    { "MEDIA_ERR_DECODE", DontDelete|ReadOnly, (intptr_t)jsMediaErrorMEDIA_ERR_DECODE, (intptr_t)0 },
    { "MEDIA_ERR_SRC_NOT_SUPPORTED", DontDelete|ReadOnly, (intptr_t)jsMediaErrorMEDIA_ERR_SRC_NOT_SUPPORTED, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSMediaErrorPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSMediaErrorPrototypeTableValues, 0 };
#else
    { 9, 7, JSMediaErrorPrototypeTableValues, 0 };
#endif

const ClassInfo JSMediaErrorPrototype::s_info = { "MediaErrorPrototype", 0, &JSMediaErrorPrototypeTable, 0 };

JSObject* JSMediaErrorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaError>(exec, globalObject);
}

bool JSMediaErrorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaErrorPrototype, JSObject>(exec, &JSMediaErrorPrototypeTable, this, propertyName, slot);
}

bool JSMediaErrorPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMediaErrorPrototype, JSObject>(exec, &JSMediaErrorPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSMediaError::s_info = { "MediaError", 0, &JSMediaErrorTable, 0 };

JSMediaError::JSMediaError(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<MediaError> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSMediaError::~JSMediaError()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), impl());
}

JSObject* JSMediaError::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSMediaErrorPrototype(JSMediaErrorPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSMediaError::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaError, Base>(exec, &JSMediaErrorTable, this, propertyName, slot);
}

bool JSMediaError::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMediaError, Base>(exec, &JSMediaErrorTable, this, propertyName, descriptor);
}

JSValue jsMediaErrorCode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMediaError* castedThis = static_cast<JSMediaError*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    MediaError* imp = static_cast<MediaError*>(castedThis->impl());
    return jsNumber(exec, imp->code());
}

JSValue jsMediaErrorConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMediaError* domObject = static_cast<JSMediaError*>(asObject(slot.slotBase()));
    return JSMediaError::getConstructor(exec, domObject->globalObject());
}
JSValue JSMediaError::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaErrorConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsMediaErrorMEDIA_ERR_ABORTED(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsMediaErrorMEDIA_ERR_NETWORK(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue jsMediaErrorMEDIA_ERR_DECODE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValue jsMediaErrorMEDIA_ERR_SRC_NOT_SUPPORTED(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(4));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, MediaError* object)
{
    return getDOMObjectWrapper<JSMediaError>(exec, globalObject, object);
}
MediaError* toMediaError(JSC::JSValue value)
{
    return value.inherits(&JSMediaError::s_info) ? static_cast<JSMediaError*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(VIDEO)
