/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_SOCKETS)

#include "JSWebSocket.h"

#include "Event.h"
#include "EventListener.h"
#include "Frame.h"
#include "JSDOMGlobalObject.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "KURL.h"
#include "RegisteredEventListener.h"
#include "WebSocket.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebSocket);

/* Hash table */

static const HashTableValue JSWebSocketTableValues[7] =
{
    { "URL", DontDelete|ReadOnly, (intptr_t)jsWebSocketURL, (intptr_t)0 },
    { "readyState", DontDelete|ReadOnly, (intptr_t)jsWebSocketReadyState, (intptr_t)0 },
    { "bufferedAmount", DontDelete|ReadOnly, (intptr_t)jsWebSocketBufferedAmount, (intptr_t)0 },
    { "onopen", DontDelete, (intptr_t)jsWebSocketOnopen, (intptr_t)setJSWebSocketOnopen },
    { "onmessage", DontDelete, (intptr_t)jsWebSocketOnmessage, (intptr_t)setJSWebSocketOnmessage },
    { "onclose", DontDelete, (intptr_t)jsWebSocketOnclose, (intptr_t)setJSWebSocketOnclose },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSWebSocketTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSWebSocketTableValues, 0 };
#else
    { 17, 15, JSWebSocketTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSWebSocketPrototypeTableValues[9] =
{
    { "CONNECTING", DontDelete|ReadOnly, (intptr_t)jsWebSocketCONNECTING, (intptr_t)0 },
    { "OPEN", DontDelete|ReadOnly, (intptr_t)jsWebSocketOPEN, (intptr_t)0 },
    { "CLOSED", DontDelete|ReadOnly, (intptr_t)jsWebSocketCLOSED, (intptr_t)0 },
    { "send", DontDelete|Function, (intptr_t)jsWebSocketPrototypeFunctionSend, (intptr_t)1 },
    { "close", DontDelete|Function, (intptr_t)jsWebSocketPrototypeFunctionClose, (intptr_t)0 },
    { "addEventListener", DontDelete|Function, (intptr_t)jsWebSocketPrototypeFunctionAddEventListener, (intptr_t)3 },
    { "removeEventListener", DontDelete|Function, (intptr_t)jsWebSocketPrototypeFunctionRemoveEventListener, (intptr_t)3 },
    { "dispatchEvent", DontDelete|Function, (intptr_t)jsWebSocketPrototypeFunctionDispatchEvent, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSWebSocketPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSWebSocketPrototypeTableValues, 0 };
#else
    { 17, 15, JSWebSocketPrototypeTableValues, 0 };
#endif

static const HashTable* getJSWebSocketPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSWebSocketPrototypeTable);
}
const ClassInfo JSWebSocketPrototype::s_info = { "WebSocketPrototype", 0, 0, getJSWebSocketPrototypeTable };

JSObject* JSWebSocketPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebSocket>(exec, globalObject);
}

bool JSWebSocketPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSWebSocketPrototype, JSObject>(exec, getJSWebSocketPrototypeTable(exec), this, propertyName, slot);
}

bool JSWebSocketPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSWebSocketPrototype, JSObject>(exec, getJSWebSocketPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSWebSocketTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSWebSocketTable);
}
const ClassInfo JSWebSocket::s_info = { "WebSocket", 0, 0, getJSWebSocketTable };

JSWebSocket::JSWebSocket(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebSocket> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSWebSocket::~JSWebSocket()
{
    impl()->invalidateEventListeners();
    forgetDOMObject(*Heap::heap(this)->globalData(), impl());
}

void JSWebSocket::markChildren(MarkStack& markStack)
{
    Base::markChildren(markStack);
    impl()->markEventListeners(markStack);
}

JSObject* JSWebSocket::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSWebSocketPrototype(JSWebSocketPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSWebSocket::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebSocket, Base>(exec, getJSWebSocketTable(exec), this, propertyName, slot);
}

bool JSWebSocket::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebSocket, Base>(exec, getJSWebSocketTable(exec), this, propertyName, descriptor);
}

JSValue jsWebSocketURL(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWebSocket* castedThis = static_cast<JSWebSocket*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WebSocket* imp = static_cast<WebSocket*>(castedThis->impl());
    return jsString(exec, imp->url());
}

JSValue jsWebSocketReadyState(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWebSocket* castedThis = static_cast<JSWebSocket*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WebSocket* imp = static_cast<WebSocket*>(castedThis->impl());
    return jsNumber(exec, imp->readyState());
}

JSValue jsWebSocketBufferedAmount(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWebSocket* castedThis = static_cast<JSWebSocket*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WebSocket* imp = static_cast<WebSocket*>(castedThis->impl());
    return jsNumber(exec, imp->bufferedAmount());
}

JSValue jsWebSocketOnopen(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWebSocket* castedThis = static_cast<JSWebSocket*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WebSocket* imp = static_cast<WebSocket*>(castedThis->impl());
    if (EventListener* listener = imp->onopen()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsWebSocketOnmessage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWebSocket* castedThis = static_cast<JSWebSocket*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WebSocket* imp = static_cast<WebSocket*>(castedThis->impl());
    if (EventListener* listener = imp->onmessage()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsWebSocketOnclose(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWebSocket* castedThis = static_cast<JSWebSocket*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WebSocket* imp = static_cast<WebSocket*>(castedThis->impl());
    if (EventListener* listener = imp->onclose()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

void JSWebSocket::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSWebSocket, Base>(exec, propertyName, value, getJSWebSocketTable(exec), this, slot);
}

void setJSWebSocketOnopen(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    WebSocket* imp = static_cast<WebSocket*>(static_cast<JSWebSocket*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnopen(globalObject->createJSAttributeEventListener(value));
}

void setJSWebSocketOnmessage(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    WebSocket* imp = static_cast<WebSocket*>(static_cast<JSWebSocket*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnmessage(globalObject->createJSAttributeEventListener(value));
}

void setJSWebSocketOnclose(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    WebSocket* imp = static_cast<WebSocket*>(static_cast<JSWebSocket*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnclose(globalObject->createJSAttributeEventListener(value));
}

JSValue JSC_HOST_CALL jsWebSocketPrototypeFunctionSend(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSWebSocket::s_info))
        return throwError(exec, TypeError);
    JSWebSocket* castedThisObj = static_cast<JSWebSocket*>(asObject(thisValue));
    return castedThisObj->send(exec, args);
}

JSValue JSC_HOST_CALL jsWebSocketPrototypeFunctionClose(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSWebSocket::s_info))
        return throwError(exec, TypeError);
    JSWebSocket* castedThisObj = static_cast<JSWebSocket*>(asObject(thisValue));
    WebSocket* imp = static_cast<WebSocket*>(castedThisObj->impl());

    imp->close();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsWebSocketPrototypeFunctionAddEventListener(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSWebSocket::s_info))
        return throwError(exec, TypeError);
    JSWebSocket* castedThisObj = static_cast<JSWebSocket*>(asObject(thisValue));
    return castedThisObj->addEventListener(exec, args);
}

JSValue JSC_HOST_CALL jsWebSocketPrototypeFunctionRemoveEventListener(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSWebSocket::s_info))
        return throwError(exec, TypeError);
    JSWebSocket* castedThisObj = static_cast<JSWebSocket*>(asObject(thisValue));
    return castedThisObj->removeEventListener(exec, args);
}

JSValue JSC_HOST_CALL jsWebSocketPrototypeFunctionDispatchEvent(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSWebSocket::s_info))
        return throwError(exec, TypeError);
    JSWebSocket* castedThisObj = static_cast<JSWebSocket*>(asObject(thisValue));
    WebSocket* imp = static_cast<WebSocket*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Event* evt = toEvent(args.at(0));


    JSC::JSValue result = jsBoolean(imp->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return result;
}

// Constant getters

JSValue jsWebSocketCONNECTING(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsWebSocketOPEN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsWebSocketCLOSED(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebSocket* object)
{
    return getDOMObjectWrapper<JSWebSocket>(exec, globalObject, object);
}
WebSocket* toWebSocket(JSC::JSValue value)
{
    return value.inherits(&JSWebSocket::s_info) ? static_cast<JSWebSocket*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEB_SOCKETS)
