/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPathSegMovetoRel.h"

#include "SVGPathSegMoveto.h"
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGPathSegMovetoRel);

/* Hash table */

static const HashTableValue JSSVGPathSegMovetoRelTableValues[3] =
{
    { "x", DontDelete, (intptr_t)jsSVGPathSegMovetoRelX, (intptr_t)setJSSVGPathSegMovetoRelX },
    { "y", DontDelete, (intptr_t)jsSVGPathSegMovetoRelY, (intptr_t)setJSSVGPathSegMovetoRelY },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGPathSegMovetoRelTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1, JSSVGPathSegMovetoRelTableValues, 0 };
#else
    { 4, 3, JSSVGPathSegMovetoRelTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGPathSegMovetoRelPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGPathSegMovetoRelPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGPathSegMovetoRelPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGPathSegMovetoRelPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGPathSegMovetoRelPrototype::s_info = { "SVGPathSegMovetoRelPrototype", 0, &JSSVGPathSegMovetoRelPrototypeTable, 0 };

JSObject* JSSVGPathSegMovetoRelPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPathSegMovetoRel>(exec, globalObject);
}

const ClassInfo JSSVGPathSegMovetoRel::s_info = { "SVGPathSegMovetoRel", &JSSVGPathSeg::s_info, &JSSVGPathSegMovetoRelTable, 0 };

JSSVGPathSegMovetoRel::JSSVGPathSegMovetoRel(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPathSegMovetoRel> impl, SVGElement* context)
    : JSSVGPathSeg(structure, globalObject, impl, context)
{
}

JSObject* JSSVGPathSegMovetoRel::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGPathSegMovetoRelPrototype(JSSVGPathSegMovetoRelPrototype::createStructure(JSSVGPathSegPrototype::self(exec, globalObject)));
}

bool JSSVGPathSegMovetoRel::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPathSegMovetoRel, Base>(exec, &JSSVGPathSegMovetoRelTable, this, propertyName, slot);
}

bool JSSVGPathSegMovetoRel::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPathSegMovetoRel, Base>(exec, &JSSVGPathSegMovetoRelTable, this, propertyName, descriptor);
}

JSValue jsSVGPathSegMovetoRelX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathSegMovetoRel* castedThis = static_cast<JSSVGPathSegMovetoRel*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathSegMovetoRel* imp = static_cast<SVGPathSegMovetoRel*>(castedThis->impl());
    return jsNumber(exec, imp->x());
}

JSValue jsSVGPathSegMovetoRelY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathSegMovetoRel* castedThis = static_cast<JSSVGPathSegMovetoRel*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathSegMovetoRel* imp = static_cast<SVGPathSegMovetoRel*>(castedThis->impl());
    return jsNumber(exec, imp->y());
}

void JSSVGPathSegMovetoRel::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGPathSegMovetoRel, Base>(exec, propertyName, value, &JSSVGPathSegMovetoRelTable, this, slot);
}

void setJSSVGPathSegMovetoRelX(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGPathSegMovetoRel* imp = static_cast<SVGPathSegMovetoRel*>(static_cast<JSSVGPathSegMovetoRel*>(thisObject)->impl());
    imp->setX(value.toFloat(exec));
    if (static_cast<JSSVGPathSegMovetoRel*>(thisObject)->context())
        static_cast<JSSVGPathSegMovetoRel*>(thisObject)->context()->svgAttributeChanged(static_cast<JSSVGPathSegMovetoRel*>(thisObject)->impl()->associatedAttributeName());
}

void setJSSVGPathSegMovetoRelY(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGPathSegMovetoRel* imp = static_cast<SVGPathSegMovetoRel*>(static_cast<JSSVGPathSegMovetoRel*>(thisObject)->impl());
    imp->setY(value.toFloat(exec));
    if (static_cast<JSSVGPathSegMovetoRel*>(thisObject)->context())
        static_cast<JSSVGPathSegMovetoRel*>(thisObject)->context()->svgAttributeChanged(static_cast<JSSVGPathSegMovetoRel*>(thisObject)->impl()->associatedAttributeName());
}


}

#endif // ENABLE(SVG)
