/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPatternElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGPatternElement.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGPatternElement);

/* Hash table */

static const HashTableValue JSSVGPatternElementTableValues[19] =
{
    { "patternUnits", DontDelete|ReadOnly, (intptr_t)jsSVGPatternElementPatternUnits, (intptr_t)0 },
    { "patternContentUnits", DontDelete|ReadOnly, (intptr_t)jsSVGPatternElementPatternContentUnits, (intptr_t)0 },
    { "patternTransform", DontDelete|ReadOnly, (intptr_t)jsSVGPatternElementPatternTransform, (intptr_t)0 },
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGPatternElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGPatternElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGPatternElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGPatternElementHeight, (intptr_t)0 },
    { "href", DontDelete|ReadOnly, (intptr_t)jsSVGPatternElementHref, (intptr_t)0 },
    { "requiredFeatures", DontDelete|ReadOnly, (intptr_t)jsSVGPatternElementRequiredFeatures, (intptr_t)0 },
    { "requiredExtensions", DontDelete|ReadOnly, (intptr_t)jsSVGPatternElementRequiredExtensions, (intptr_t)0 },
    { "systemLanguage", DontDelete|ReadOnly, (intptr_t)jsSVGPatternElementSystemLanguage, (intptr_t)0 },
    { "xmllang", DontDelete, (intptr_t)jsSVGPatternElementXmllang, (intptr_t)setJSSVGPatternElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)jsSVGPatternElementXmlspace, (intptr_t)setJSSVGPatternElementXmlspace },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)jsSVGPatternElementExternalResourcesRequired, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGPatternElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGPatternElementStyle, (intptr_t)0 },
    { "viewBox", DontDelete|ReadOnly, (intptr_t)jsSVGPatternElementViewBox, (intptr_t)0 },
    { "preserveAspectRatio", DontDelete|ReadOnly, (intptr_t)jsSVGPatternElementPreserveAspectRatio, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGPatternElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSSVGPatternElementTableValues, 0 };
#else
    { 68, 63, JSSVGPatternElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGPatternElementPrototypeTableValues[3] =
{
    { "hasExtension", DontDelete|Function, (intptr_t)jsSVGPatternElementPrototypeFunctionHasExtension, (intptr_t)1 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGPatternElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGPatternElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1, JSSVGPatternElementPrototypeTableValues, 0 };
#else
    { 4, 3, JSSVGPatternElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGPatternElementPrototype::s_info = { "SVGPatternElementPrototype", 0, &JSSVGPatternElementPrototypeTable, 0 };

JSObject* JSSVGPatternElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPatternElement>(exec, globalObject);
}

bool JSSVGPatternElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGPatternElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGPatternElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGPatternElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGPatternElement::s_info = { "SVGPatternElement", &JSSVGElement::s_info, &JSSVGPatternElementTable, 0 };

JSSVGPatternElement::JSSVGPatternElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPatternElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGPatternElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGPatternElementPrototype(JSSVGPatternElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGPatternElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPatternElement, Base>(exec, &JSSVGPatternElementTable, this, propertyName, slot);
}

bool JSSVGPatternElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPatternElement, Base>(exec, &JSSVGPatternElementTable, this, propertyName, descriptor);
}

JSValue jsSVGPatternElementPatternUnits(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->patternUnitsAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGPatternElementPatternContentUnits(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->patternContentUnitsAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGPatternElementPatternTransform(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = imp->patternTransformAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGPatternElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGPatternElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGPatternElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGPatternElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGPatternElementHref(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->hrefAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGPatternElementRequiredFeatures(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredFeatures()), imp);
}

JSValue jsSVGPatternElementRequiredExtensions(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredExtensions()), imp);
}

JSValue jsSVGPatternElementSystemLanguage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->systemLanguage()), imp);
}

JSValue jsSVGPatternElementXmllang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    return jsString(exec, imp->xmllang());
}

JSValue jsSVGPatternElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    return jsString(exec, imp->xmlspace());
}

JSValue jsSVGPatternElementExternalResourcesRequired(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGPatternElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGPatternElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
}

JSValue jsSVGPatternElementViewBox(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    RefPtr<SVGAnimatedRect> obj = imp->viewBoxAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGPatternElementPreserveAspectRatio(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPatternElement* castedThis = static_cast<JSSVGPatternElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThis->impl());
    RefPtr<SVGAnimatedPreserveAspectRatio> obj = imp->preserveAspectRatioAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

void JSSVGPatternElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGPatternElement, Base>(exec, propertyName, value, &JSSVGPatternElementTable, this, slot);
}

void setJSSVGPatternElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(static_cast<JSSVGPatternElement*>(thisObject)->impl());
    imp->setXmllang(value.toString(exec));
}

void setJSSVGPatternElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(static_cast<JSSVGPatternElement*>(thisObject)->impl());
    imp->setXmlspace(value.toString(exec));
}

JSValue JSC_HOST_CALL jsSVGPatternElementPrototypeFunctionHasExtension(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPatternElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPatternElement* castedThisObj = static_cast<JSSVGPatternElement*>(asObject(thisValue));
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThisObj->impl());
    const UString& extension = args.at(0).toString(exec);


    JSC::JSValue result = jsBoolean(imp->hasExtension(extension));
    return result;
}

JSValue JSC_HOST_CALL jsSVGPatternElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPatternElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPatternElement* castedThisObj = static_cast<JSSVGPatternElement*>(asObject(thisValue));
    SVGPatternElement* imp = static_cast<SVGPatternElement*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}


}

#endif // ENABLE(SVG)
