/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG) && ENABLE(FILTERS)

#include "JSSVGFEMergeElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEMergeElement.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFEMergeElement);

/* Hash table */

static const HashTableValue JSSVGFEMergeElementTableValues[8] =
{
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGFEMergeElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGFEMergeElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGFEMergeElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGFEMergeElementHeight, (intptr_t)0 },
    { "result", DontDelete|ReadOnly, (intptr_t)jsSVGFEMergeElementResult, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGFEMergeElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGFEMergeElementStyle, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFEMergeElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSSVGFEMergeElementTableValues, 0 };
#else
    { 17, 15, JSSVGFEMergeElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGFEMergeElementPrototypeTableValues[2] =
{
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGFEMergeElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFEMergeElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGFEMergeElementPrototypeTableValues, 0 };
#else
    { 2, 1, JSSVGFEMergeElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGFEMergeElementPrototype::s_info = { "SVGFEMergeElementPrototype", 0, &JSSVGFEMergeElementPrototypeTable, 0 };

JSObject* JSSVGFEMergeElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEMergeElement>(exec, globalObject);
}

bool JSSVGFEMergeElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGFEMergeElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGFEMergeElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGFEMergeElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGFEMergeElement::s_info = { "SVGFEMergeElement", &JSSVGElement::s_info, &JSSVGFEMergeElementTable, 0 };

JSSVGFEMergeElement::JSSVGFEMergeElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFEMergeElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGFEMergeElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGFEMergeElementPrototype(JSSVGFEMergeElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEMergeElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEMergeElement, Base>(exec, &JSSVGFEMergeElementTable, this, propertyName, slot);
}

bool JSSVGFEMergeElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEMergeElement, Base>(exec, &JSSVGFEMergeElementTable, this, propertyName, descriptor);
}

JSValue jsSVGFEMergeElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEMergeElement* castedThis = static_cast<JSSVGFEMergeElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* imp = static_cast<SVGFEMergeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFEMergeElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEMergeElement* castedThis = static_cast<JSSVGFEMergeElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* imp = static_cast<SVGFEMergeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFEMergeElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEMergeElement* castedThis = static_cast<JSSVGFEMergeElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* imp = static_cast<SVGFEMergeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFEMergeElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEMergeElement* castedThis = static_cast<JSSVGFEMergeElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* imp = static_cast<SVGFEMergeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFEMergeElementResult(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEMergeElement* castedThis = static_cast<JSSVGFEMergeElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* imp = static_cast<SVGFEMergeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->resultAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFEMergeElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEMergeElement* castedThis = static_cast<JSSVGFEMergeElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* imp = static_cast<SVGFEMergeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFEMergeElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEMergeElement* castedThis = static_cast<JSSVGFEMergeElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* imp = static_cast<SVGFEMergeElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
}

JSValue JSC_HOST_CALL jsSVGFEMergeElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGFEMergeElement::s_info))
        return throwError(exec, TypeError);
    JSSVGFEMergeElement* castedThisObj = static_cast<JSSVGFEMergeElement*>(asObject(thisValue));
    SVGFEMergeElement* imp = static_cast<SVGFEMergeElement*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}


}

#endif // ENABLE(SVG) && ENABLE(FILTERS)
