/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSMediaRule.h"

#include "CSSMediaRule.h"
#include "CSSRuleList.h"
#include "JSCSSRuleList.h"
#include "JSMediaList.h"
#include "MediaList.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCSSMediaRule);

/* Hash table */

static const HashTableValue JSCSSMediaRuleTableValues[4] =
{
    { "media", DontDelete|ReadOnly, (intptr_t)jsCSSMediaRuleMedia, (intptr_t)0 },
    { "cssRules", DontDelete|ReadOnly, (intptr_t)jsCSSMediaRuleCssRules, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsCSSMediaRuleConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCSSMediaRuleTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSCSSMediaRuleTableValues, 0 };
#else
    { 8, 7, JSCSSMediaRuleTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSCSSMediaRuleConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCSSMediaRuleConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCSSMediaRuleConstructorTableValues, 0 };
#else
    { 1, 0, JSCSSMediaRuleConstructorTableValues, 0 };
#endif

class JSCSSMediaRuleConstructor : public DOMConstructorObject {
public:
    JSCSSMediaRuleConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSCSSMediaRuleConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSCSSMediaRulePrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSCSSMediaRuleConstructor::s_info = { "CSSMediaRuleConstructor", 0, &JSCSSMediaRuleConstructorTable, 0 };

bool JSCSSMediaRuleConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSMediaRuleConstructor, DOMObject>(exec, &JSCSSMediaRuleConstructorTable, this, propertyName, slot);
}

bool JSCSSMediaRuleConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSMediaRuleConstructor, DOMObject>(exec, &JSCSSMediaRuleConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCSSMediaRulePrototypeTableValues[3] =
{
    { "insertRule", DontDelete|Function, (intptr_t)jsCSSMediaRulePrototypeFunctionInsertRule, (intptr_t)2 },
    { "deleteRule", DontDelete|Function, (intptr_t)jsCSSMediaRulePrototypeFunctionDeleteRule, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCSSMediaRulePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1, JSCSSMediaRulePrototypeTableValues, 0 };
#else
    { 4, 3, JSCSSMediaRulePrototypeTableValues, 0 };
#endif

const ClassInfo JSCSSMediaRulePrototype::s_info = { "CSSMediaRulePrototype", 0, &JSCSSMediaRulePrototypeTable, 0 };

JSObject* JSCSSMediaRulePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSMediaRule>(exec, globalObject);
}

bool JSCSSMediaRulePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSMediaRulePrototypeTable, this, propertyName, slot);
}

bool JSCSSMediaRulePrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSCSSMediaRulePrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSCSSMediaRule::s_info = { "CSSMediaRule", &JSCSSRule::s_info, &JSCSSMediaRuleTable, 0 };

JSCSSMediaRule::JSCSSMediaRule(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<CSSMediaRule> impl)
    : JSCSSRule(structure, globalObject, impl)
{
}

JSObject* JSCSSMediaRule::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSCSSMediaRulePrototype(JSCSSMediaRulePrototype::createStructure(JSCSSRulePrototype::self(exec, globalObject)));
}

bool JSCSSMediaRule::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSMediaRule, Base>(exec, &JSCSSMediaRuleTable, this, propertyName, slot);
}

bool JSCSSMediaRule::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSMediaRule, Base>(exec, &JSCSSMediaRuleTable, this, propertyName, descriptor);
}

JSValue jsCSSMediaRuleMedia(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSCSSMediaRule* castedThis = static_cast<JSCSSMediaRule*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    CSSMediaRule* imp = static_cast<CSSMediaRule*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->media()));
}

JSValue jsCSSMediaRuleCssRules(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSCSSMediaRule* castedThis = static_cast<JSCSSMediaRule*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    CSSMediaRule* imp = static_cast<CSSMediaRule*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->cssRules()));
}

JSValue jsCSSMediaRuleConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSCSSMediaRule* domObject = static_cast<JSCSSMediaRule*>(asObject(slot.slotBase()));
    return JSCSSMediaRule::getConstructor(exec, domObject->globalObject());
}
JSValue JSCSSMediaRule::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSMediaRuleConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsCSSMediaRulePrototypeFunctionInsertRule(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCSSMediaRule::s_info))
        return throwError(exec, TypeError);
    JSCSSMediaRule* castedThisObj = static_cast<JSCSSMediaRule*>(asObject(thisValue));
    CSSMediaRule* imp = static_cast<CSSMediaRule*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& rule = args.at(0).toString(exec);
    unsigned index = args.at(1).toInt32(exec);


    JSC::JSValue result = jsNumber(exec, imp->insertRule(rule, index, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsCSSMediaRulePrototypeFunctionDeleteRule(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCSSMediaRule::s_info))
        return throwError(exec, TypeError);
    JSCSSMediaRule* castedThisObj = static_cast<JSCSSMediaRule*>(asObject(thisValue));
    CSSMediaRule* imp = static_cast<CSSMediaRule*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args.at(0).toInt32(exec);

    imp->deleteRule(index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}


}
