/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(3D_CANVAS)

#include "JSCanvasFloatArray.h"

#include "CanvasFloatArray.h"
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCanvasFloatArray);

/* Hash table for prototype */

static const HashTableValue JSCanvasFloatArrayPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCanvasFloatArrayPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCanvasFloatArrayPrototypeTableValues, 0 };
#else
    { 1, 0, JSCanvasFloatArrayPrototypeTableValues, 0 };
#endif

const ClassInfo JSCanvasFloatArrayPrototype::s_info = { "CanvasFloatArrayPrototype", 0, &JSCanvasFloatArrayPrototypeTable, 0 };

JSObject* JSCanvasFloatArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCanvasFloatArray>(exec, globalObject);
}

const ClassInfo JSCanvasFloatArray::s_info = { "CanvasFloatArray", &JSCanvasArray::s_info, 0, 0 };

JSCanvasFloatArray::JSCanvasFloatArray(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<CanvasFloatArray> impl)
    : JSCanvasArray(structure, globalObject, impl)
{
}

JSObject* JSCanvasFloatArray::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSCanvasFloatArrayPrototype(JSCanvasFloatArrayPrototype::createStructure(JSCanvasArrayPrototype::self(exec, globalObject)));
}

bool JSCanvasFloatArray::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<CanvasFloatArray*>(impl())->length()) {
        slot.setValue(getByIndex(exec, index));
        return true;
    }
    return Base::getOwnPropertySlot(exec, propertyName, slot);
}

bool JSCanvasFloatArray::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<CanvasFloatArray*>(impl())->length()) {
        descriptor.setDescriptor(getByIndex(exec, index), DontDelete);
        return true;
    }
    return Base::getOwnPropertyDescriptor(exec, propertyName, descriptor);
}

bool JSCanvasFloatArray::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<CanvasFloatArray*>(impl())->length()) {
        slot.setValue(getByIndex(exec, propertyName));
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

void JSCanvasFloatArray::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok) {
        indexSetter(exec, index, value);
        return;
    }
    Base::put(exec, propertyName, value, slot);
}

void JSCanvasFloatArray::put(ExecState* exec, unsigned propertyName, JSValue value)
{
    indexSetter(exec, propertyName, value);
    return;
}

void JSCanvasFloatArray::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<CanvasFloatArray*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames);
}


JSValue JSCanvasFloatArray::getByIndex(ExecState* exec, unsigned index)
{
    return jsNumber(exec, static_cast<CanvasFloatArray*>(impl())->item(index));
}
CanvasFloatArray* toCanvasFloatArray(JSC::JSValue value)
{
    return value.inherits(&JSCanvasFloatArray::s_info) ? static_cast<JSCanvasFloatArray*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(3D_CANVAS)
