/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLObjectElement.h"

#include "AtomicString.h"
#include "Document.h"
#include "HTMLFormElement.h"
#include "HTMLNames.h"
#include "HTMLObjectElement.h"
#include "JSDOMBinding.h"
#include "JSDocument.h"
#include "JSHTMLFormElement.h"
#include "JSHTMLObjectElementCustom.h"
#include "JSSVGDocument.h"
#include "KURL.h"
#include "SVGDocument.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLObjectElement);

/* Hash table */

static const HashTableValue JSHTMLObjectElementTableValues[21] =
{
    { "form", DontDelete|ReadOnly, (intptr_t)jsHTMLObjectElementForm, (intptr_t)0 },
    { "code", DontDelete, (intptr_t)jsHTMLObjectElementCode, (intptr_t)setJSHTMLObjectElementCode },
    { "align", DontDelete, (intptr_t)jsHTMLObjectElementAlign, (intptr_t)setJSHTMLObjectElementAlign },
    { "archive", DontDelete, (intptr_t)jsHTMLObjectElementArchive, (intptr_t)setJSHTMLObjectElementArchive },
    { "border", DontDelete, (intptr_t)jsHTMLObjectElementBorder, (intptr_t)setJSHTMLObjectElementBorder },
    { "codeBase", DontDelete, (intptr_t)jsHTMLObjectElementCodeBase, (intptr_t)setJSHTMLObjectElementCodeBase },
    { "codeType", DontDelete, (intptr_t)jsHTMLObjectElementCodeType, (intptr_t)setJSHTMLObjectElementCodeType },
    { "data", DontDelete, (intptr_t)jsHTMLObjectElementData, (intptr_t)setJSHTMLObjectElementData },
    { "declare", DontDelete, (intptr_t)jsHTMLObjectElementDeclare, (intptr_t)setJSHTMLObjectElementDeclare },
    { "height", DontDelete, (intptr_t)jsHTMLObjectElementHeight, (intptr_t)setJSHTMLObjectElementHeight },
    { "hspace", DontDelete, (intptr_t)jsHTMLObjectElementHspace, (intptr_t)setJSHTMLObjectElementHspace },
    { "name", DontDelete, (intptr_t)jsHTMLObjectElementName, (intptr_t)setJSHTMLObjectElementName },
    { "standby", DontDelete, (intptr_t)jsHTMLObjectElementStandby, (intptr_t)setJSHTMLObjectElementStandby },
    { "type", DontDelete, (intptr_t)jsHTMLObjectElementType, (intptr_t)setJSHTMLObjectElementType },
    { "useMap", DontDelete, (intptr_t)jsHTMLObjectElementUseMap, (intptr_t)setJSHTMLObjectElementUseMap },
    { "vspace", DontDelete, (intptr_t)jsHTMLObjectElementVspace, (intptr_t)setJSHTMLObjectElementVspace },
    { "width", DontDelete, (intptr_t)jsHTMLObjectElementWidth, (intptr_t)setJSHTMLObjectElementWidth },
    { "willValidate", DontDelete|ReadOnly, (intptr_t)jsHTMLObjectElementWillValidate, (intptr_t)0 },
    { "contentDocument", DontDelete|ReadOnly, (intptr_t)jsHTMLObjectElementContentDocument, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLObjectElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLObjectElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSHTMLObjectElementTableValues, 0 };
#else
    { 66, 63, JSHTMLObjectElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLObjectElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLObjectElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLObjectElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLObjectElementConstructorTableValues, 0 };
#endif

class JSHTMLObjectElementConstructor : public DOMConstructorObject {
public:
    JSHTMLObjectElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLObjectElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLObjectElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLObjectElementConstructor::s_info = { "HTMLObjectElementConstructor", 0, &JSHTMLObjectElementConstructorTable, 0 };

bool JSHTMLObjectElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLObjectElementConstructor, DOMObject>(exec, &JSHTMLObjectElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLObjectElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLObjectElementConstructor, DOMObject>(exec, &JSHTMLObjectElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLObjectElementPrototypeTableValues[2] =
{
    { "getSVGDocument", DontDelete|Function, (intptr_t)jsHTMLObjectElementPrototypeFunctionGetSVGDocument, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLObjectElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLObjectElementPrototypeTableValues, 0 };
#else
    { 2, 1, JSHTMLObjectElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLObjectElementPrototype::s_info = { "HTMLObjectElementPrototype", 0, &JSHTMLObjectElementPrototypeTable, 0 };

JSObject* JSHTMLObjectElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLObjectElement>(exec, globalObject);
}

bool JSHTMLObjectElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLObjectElementPrototypeTable, this, propertyName, slot);
}

bool JSHTMLObjectElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLObjectElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSHTMLObjectElement::s_info = { "HTMLObjectElement", &JSHTMLElement::s_info, &JSHTMLObjectElementTable, 0 };

JSHTMLObjectElement::JSHTMLObjectElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLObjectElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLObjectElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLObjectElementPrototype(JSHTMLObjectElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLObjectElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    if (canGetItemsForName(exec, static_cast<HTMLObjectElement*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    if (getOwnPropertySlotDelegate(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSHTMLObjectElement, Base>(exec, &JSHTMLObjectElementTable, this, propertyName, slot);
}

bool JSHTMLObjectElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    if (canGetItemsForName(exec, static_cast<HTMLObjectElement*>(impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(this, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    if (getOwnPropertyDescriptorDelegate(exec, propertyName, descriptor))
        return true;
    return getStaticValueDescriptor<JSHTMLObjectElement, Base>(exec, &JSHTMLObjectElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLObjectElementForm(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->form()));
}

JSValue jsHTMLObjectElementCode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return jsString(exec, imp->getAttribute(HTMLNames::codeAttr));
}

JSValue jsHTMLObjectElementAlign(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return jsString(exec, imp->getAttribute(HTMLNames::alignAttr));
}

JSValue jsHTMLObjectElementArchive(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return jsString(exec, imp->getAttribute(HTMLNames::archiveAttr));
}

JSValue jsHTMLObjectElementBorder(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return jsString(exec, imp->getAttribute(HTMLNames::borderAttr));
}

JSValue jsHTMLObjectElementCodeBase(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return jsString(exec, imp->getAttribute(HTMLNames::codebaseAttr));
}

JSValue jsHTMLObjectElementCodeType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return jsString(exec, imp->getAttribute(HTMLNames::codetypeAttr));
}

JSValue jsHTMLObjectElementData(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return jsString(exec, imp->getURLAttribute(HTMLNames::dataAttr));
}

JSValue jsHTMLObjectElementDeclare(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return jsBoolean(imp->declare());
}

JSValue jsHTMLObjectElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return jsString(exec, imp->getAttribute(HTMLNames::heightAttr));
}

JSValue jsHTMLObjectElementHspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return jsNumber(exec, imp->hspace());
}

JSValue jsHTMLObjectElementName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return jsString(exec, imp->getAttribute(HTMLNames::nameAttr));
}

JSValue jsHTMLObjectElementStandby(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return jsString(exec, imp->getAttribute(HTMLNames::standbyAttr));
}

JSValue jsHTMLObjectElementType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return jsString(exec, imp->getAttribute(HTMLNames::typeAttr));
}

JSValue jsHTMLObjectElementUseMap(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return jsString(exec, imp->getAttribute(HTMLNames::usemapAttr));
}

JSValue jsHTMLObjectElementVspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return jsNumber(exec, imp->vspace());
}

JSValue jsHTMLObjectElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return jsString(exec, imp->getAttribute(HTMLNames::widthAttr));
}

JSValue jsHTMLObjectElementWillValidate(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return jsBoolean(imp->willValidate());
}

JSValue jsHTMLObjectElementContentDocument(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* castedThis = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThis->impl());
    return checkNodeSecurity(exec, imp->contentDocument()) ? toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->contentDocument())) : jsUndefined();
}

JSValue jsHTMLObjectElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLObjectElement* domObject = static_cast<JSHTMLObjectElement*>(asObject(slot.slotBase()));
    return JSHTMLObjectElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLObjectElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    if (putDelegate(exec, propertyName, value, slot))
        return;
    lookupPut<JSHTMLObjectElement, Base>(exec, propertyName, value, &JSHTMLObjectElementTable, this, slot);
}

void setJSHTMLObjectElementCode(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(static_cast<JSHTMLObjectElement*>(thisObject)->impl());
    imp->setAttribute(HTMLNames::codeAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLObjectElementAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(static_cast<JSHTMLObjectElement*>(thisObject)->impl());
    imp->setAttribute(HTMLNames::alignAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLObjectElementArchive(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(static_cast<JSHTMLObjectElement*>(thisObject)->impl());
    imp->setAttribute(HTMLNames::archiveAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLObjectElementBorder(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(static_cast<JSHTMLObjectElement*>(thisObject)->impl());
    imp->setAttribute(HTMLNames::borderAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLObjectElementCodeBase(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(static_cast<JSHTMLObjectElement*>(thisObject)->impl());
    imp->setAttribute(HTMLNames::codebaseAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLObjectElementCodeType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(static_cast<JSHTMLObjectElement*>(thisObject)->impl());
    imp->setAttribute(HTMLNames::codetypeAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLObjectElementData(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(static_cast<JSHTMLObjectElement*>(thisObject)->impl());
    imp->setAttribute(HTMLNames::dataAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLObjectElementDeclare(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(static_cast<JSHTMLObjectElement*>(thisObject)->impl());
    imp->setDeclare(value.toBoolean(exec));
}

void setJSHTMLObjectElementHeight(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(static_cast<JSHTMLObjectElement*>(thisObject)->impl());
    imp->setAttribute(HTMLNames::heightAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLObjectElementHspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(static_cast<JSHTMLObjectElement*>(thisObject)->impl());
    imp->setHspace(value.toInt32(exec));
}

void setJSHTMLObjectElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(static_cast<JSHTMLObjectElement*>(thisObject)->impl());
    imp->setAttribute(HTMLNames::nameAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLObjectElementStandby(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(static_cast<JSHTMLObjectElement*>(thisObject)->impl());
    imp->setAttribute(HTMLNames::standbyAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLObjectElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(static_cast<JSHTMLObjectElement*>(thisObject)->impl());
    imp->setAttribute(HTMLNames::typeAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLObjectElementUseMap(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(static_cast<JSHTMLObjectElement*>(thisObject)->impl());
    imp->setAttribute(HTMLNames::usemapAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLObjectElementVspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(static_cast<JSHTMLObjectElement*>(thisObject)->impl());
    imp->setVspace(value.toInt32(exec));
}

void setJSHTMLObjectElementWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(static_cast<JSHTMLObjectElement*>(thisObject)->impl());
    imp->setAttribute(HTMLNames::widthAttr, valueToStringWithNullCheck(exec, value));
}

JSValue JSHTMLObjectElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLObjectElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsHTMLObjectElementPrototypeFunctionGetSVGDocument(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSHTMLObjectElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLObjectElement* castedThisObj = static_cast<JSHTMLObjectElement*>(asObject(thisValue));
    HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    if (!checkNodeSecurity(exec, imp->getSVGDocument(ec)))
        return jsUndefined();


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getSVGDocument(ec)));
    setDOMException(exec, ec);
    return result;
}


}
