/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG) && ENABLE(FILTERS)

#include "JSSVGFilterElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedInteger.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "KURL.h"
#include "SVGFilterElement.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFilterElement);

/* Hash table */

static const HashTableValue JSSVGFilterElementTableValues[15] =
{
    { "filterUnits", DontDelete|ReadOnly, (intptr_t)jsSVGFilterElementFilterUnits, (intptr_t)0 },
    { "primitiveUnits", DontDelete|ReadOnly, (intptr_t)jsSVGFilterElementPrimitiveUnits, (intptr_t)0 },
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGFilterElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGFilterElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGFilterElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGFilterElementHeight, (intptr_t)0 },
    { "filterResX", DontDelete|ReadOnly, (intptr_t)jsSVGFilterElementFilterResX, (intptr_t)0 },
    { "filterResY", DontDelete|ReadOnly, (intptr_t)jsSVGFilterElementFilterResY, (intptr_t)0 },
    { "href", DontDelete|ReadOnly, (intptr_t)jsSVGFilterElementHref, (intptr_t)0 },
    { "xmllang", DontDelete, (intptr_t)jsSVGFilterElementXmllang, (intptr_t)setJSSVGFilterElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)jsSVGFilterElementXmlspace, (intptr_t)setJSSVGFilterElementXmlspace },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)jsSVGFilterElementExternalResourcesRequired, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGFilterElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGFilterElementStyle, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFilterElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 511, JSSVGFilterElementTableValues, 0 };
#else
    { 35, 31, JSSVGFilterElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGFilterElementPrototypeTableValues[3] =
{
    { "setFilterRes", DontDelete|Function, (intptr_t)jsSVGFilterElementPrototypeFunctionSetFilterRes, (intptr_t)2 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGFilterElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFilterElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSSVGFilterElementPrototypeTableValues, 0 };
#else
    { 5, 3, JSSVGFilterElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGFilterElementPrototype::s_info = { "SVGFilterElementPrototype", 0, &JSSVGFilterElementPrototypeTable, 0 };

JSObject* JSSVGFilterElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFilterElement>(exec, globalObject);
}

bool JSSVGFilterElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGFilterElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGFilterElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGFilterElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGFilterElement::s_info = { "SVGFilterElement", &JSSVGElement::s_info, &JSSVGFilterElementTable, 0 };

JSSVGFilterElement::JSSVGFilterElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFilterElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGFilterElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGFilterElementPrototype(JSSVGFilterElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFilterElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFilterElement, Base>(exec, &JSSVGFilterElementTable, this, propertyName, slot);
}

bool JSSVGFilterElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFilterElement, Base>(exec, &JSSVGFilterElementTable, this, propertyName, descriptor);
}

JSValue jsSVGFilterElementFilterUnits(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterElement* castedThis = static_cast<JSSVGFilterElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->filterUnitsAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFilterElementPrimitiveUnits(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterElement* castedThis = static_cast<JSSVGFilterElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->primitiveUnitsAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFilterElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterElement* castedThis = static_cast<JSSVGFilterElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFilterElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterElement* castedThis = static_cast<JSSVGFilterElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFilterElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterElement* castedThis = static_cast<JSSVGFilterElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFilterElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterElement* castedThis = static_cast<JSSVGFilterElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFilterElementFilterResX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterElement* castedThis = static_cast<JSSVGFilterElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(castedThis->impl());
    RefPtr<SVGAnimatedInteger> obj = imp->filterResXAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFilterElementFilterResY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterElement* castedThis = static_cast<JSSVGFilterElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(castedThis->impl());
    RefPtr<SVGAnimatedInteger> obj = imp->filterResYAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFilterElementHref(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterElement* castedThis = static_cast<JSSVGFilterElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->hrefAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFilterElementXmllang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterElement* castedThis = static_cast<JSSVGFilterElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(castedThis->impl());
    return jsString(exec, imp->xmllang());
}

JSValue jsSVGFilterElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterElement* castedThis = static_cast<JSSVGFilterElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(castedThis->impl());
    return jsString(exec, imp->xmlspace());
}

JSValue jsSVGFilterElementExternalResourcesRequired(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterElement* castedThis = static_cast<JSSVGFilterElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFilterElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterElement* castedThis = static_cast<JSSVGFilterElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGFilterElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterElement* castedThis = static_cast<JSSVGFilterElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
}

void JSSVGFilterElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGFilterElement, Base>(exec, propertyName, value, &JSSVGFilterElementTable, this, slot);
}

void setJSSVGFilterElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(static_cast<JSSVGFilterElement*>(thisObject)->impl());
    imp->setXmllang(value.toString(exec));
}

void setJSSVGFilterElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(static_cast<JSSVGFilterElement*>(thisObject)->impl());
    imp->setXmlspace(value.toString(exec));
}

JSValue JSC_HOST_CALL jsSVGFilterElementPrototypeFunctionSetFilterRes(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGFilterElement::s_info))
        return throwError(exec, TypeError);
    JSSVGFilterElement* castedThisObj = static_cast<JSSVGFilterElement*>(asObject(thisValue));
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(castedThisObj->impl());
    unsigned filterResX = args.at(0).toInt32(exec);
    unsigned filterResY = args.at(1).toInt32(exec);

    imp->setFilterRes(filterResX, filterResY);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsSVGFilterElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGFilterElement::s_info))
        return throwError(exec, TypeError);
    JSSVGFilterElement* castedThisObj = static_cast<JSSVGFilterElement*>(asObject(thisValue));
    SVGFilterElement* imp = static_cast<SVGFilterElement*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}


}

#endif // ENABLE(SVG) && ENABLE(FILTERS)
