/*
* Copyright (c) 2010 Sasken Communication Technologies Ltd.
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the "{License}"
* which accompanies  this distribution, and is available
* at the URL "{LicenseUrl}".
*
* Initial Contributors:
* Chandradeep Gandhi, Sasken Communication Technologies Ltd - Initial contribution
*
* Contributors:
*
* Description:
* Interface spefication for a remote picture gallery
*
*/

#ifndef SMFGALLERY_H
#define SMFGALLERY_H

class SmfProvider;
class SmfPicture;
class SmfGalleryModel;
class SmfComment; //user id, string, and url

/**
 * Interface to a remote gallery service. This class
 * provides some basic gallery functionality to allow applications
 * to interact with a picture gallery in a social network.
 *
 * Note that branding information for the particular service implementation
 * is available from base-class functions. See also:
 * SmfProvider::serviceName(), SmfProvider::serviceIcon()
 *
 * All of the functionality described here should be implemented by a service
 * specific plug-in object.
 */
class SmfGallery : public SmfProvider
{
  Q_OBJECT;

public:
  // Seeing as this is a plug-in implementation, these will realistically
  // be generated by SMF factory of some kind
  SmfGallery(QObject* parent = 0);
  ~SmfGallery();

public:
  // Get the picture listing
  virtual QList<SmfPicture> pictures() = 0; // basic list of picture objects
  virtual SmfGalleryModel model() = 0; // maybe we can make a QItemModel-derived model?
  virtual QString description() = 0; // A user title or caption, maybe?

slots:
  // Upload an image, note these can be slots to connect to UI controls more easily
  virtual int upload(SmfPicture image) = 0;
  virtual int upload(QList<SmfPicture> images) = 0;
  virtual int postComment(SmfPicture image, SmfComment comment) = 0;

signals:
  // Notification of remote changes to the gallery,
  // probably should be done through model
  virtual void galleryUpdated() = 0;
};

#endif // SMFGALLERY_H

