/*
* Copyright (c) 2010 Sasken Communication Technologies Ltd.
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the "{License}"
* which accompanies  this distribution, and is available
* at the URL "{LicenseUrl}".
*
* Initial Contributors:
* Chandradeep Gandhi, Sasken Communication Technologies Ltd - Initial contribution
*
* Contributors:
*
* Description:
* Interface spefication for list of contacts from a site
*
*/

#ifndef SMFCONTACTHETCHER_H
#define SMFCONTACTHETCHER_H

class SmfProvider; //base-class for service provider
class SmfContact; //class for Contact in a social network
class SmfGroup; //class for a group in social network


/**
 * Interface to search for contacts/connections from a service provider. This class
 * provides basic functionality to allow applications to obtain list of
 * contacts or friends in a social networking service.
 *
 * Note that branding information for the particular service implementation
 * is available from base-class functions. See also:
 * SmfProvider::serviceName(), SmfProvider::serviceIcon(), SmfProvider::description()
 *
 * All of the functionality described here should be implemented by a service
 * specific plug-in object.
 */
class SmfContactFetcher : public SmfProvider
{
  Q_OBJECT;

public:
  // Seeing as this is a plug-in implementation, these will realistically
  // be generated by SMF factory of some kind
  SmfContactFetcher(QObject* parent = 0);
  ~SmfContactFetcher();

public:
  // Get the friend listing - might be made asynchrnous later
  virtual QList<SmfContact> friends() = 0; // list of contact objects
  virtual QList<SmfContact> followers() = 0; // list of contact objects
  virtual QList<SmfContact> search(SmfContact) = 0; // list of contact objects
  virtual QList<SmfGroup>   groups() = 0; // list of group objects
  virtual QList<SmfContact> searchInGroup(SmfGroup) = 0; // list of contact objects

  virtual SmfContactModel   model() = 0; // maybe we can make a QItemModel-derived model?


slots:

signals:
  // Notification of remote changes to the contactlist,
  // probably should be done through model
  virtual void friendsChanged() = 0;
  virtual void followersChanged() = 0;
  virtual void groupChanged() = 0;
};



#endif // SMFCONTACTHETCHER_H
